/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.base;

import com.google.common.collect.ImmutableList;
import dagger.shaded.auto.common.AnnotationMirrors;
import java.util.List;
import java.util.Optional;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.AnnotationValueVisitor;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleAnnotationValueVisitor8;

public final class MoreAnnotationValues {
    private static final AnnotationValueVisitor<ImmutableList<AnnotationValue>, String> AS_ANNOTATION_VALUES = new SimpleAnnotationValueVisitor8<ImmutableList<AnnotationValue>, String>(){

        @Override
        public ImmutableList<AnnotationValue> visitArray(List<? extends AnnotationValue> vals, String elementName) {
            return ImmutableList.copyOf(vals);
        }

        @Override
        protected ImmutableList<AnnotationValue> defaultAction(Object o, String elementName) {
            throw new IllegalArgumentException(elementName + " is not an array: " + o);
        }
    };
    private static final AnnotationValueVisitor<TypeMirror, Void> AS_TYPE = new SimpleAnnotationValueVisitor8<TypeMirror, Void>(){

        @Override
        public TypeMirror visitType(TypeMirror t, Void p) {
            return t;
        }

        @Override
        protected TypeMirror defaultAction(Object o, Void p) {
            throw new TypeNotPresentException(o.toString(), null);
        }
    };

    public static ImmutableList<AnnotationValue> asAnnotationValues(AnnotationValue annotationValue) {
        return annotationValue.accept(AS_ANNOTATION_VALUES, null);
    }

    public static TypeMirror asType(AnnotationValue annotationValue) {
        return AS_TYPE.visit(annotationValue);
    }

    public static int getIntValue(AnnotationMirror annotation, String valueName) {
        return (Integer)AnnotationMirrors.getAnnotationValue(annotation, valueName).getValue();
    }

    public static Optional<Integer> getOptionalIntValue(AnnotationMirror annotation, String valueName) {
        return MoreAnnotationValues.isValuePresent(annotation, valueName) ? Optional.of(MoreAnnotationValues.getIntValue(annotation, valueName)) : Optional.empty();
    }

    public static String getStringValue(AnnotationMirror annotation, String valueName) {
        return (String)AnnotationMirrors.getAnnotationValue(annotation, valueName).getValue();
    }

    public static Optional<String> getOptionalStringValue(AnnotationMirror annotation, String valueName) {
        return MoreAnnotationValues.isValuePresent(annotation, valueName) ? Optional.of(MoreAnnotationValues.getStringValue(annotation, valueName)) : Optional.empty();
    }

    public static int[] getIntArrayValue(AnnotationMirror annotation, String valueName) {
        return MoreAnnotationValues.asAnnotationValues(AnnotationMirrors.getAnnotationValue(annotation, valueName)).stream().mapToInt(it -> (Integer)it.getValue()).toArray();
    }

    public static String[] getStringArrayValue(AnnotationMirror annotation, String valueName) {
        return (String[])MoreAnnotationValues.asAnnotationValues(AnnotationMirrors.getAnnotationValue(annotation, valueName)).stream().map(it -> (String)it.getValue()).toArray(String[]::new);
    }

    private static boolean isValuePresent(AnnotationMirror annotation, String valueName) {
        return AnnotationMirrors.getAnnotationValuesWithDefaults(annotation).keySet().stream().anyMatch(member -> member.getSimpleName().contentEquals(valueName));
    }

    private MoreAnnotationValues() {
    }
}

