/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import dagger.internal.codegen.BindingDeclaration;
import dagger.internal.codegen.ConfigurationAnnotations;
import dagger.internal.codegen.ErrorMessages;
import dagger.internal.codegen.Formatter;
import dagger.internal.codegen.MethodSignatureFormatter;
import dagger.internal.codegen.MoreAnnotationMirrors;
import dagger.internal.codegen.SubcomponentDeclaration;
import dagger.internal.codegen.Util;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import javax.lang.model.element.Element;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

final class BindingDeclarationFormatter
extends Formatter<BindingDeclaration> {
    private final MethodSignatureFormatter methodSignatureFormatter;

    BindingDeclarationFormatter(MethodSignatureFormatter methodSignatureFormatter) {
        this.methodSignatureFormatter = methodSignatureFormatter;
    }

    @Override
    public String format(BindingDeclaration bindingDeclaration) {
        if (bindingDeclaration instanceof SubcomponentDeclaration) {
            return this.formatSubcomponentDeclaration((SubcomponentDeclaration)bindingDeclaration);
        }
        Preconditions.checkArgument((boolean)bindingDeclaration.bindingElement().isPresent(), (String)"Cannot format bindings without source elements: %s", (Object[])new Object[]{bindingDeclaration});
        Element bindingElement = (Element)bindingDeclaration.bindingElement().get();
        switch (bindingElement.asType().getKind()) {
            case EXECUTABLE: {
                return this.methodSignatureFormatter.format(MoreElements.asExecutable(bindingElement), (Optional<DeclaredType>)bindingDeclaration.contributingModule().transform(Util.AS_DECLARED_TYPE));
            }
            case DECLARED: {
                return ErrorMessages.stripCommonTypePrefixes(bindingElement.asType().toString());
            }
        }
        throw new IllegalArgumentException("Formatting unsupported for element: " + bindingElement);
    }

    private String formatSubcomponentDeclaration(SubcomponentDeclaration subcomponentDeclaration) {
        ImmutableList<TypeMirror> moduleSubcomponents = ConfigurationAnnotations.getModuleSubcomponents(subcomponentDeclaration.moduleAnnotation());
        int index = Iterables.indexOf(moduleSubcomponents, (Predicate)MoreTypes.equivalence().equivalentTo((Object)subcomponentDeclaration.subcomponentType().asType()));
        StringBuilder annotationValue = new StringBuilder();
        if (moduleSubcomponents.size() != 1) {
            annotationValue.append("{");
        }
        annotationValue.append(this.formatArgumentInList(index, moduleSubcomponents.size(), subcomponentDeclaration.subcomponentType().getQualifiedName() + ".class"));
        if (moduleSubcomponents.size() != 1) {
            annotationValue.append("}");
        }
        return String.format("@%s(subcomponents = %s) for %s", MoreAnnotationMirrors.simpleName(subcomponentDeclaration.moduleAnnotation()), annotationValue, subcomponentDeclaration.contributingModule().get());
    }
}

