/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.ParameterSpec;
import java.util.Iterator;
import javax.lang.model.type.TypeMirror;

final class CodeBlocks {
    private static final Function<TypeMirror, CodeBlock> TYPE_MIRROR_TO_CODE_BLOCK = new Function<TypeMirror, CodeBlock>(){

        public CodeBlock apply(TypeMirror typeMirror) {
            return CodeBlock.of("$T", typeMirror);
        }
    };
    static final Function<ParameterSpec, CodeBlock> PARAMETER_NAME = new Function<ParameterSpec, CodeBlock>(){

        public CodeBlock apply(ParameterSpec input) {
            return CodeBlock.of("$N", input);
        }
    };

    static CodeBlock makeParametersCodeBlock(Iterable<CodeBlock> codeBlocks) {
        return CodeBlocks.join(codeBlocks, ", ");
    }

    static CodeBlock concat(Iterable<CodeBlock> codeBlocks) {
        return CodeBlocks.join(codeBlocks, "\n");
    }

    static CodeBlock.Builder join(CodeBlock.Builder builder, Iterable<CodeBlock> codeBlocks, String delimiter) {
        Iterator<CodeBlock> iterator = codeBlocks.iterator();
        while (iterator.hasNext()) {
            builder.add(iterator.next());
            if (!iterator.hasNext()) continue;
            builder.add(delimiter, new Object[0]);
        }
        return builder;
    }

    static CodeBlock join(Iterable<CodeBlock> codeBlocks, String delimiter) {
        return CodeBlocks.join(CodeBlock.builder(), codeBlocks, delimiter).build();
    }

    static FluentIterable<CodeBlock> toCodeBlocks(Iterable<? extends TypeMirror> typeMirrors) {
        return FluentIterable.from(typeMirrors).transform(TYPE_MIRROR_TO_CODE_BLOCK);
    }

    static CodeBlock stringLiteral(String toWrap) {
        return CodeBlock.of("$S", toWrap);
    }

    private CodeBlocks() {
    }
}

