/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Optional;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Sets;
import dagger.Reusable;
import dagger.internal.codegen.AutoValue_ComponentValidator_ComponentValidationReport;
import dagger.internal.codegen.BuilderValidator;
import dagger.internal.codegen.ComponentDescriptor;
import dagger.internal.codegen.ConfigurationAnnotations;
import dagger.internal.codegen.ErrorMessages;
import dagger.internal.codegen.ModuleDescriptor;
import dagger.internal.codegen.ModuleValidator;
import dagger.internal.codegen.ValidationReport;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleTypeVisitor6;
import javax.lang.model.util.Types;

final class ComponentValidator {
    private final Elements elements;
    private final Types types;
    private final ModuleValidator moduleValidator;
    private final ComponentValidator subcomponentValidator;
    private final BuilderValidator subcomponentBuilderValidator;

    private ComponentValidator(Elements elements, Types types, ModuleValidator moduleValidator, BuilderValidator subcomponentBuilderValidator) {
        this.elements = elements;
        this.types = types;
        this.moduleValidator = moduleValidator;
        this.subcomponentValidator = this;
        this.subcomponentBuilderValidator = subcomponentBuilderValidator;
    }

    private ComponentValidator(Elements elements, Types types, ModuleValidator moduleValidator, ComponentValidator subcomponentValidator, BuilderValidator subcomponentBuilderValidator) {
        this.elements = elements;
        this.types = types;
        this.moduleValidator = moduleValidator;
        this.subcomponentValidator = subcomponentValidator;
        this.subcomponentBuilderValidator = subcomponentBuilderValidator;
    }

    static ComponentValidator createForComponent(Elements elements, Types types, ModuleValidator moduleValidator, ComponentValidator subcomponentValidator, BuilderValidator subcomponentBuilderValidator) {
        return new ComponentValidator(elements, types, moduleValidator, subcomponentValidator, subcomponentBuilderValidator);
    }

    static ComponentValidator createForSubcomponent(Elements elements, Types types, ModuleValidator moduleValidator, BuilderValidator subcomponentBuilderValidator) {
        return new ComponentValidator(elements, types, moduleValidator, subcomponentBuilderValidator);
    }

    public ComponentValidationReport validate(TypeElement subject, Set<? extends Element> validatedSubcomponents, Set<? extends Element> validatedSubcomponentBuilders) {
        Optional<AnnotationMirror> reusableAnnotation;
        ImmutableList<DeclaredType> builders;
        ValidationReport.Builder<TypeElement> builder = ValidationReport.about(subject);
        ComponentDescriptor.Kind componentKind = (ComponentDescriptor.Kind)((Object)ComponentDescriptor.Kind.forAnnotatedElement(subject).get());
        if (!(subject.getKind().equals((Object)ElementKind.INTERFACE) || subject.getKind().equals((Object)ElementKind.CLASS) && subject.getModifiers().contains((Object)Modifier.ABSTRACT))) {
            builder.addError(String.format("@%s may only be applied to an interface or abstract class", componentKind.annotationType().getSimpleName()), subject);
        }
        if ((builders = ConfigurationAnnotations.enclosedBuilders(subject, componentKind.builderAnnotationType())).size() > 1) {
            builder.addError(String.format(ErrorMessages.builderMsgsFor(componentKind).moreThanOne(), builders), subject);
        }
        if ((reusableAnnotation = MoreElements.getAnnotationMirror(subject, Reusable.class)).isPresent()) {
            builder.addError("@Reusable cannot be applied to components or subcomponents.", subject, (AnnotationMirror)reusableAnnotation.get());
        }
        DeclaredType subjectType = MoreTypes.asDeclared(subject.asType());
        List<? extends Element> members = this.elements.getAllMembers(subject);
        LinkedHashMultimap referencedSubcomponents = LinkedHashMultimap.create();
        block4: for (ExecutableElement executableElement : ElementFilter.methodsIn(members)) {
            if (!executableElement.getModifiers().contains((Object)Modifier.ABSTRACT)) continue;
            ExecutableType resolvedMethod = MoreTypes.asExecutable(this.types.asMemberOf(subjectType, executableElement));
            List<? extends TypeMirror> parameterTypes = resolvedMethod.getParameterTypes();
            List<? extends VariableElement> parameters = executableElement.getParameters();
            TypeMirror returnType = resolvedMethod.getReturnType();
            Optional<AnnotationMirror> subcomponentAnnotation = this.checkForAnnotations(returnType, (Set<Class<? extends Annotation>>)FluentIterable.from(componentKind.subcomponentKinds()).transform(ComponentDescriptor.Kind.toAnnotationType()).toSet());
            Optional<AnnotationMirror> subcomponentBuilderAnnotation = this.checkForAnnotations(returnType, (Set<Class<? extends Annotation>>)FluentIterable.from(componentKind.subcomponentKinds()).transform(ComponentDescriptor.Kind.toBuilderAnnotationType()).toSet());
            if (subcomponentAnnotation.isPresent()) {
                referencedSubcomponents.put((Object)MoreTypes.asElement(returnType), (Object)executableElement);
                this.validateSubcomponentMethod(builder, (ComponentDescriptor.Kind)((Object)ComponentDescriptor.Kind.forAnnotatedElement(MoreTypes.asTypeElement(returnType)).get()), executableElement, parameters, parameterTypes, returnType, subcomponentAnnotation);
                continue;
            }
            if (subcomponentBuilderAnnotation.isPresent()) {
                referencedSubcomponents.put((Object)MoreTypes.asElement(returnType).getEnclosingElement(), (Object)executableElement);
                this.validateSubcomponentBuilderMethod(builder, executableElement, parameters, returnType, validatedSubcomponentBuilders);
                continue;
            }
            switch (parameters.size()) {
                case 0: {
                    continue block4;
                }
                case 1: {
                    TypeMirror onlyParameter = (TypeMirror)Iterables.getOnlyElement(parameterTypes);
                    if (returnType.getKind().equals((Object)TypeKind.VOID) || this.types.isSameType(returnType, onlyParameter)) continue block4;
                    builder.addError("Members injection methods may only return the injected type or void.", executableElement);
                    continue block4;
                }
            }
            builder.addError("This method isn't a valid provision method, members injection method or subcomponent factory method. Dagger cannot implement this method", executableElement);
        }
        for (Map.Entry entry : referencedSubcomponents.asMap().entrySet()) {
            if (((Collection)entry.getValue()).size() <= 1) continue;
            builder.addError(String.format(ErrorMessages.SubcomponentBuilderMessages.INSTANCE.moreThanOneRefToSubcomponent(), entry.getKey(), entry.getValue()), subject);
        }
        AnnotationMirror componentMirror = (AnnotationMirror)MoreElements.getAnnotationMirror(subject, componentKind.annotationType()).get();
        if (componentKind.isTopLevel()) {
            ConfigurationAnnotations.validateComponentDependencies(builder, ConfigurationAnnotations.getComponentDependencies(componentMirror));
        }
        ImmutableList<TypeMirror> immutableList = ConfigurationAnnotations.getComponentModules(componentMirror);
        this.moduleValidator.validateReferencedModules(subject, builder, immutableList, componentKind.moduleKinds());
        ImmutableSet.Builder allSubcomponents = ImmutableSet.builder().addAll((Iterable)referencedSubcomponents.keySet());
        for (Element subcomponent : Sets.difference((Set)referencedSubcomponents.keySet(), validatedSubcomponents)) {
            ComponentValidationReport subreport = this.subcomponentValidator.validate(MoreElements.asType(subcomponent), validatedSubcomponents, validatedSubcomponentBuilders);
            builder.addItems((Iterable<ValidationReport.Item>)subreport.report().items());
            allSubcomponents.addAll(subreport.referencedSubcomponents());
        }
        return new AutoValue_ComponentValidator_ComponentValidationReport((Set<Element>)allSubcomponents.build(), builder.build());
    }

    private void validateSubcomponentMethod(ValidationReport.Builder<TypeElement> builder, final ComponentDescriptor.Kind subcomponentKind, ExecutableElement method, List<? extends VariableElement> parameters, List<? extends TypeMirror> parameterTypes, TypeMirror returnType, Optional<AnnotationMirror> subcomponentAnnotation) {
        ImmutableSet<TypeElement> moduleTypes = MoreTypes.asTypeElements(ConfigurationAnnotations.getComponentModules((AnnotationMirror)subcomponentAnnotation.get()));
        ImmutableSet<TypeElement> transitiveModules = ConfigurationAnnotations.getTransitiveModules(this.types, this.elements, moduleTypes);
        HashSet variableTypes = Sets.newHashSet();
        for (int i = 0; i < parameterTypes.size(); ++i) {
            VariableElement parameter = parameters.get(i);
            TypeMirror parameterType = parameterTypes.get(i);
            Optional<TypeElement> moduleType = parameterType.accept(new SimpleTypeVisitor6<Optional<TypeElement>, Void>(){

                @Override
                protected Optional<TypeElement> defaultAction(TypeMirror e, Void p) {
                    return Optional.absent();
                }

                @Override
                public Optional<TypeElement> visitDeclared(DeclaredType t, Void p) {
                    for (ModuleDescriptor.Kind moduleKind : subcomponentKind.moduleKinds()) {
                        if (!MoreElements.isAnnotationPresent(t.asElement(), moduleKind.moduleAnnotation())) continue;
                        return Optional.of((Object)MoreTypes.asTypeElement(t));
                    }
                    return Optional.absent();
                }
            }, null);
            if (moduleType.isPresent()) {
                if (variableTypes.contains(moduleType.get())) {
                    builder.addError(String.format("A module may only occur once an an argument in a Subcomponent factory method, but %s was already passed.", ((TypeElement)moduleType.get()).getQualifiedName()), parameter);
                }
                if (!transitiveModules.contains(moduleType.get())) {
                    builder.addError(String.format("%s is present as an argument to the %s factory method, but is not one of the modules used to implement the subcomponent.", ((TypeElement)moduleType.get()).getQualifiedName(), MoreTypes.asTypeElement(returnType).getQualifiedName()), method);
                }
                variableTypes.add(moduleType.get());
                continue;
            }
            builder.addError(String.format("Subcomponent factory methods may only accept modules, but %s is not.", parameterType), parameter);
        }
    }

    private void validateSubcomponentBuilderMethod(ValidationReport.Builder<TypeElement> builder, ExecutableElement method, List<? extends VariableElement> parameters, TypeMirror returnType, Set<? extends Element> validatedSubcomponentBuilders) {
        TypeElement builderElement;
        if (!parameters.isEmpty()) {
            builder.addError(ErrorMessages.SubcomponentBuilderMessages.INSTANCE.builderMethodRequiresNoArgs(), method);
        }
        if (!validatedSubcomponentBuilders.contains(builderElement = MoreTypes.asTypeElement(returnType))) {
            builder.addItems((Iterable<ValidationReport.Item>)this.subcomponentBuilderValidator.validate(builderElement).items());
        }
    }

    private Optional<AnnotationMirror> checkForAnnotations(TypeMirror type, final Set<Class<? extends Annotation>> annotations) {
        return type.accept(new SimpleTypeVisitor6<Optional<AnnotationMirror>, Void>(){

            @Override
            protected Optional<AnnotationMirror> defaultAction(TypeMirror e, Void p) {
                return Optional.absent();
            }

            @Override
            public Optional<AnnotationMirror> visitDeclared(DeclaredType t, Void p) {
                for (Class annotation : annotations) {
                    Optional<AnnotationMirror> mirror = MoreElements.getAnnotationMirror(t.asElement(), annotation);
                    if (!mirror.isPresent()) continue;
                    return mirror;
                }
                return Optional.absent();
            }
        }, null);
    }

    static abstract class ComponentValidationReport {
        ComponentValidationReport() {
        }

        abstract Set<Element> referencedSubcomponents();

        abstract ValidationReport<TypeElement> report();
    }
}

