/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.squareup.javapoet.CodeBlock;
import dagger.MapKey;
import dagger.internal.codegen.AnnotationExpression;
import dagger.shaded.auto.common.AnnotationMirrors;
import dagger.shaded.auto.common.MoreTypes;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.SimpleTypeVisitor6;
import javax.lang.model.util.Types;

final class MapKeys {
    static Optional<AnnotationMirror> getMapKey(Element bindingElement) {
        ImmutableSet<? extends AnnotationMirror> mapKeys = MapKeys.getMapKeys(bindingElement);
        return mapKeys.isEmpty() ? Optional.absent() : Optional.of((Object)Iterables.getOnlyElement(mapKeys));
    }

    static ImmutableSet<? extends AnnotationMirror> getMapKeys(Element bindingElement) {
        return AnnotationMirrors.getAnnotatedAnnotations(bindingElement, MapKey.class);
    }

    static Optional<? extends AnnotationValue> unwrapValue(AnnotationMirror mapKey) {
        MapKey mapKeyAnnotation = mapKey.getAnnotationType().asElement().getAnnotation(MapKey.class);
        Preconditions.checkArgument((mapKeyAnnotation != null ? 1 : 0) != 0, (String)"%s is not annotated with @MapKey", (Object[])new Object[]{mapKey.getAnnotationType()});
        return mapKeyAnnotation.unwrapValue() ? Optional.of((Object)Iterables.getOnlyElement(AnnotationMirrors.getAnnotationValuesWithDefaults(mapKey).values())) : Optional.absent();
    }

    public static DeclaredType getUnwrappedMapKeyType(final DeclaredType mapKeyAnnotationType, final Types types) {
        Preconditions.checkArgument((MoreTypes.asTypeElement(mapKeyAnnotationType).getKind() == ElementKind.ANNOTATION_TYPE ? 1 : 0) != 0, (String)"%s is not an annotation type", (Object[])new Object[]{mapKeyAnnotationType});
        final ExecutableElement onlyElement = (ExecutableElement)Iterables.getOnlyElement(ElementFilter.methodsIn(mapKeyAnnotationType.asElement().getEnclosedElements()));
        SimpleTypeVisitor6<DeclaredType, Void> keyTypeElementVisitor = new SimpleTypeVisitor6<DeclaredType, Void>(){

            @Override
            public DeclaredType visitArray(ArrayType t, Void p) {
                throw new IllegalArgumentException(mapKeyAnnotationType + "." + onlyElement.getSimpleName() + " cannot be an array");
            }

            @Override
            public DeclaredType visitPrimitive(PrimitiveType t, Void p) {
                return MoreTypes.asDeclared(types.boxedClass(t).asType());
            }

            @Override
            public DeclaredType visitDeclared(DeclaredType t, Void p) {
                return t;
            }
        };
        return (DeclaredType)keyTypeElementVisitor.visit(onlyElement.getReturnType());
    }

    static CodeBlock getMapKeyExpression(AnnotationMirror mapKey) {
        Optional<? extends AnnotationValue> unwrappedValue = MapKeys.unwrapValue(mapKey);
        AnnotationExpression annotationExpression = new AnnotationExpression(mapKey);
        if (unwrappedValue.isPresent()) {
            TypeMirror unwrappedValueType = ((ExecutableElement)Iterables.getOnlyElement(AnnotationMirrors.getAnnotationValuesWithDefaults(mapKey).keySet())).getReturnType();
            return annotationExpression.getValueExpression(unwrappedValueType, (AnnotationValue)unwrappedValue.get());
        }
        return annotationExpression.getAnnotationInstanceExpression();
    }

    private MapKeys() {
    }
}

