/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Equivalence;
import com.google.common.base.Preconditions;
import dagger.internal.codegen.AutoValue_OptionalType;
import dagger.internal.codegen.Key;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleTypeVisitor7;

abstract class OptionalType {
    private static final String OPTIONAL_TYPE = "com.google.common.base.Optional";
    private static final SimpleTypeVisitor7<Boolean, Void> IS_OPTIONAL = new SimpleTypeVisitor7<Boolean, Void>(Boolean.valueOf(false)){

        @Override
        public Boolean visitDeclared(DeclaredType t, Void p) {
            return MoreElements.asType(t.asElement()).getQualifiedName().contentEquals(OptionalType.OPTIONAL_TYPE);
        }
    };

    OptionalType() {
    }

    @Deprecated
    protected abstract Equivalence.Wrapper<DeclaredType> wrappedDeclaredOptionalType();

    DeclaredType declaredOptionalType() {
        return (DeclaredType)this.wrappedDeclaredOptionalType().get();
    }

    TypeMirror valueType() {
        return this.declaredOptionalType().getTypeArguments().get(0);
    }

    static boolean isOptional(TypeMirror type) {
        return type.accept(IS_OPTIONAL, null);
    }

    static boolean isOptional(Key key) {
        return OptionalType.isOptional(key.type());
    }

    static OptionalType from(TypeMirror type) {
        Preconditions.checkArgument((boolean)OptionalType.isOptional(type), (String)"%s must be an Optional", (Object[])new Object[]{type});
        return new AutoValue_OptionalType((Equivalence.Wrapper<DeclaredType>)MoreTypes.equivalence().wrap((Object)MoreTypes.asDeclared(type)));
    }

    static OptionalType from(Key key) {
        return OptionalType.from(key.type());
    }
}

