/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.xprocessing;

import com.google.common.base.Equivalence;
import com.squareup.javapoet.CodeBlock;
import dagger.internal.codegen.xprocessing.XAnnotations;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.shaded.androidx.room.compiler.processing.XAnnotationValue;
import java.util.stream.Collectors;

public final class XAnnotationValues {
    private static final Equivalence<XAnnotationValue> XANNOTATION_VALUE_EQUIVALENCE = new Equivalence<XAnnotationValue>(){

        protected boolean doEquivalent(XAnnotationValue left, XAnnotationValue right) {
            if (left.hasAnnotationValue()) {
                return right.hasAnnotationValue() && XAnnotations.equivalence().equivalent((Object)left.asAnnotation(), (Object)right.asAnnotation());
            }
            if (left.hasListValue()) {
                return right.hasListValue() && XAnnotationValues.equivalence().pairwise().equivalent(left.asAnnotationValueList(), right.asAnnotationValueList());
            }
            if (left.hasTypeValue()) {
                return right.hasTypeValue() && XTypes.equivalence().equivalent((Object)left.asType(), (Object)right.asType());
            }
            return left.getValue().equals(right.getValue());
        }

        protected int doHash(XAnnotationValue value2) {
            if (value2.hasAnnotationValue()) {
                return XAnnotations.equivalence().hash((Object)value2.asAnnotation());
            }
            if (value2.hasListValue()) {
                return XAnnotationValues.equivalence().pairwise().hash(value2.asAnnotationValueList());
            }
            if (value2.hasTypeValue()) {
                return XTypes.equivalence().hash((Object)value2.asType());
            }
            return value2.getValue().hashCode();
        }

        public String toString() {
            return "XAnnotationValues.equivalence()";
        }
    };

    public static Equivalence<XAnnotationValue> equivalence() {
        return XANNOTATION_VALUE_EQUIVALENCE;
    }

    public static String getKindName(XAnnotationValue value2) {
        if (value2.hasAnnotationListValue()) {
            return "ANNOTATION_ARRAY";
        }
        if (value2.hasAnnotationValue()) {
            return "ANNOTATION";
        }
        if (value2.hasEnumListValue()) {
            return "ENUM_ARRAY";
        }
        if (value2.hasEnumValue()) {
            return "ENUM";
        }
        if (value2.hasTypeListValue()) {
            return "TYPE_ARRAY";
        }
        if (value2.hasTypeValue()) {
            return "TYPE";
        }
        if (value2.hasBooleanListValue()) {
            return "BOOLEAN_ARRAY";
        }
        if (value2.hasBooleanValue()) {
            return "BOOLEAN";
        }
        if (value2.hasByteListValue()) {
            return "BYTE_ARRAY";
        }
        if (value2.hasByteValue()) {
            return "BYTE";
        }
        if (value2.hasCharListValue()) {
            return "CHAR_ARRAY";
        }
        if (value2.hasCharValue()) {
            return "CHAR";
        }
        if (value2.hasDoubleListValue()) {
            return "DOUBLE_ARRAY";
        }
        if (value2.hasDoubleValue()) {
            return "DOUBLE";
        }
        if (value2.hasFloatListValue()) {
            return "FLOAT_ARRAY";
        }
        if (value2.hasFloatValue()) {
            return "FLOAT";
        }
        if (value2.hasIntListValue()) {
            return "INT_ARRAY";
        }
        if (value2.hasIntValue()) {
            return "INT";
        }
        if (value2.hasLongListValue()) {
            return "LONG_ARRAY";
        }
        if (value2.hasLongValue()) {
            return "LONG";
        }
        if (value2.hasShortListValue()) {
            return "SHORT_ARRAY";
        }
        if (value2.hasShortValue()) {
            return "SHORT";
        }
        if (value2.hasStringListValue()) {
            return "STRING_ARRAY";
        }
        if (value2.hasStringValue()) {
            return "STRING";
        }
        return value2.hasListValue() ? "UNKNOWN_ARRAY" : "UNKNOWN";
    }

    public static String toStableString(XAnnotationValue value2) {
        try {
            if (value2.getValue() == null) {
                return "<error>";
            }
            if (value2.hasListValue()) {
                return value2.asAnnotationValueList().stream().map(v -> XAnnotationValues.toStableString(v)).collect(Collectors.joining(", ", "{", "}"));
            }
            if (value2.hasAnnotationValue()) {
                return XAnnotations.toStableString(value2.asAnnotation());
            }
            if (value2.hasEnumValue()) {
                return XElements.getSimpleName(value2.asEnum());
            }
            if (value2.hasTypeValue()) {
                return value2.asType().getTypeElement().getQualifiedName();
            }
            if (value2.hasStringValue()) {
                return CodeBlock.of((String)"$S", (Object[])new Object[]{value2.asString()}).toString();
            }
            if (value2.hasCharValue()) {
                return XAnnotationValues.characterLiteralWithSingleQuotes(value2.asChar());
            }
            return value2.getValue().toString();
        }
        catch (TypeNotPresentException e) {
            return e.typeName();
        }
    }

    public static String characterLiteralWithSingleQuotes(char c) {
        return "'" + XAnnotationValues.characterLiteralWithoutSingleQuotes(c) + "'";
    }

    private static String characterLiteralWithoutSingleQuotes(char c) {
        switch (c) {
            case '\b': {
                return "\\b";
            }
            case '\t': {
                return "\\t";
            }
            case '\n': {
                return "\\n";
            }
            case '\f': {
                return "\\f";
            }
            case '\r': {
                return "\\r";
            }
            case '\"': {
                return "\"";
            }
            case '\'': {
                return "\\'";
            }
            case '\\': {
                return "\\\\";
            }
        }
        return Character.isISOControl(c) ? String.format("\\u%04x", c) : Character.toString(c);
    }

    private XAnnotationValues() {
    }
}

