/*
 * Decompiled with CFR 0.152.
 */
package dagger.spi.model;

import com.google.auto.value.AutoValue;
import com.google.devtools.ksp.symbol.KSAnnotation;
import dagger.spi.model.AutoValue_DaggerAnnotation;
import dagger.spi.model.DaggerProcessingEnv;
import dagger.spi.model.DaggerTypeElement;
import dagger.spi.shaded.auto.common.AnnotationMirrors;
import javax.annotation.Nullable;
import javax.lang.model.element.AnnotationMirror;

@AutoValue
public abstract class DaggerAnnotation {
    public static DaggerAnnotation fromJavac(DaggerTypeElement annotationTypeElement, AnnotationMirror annotation) {
        return new AutoValue_DaggerAnnotation(annotationTypeElement, annotation, null);
    }

    public static DaggerAnnotation fromKsp(DaggerTypeElement annotationTypeElement, KSAnnotation ksp) {
        return new AutoValue_DaggerAnnotation(annotationTypeElement, null, ksp);
    }

    public abstract DaggerTypeElement annotationTypeElement();

    @Nullable
    public abstract AnnotationMirror java();

    @Nullable
    public abstract KSAnnotation ksp();

    public DaggerProcessingEnv.Backend backend() {
        if (this.java() != null) {
            return DaggerProcessingEnv.Backend.JAVAC;
        }
        if (this.ksp() != null) {
            return DaggerProcessingEnv.Backend.KSP;
        }
        throw new AssertionError((Object)"Unexpected backend");
    }

    public final String toString() {
        switch (this.backend()) {
            case JAVAC: {
                return AnnotationMirrors.toString(this.java());
            }
            case KSP: {
                return this.ksp().toString();
            }
        }
        throw new IllegalStateException(String.format("Backend %s not supported yet.", new Object[]{this.backend()}));
    }
}

