/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.plugin.sdk;

import org.objectweb.asm.Type;
import org.objectweb.asm.commons.AdviceAdapter;
import org.objectweb.asm.commons.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FirebaseTrace {
    private Type mClass = Type.getType((String)"com/google/firebase/perf/metrics/Trace");
    private final AdviceAdapter mAdviceAdapter;
    private int mTimerLocalIndex = -1;
    Logger mLogger = LoggerFactory.getLogger((String)"FirebaseTrace");

    public FirebaseTrace(AdviceAdapter methodVisitor) {
        this.mAdviceAdapter = methodVisitor;
    }

    public void start(String timerName) throws NoSuchMethodException {
        this.mTimerLocalIndex = this.mAdviceAdapter.newLocal(this.mClass);
        this.mAdviceAdapter.push(timerName);
        this.mAdviceAdapter.invokeStatic(Type.getType((String)"com/google/firebase/perf/FirebasePerformance"), new Method("startTrace", "(Ljava/lang/String;)Lcom/google/firebase/perf/metrics/Trace;"));
        this.mAdviceAdapter.storeLocal(this.mTimerLocalIndex);
    }

    public void stop() throws NoSuchMethodException {
        if (this.mTimerLocalIndex == -1) {
            throw new IllegalStateException("FirebaseTrace.stop called without calling FirebaseTrace.start");
        }
        this.mAdviceAdapter.loadLocal(this.mTimerLocalIndex);
        Method stop = new Method("stop", "()V");
        this.mAdviceAdapter.invokeVirtual(this.mClass, stop);
    }
}

