/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile;

import java.util.Objects;
import proguard.classfile.ClassSignature;
import proguard.classfile.Clazz;
import proguard.classfile.Field;
import proguard.classfile.FieldSignature;
import proguard.classfile.Member;
import proguard.classfile.Method;
import proguard.classfile.MethodSignature;
import proguard.classfile.util.ClassUtil;

public abstract class Signature
implements Comparable<Signature> {
    private static boolean cacheEnabled = false;
    protected String fqn;
    protected String prettyFqn;
    protected final String packageName;
    protected final String className;

    protected Signature(String className) {
        this.className = className;
        this.packageName = className == null ? "?" : ClassUtil.externalPackageName(ClassUtil.externalClassName(className));
    }

    public static Signature of(Clazz clazz, Member member) {
        if (cacheEnabled) {
            return Signature.computeIfAbsent(clazz, member);
        }
        if (member == null) {
            return new ClassSignature(clazz);
        }
        if (member instanceof Field) {
            return new FieldSignature(clazz, (Field)member);
        }
        return new MethodSignature(clazz, (Method)member);
    }

    public static Signature computeIfAbsent(Clazz clazz, Member member) {
        if (member == null) {
            return ClassSignature.computeIfAbsent(clazz);
        }
        if (member instanceof Field) {
            return FieldSignature.computeIfAbsent(clazz, (Field)member);
        }
        return MethodSignature.computeIfAbsent(clazz, (Method)member);
    }

    public static void clearCache() {
        ClassSignature.clearCache();
        MethodSignature.clearCache();
        FieldSignature.clearCache();
    }

    public static void setCacheEnabled(boolean cacheEnabled) {
        Signature.cacheEnabled = cacheEnabled;
        if (!cacheEnabled) {
            Signature.clearCache();
        }
    }

    public String getFqn() {
        if (this.fqn == null) {
            this.fqn = this.calculateFqn();
        }
        return this.fqn;
    }

    public String getPrettyFqn() {
        if (this.prettyFqn == null) {
            this.prettyFqn = this.calculatePrettyFqn();
        }
        return this.prettyFqn;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getClassName() {
        return this.className;
    }

    protected abstract String calculateFqn();

    protected abstract String calculatePrettyFqn();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Signature signature = (Signature)o;
        return Objects.equals(this.packageName, signature.packageName) && Objects.equals(this.className, signature.className);
    }

    public int hashCode() {
        return Objects.hash(this.packageName, this.className);
    }

    @Override
    public int compareTo(Signature o) {
        if (o == null || this.getClass() != o.getClass()) {
            return -1;
        }
        return this.getFqn().compareTo(o.getFqn());
    }

    public String toString() {
        return this.getFqn();
    }
}

