/*
 * Decompiled with CFR 0.152.
 */
package proguard.io;

import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import proguard.io.DataEntry;
import proguard.io.DataEntryWriter;
import proguard.io.DummyDataEntry;
import proguard.io.FixedFileWriter;
import proguard.io.RenamedDataEntry;
import proguard.io.ZipWriter;
import proguard.util.Base64Util;
import proguard.util.FileNameParser;
import proguard.util.FixedStringMatcher;
import proguard.util.ListParser;
import proguard.util.StringFunction;
import proguard.util.StringMatcher;

public class JarWriter
implements DataEntryWriter {
    public static final String DEFAULT_DIGEST_ALGORITHM = "SHA-256";
    private static final String FORCED_DIGEST_ALGORITHM = System.getProperty("digest.algorithm");
    private static final String MANIFEST_MF = "META-INF/MANIFEST.MF";
    private static final StringMatcher EXCLUDED_FILE_NAME_MATCHER = new ListParser(new FileNameParser()).parse("META-INF/MANIFEST.MF,META-INF/*.SF,META-INF/*.DSA,META-INF/*.RSA,META-INF/SIG-*");
    protected final String[] digestAlgorithms;
    protected final String creator;
    private final String manifestFileName;
    private final StringFunction manifestEntryNameFunction;
    protected final DataEntryWriter zipEntryWriter;
    protected final DataEntryWriter manifestEntryWriter;
    protected DataEntry currentManifestEntry;
    private PrintWriter manifestWriter;

    public JarWriter(DataEntryWriter zipEntryWriter) {
        this(new String[]{DEFAULT_DIGEST_ALGORITHM}, zipEntryWriter);
    }

    public JarWriter(String[] digestAlgorithms, DataEntryWriter zipEntryWriter) {
        this(digestAlgorithms, null, zipEntryWriter);
    }

    public JarWriter(String[] digestAlgorithms, String creator, DataEntryWriter zipEntryWriter) {
        this(digestAlgorithms, creator, MANIFEST_MF, StringFunction.IDENTITY_FUNCTION, zipEntryWriter, zipEntryWriter);
    }

    public JarWriter(String[] digestAlgorithms, String creator, String manifestFileName, StringFunction manifestEntryNameFunction, DataEntryWriter zipEntryWriter, DataEntryWriter manifestEntryWriter) {
        String[] stringArray;
        if (FORCED_DIGEST_ALGORITHM != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = FORCED_DIGEST_ALGORITHM;
        } else {
            stringArray = digestAlgorithms;
        }
        this.digestAlgorithms = stringArray;
        this.creator = creator;
        this.manifestFileName = manifestFileName;
        this.manifestEntryNameFunction = manifestEntryNameFunction;
        this.zipEntryWriter = zipEntryWriter;
        this.manifestEntryWriter = manifestEntryWriter;
    }

    @Override
    public boolean createDirectory(DataEntry dataEntry) throws IOException {
        return this.zipEntryWriter.createDirectory(dataEntry);
    }

    @Override
    public boolean sameOutputStream(DataEntry dataEntry1, DataEntry dataEntry2) throws IOException {
        return this.zipEntryWriter.sameOutputStream(dataEntry1, dataEntry2);
    }

    @Override
    public OutputStream createOutputStream(DataEntry dataEntry) throws IOException {
        String dataEntryName = dataEntry.getName();
        this.finishIfNecessary(dataEntry);
        if (EXCLUDED_FILE_NAME_MATCHER.matches(dataEntryName)) {
            return null;
        }
        this.setUp(dataEntry);
        OutputStream outputStream = this.zipEntryWriter.createOutputStream(dataEntry);
        return outputStream == null || this.manifestWriter == null ? outputStream : new MyMultiDigestOutputStream(this.manifestEntryNameFunction.transform(dataEntryName), this.createMessageDigests(this.digestAlgorithms), this.manifestWriter, outputStream);
    }

    @Override
    public void close() throws IOException {
        this.finish();
        this.zipEntryWriter.close();
    }

    @Override
    public void println(PrintWriter pw, String prefix) {
        pw.println(prefix + "JarWriter");
        this.zipEntryWriter.println(pw, prefix + "  ");
    }

    private void setUp(DataEntry dataEntry) throws IOException {
        if (this.currentManifestEntry == null) {
            this.currentManifestEntry = new RenamedDataEntry(dataEntry, this.manifestFileName);
            this.openManifestFiles();
        }
    }

    protected void openManifestFiles() throws IOException {
        OutputStream manifestOutputStream = this.createManifestOutputStream(this.currentManifestEntry);
        if (manifestOutputStream != null) {
            this.manifestWriter = this.printWriter(manifestOutputStream);
            this.manifestWriter.println("Manifest-Version: 1.0");
            if (this.creator != null) {
                this.manifestWriter.println("Created-By: " + this.creator);
            }
            this.manifestWriter.println();
            this.manifestWriter.flush();
        }
    }

    protected OutputStream createManifestOutputStream(DataEntry manifestEntry) throws IOException {
        return this.manifestEntryWriter.createOutputStream(manifestEntry);
    }

    protected void finishIfNecessary(DataEntry dataEntry) throws IOException {
        if (this.currentManifestEntry != null && !this.zipEntryWriter.sameOutputStream(this.currentManifestEntry, new RenamedDataEntry(dataEntry, this.manifestFileName))) {
            this.finish();
        }
    }

    protected void finish() throws IOException {
        if (this.manifestWriter != null) {
            this.manifestWriter.close();
            this.currentManifestEntry = null;
            this.manifestWriter = null;
        }
    }

    protected PrintWriter printWriter(OutputStream outputStream) throws IOException {
        return new PrintWriter(new OutputStreamWriter(outputStream, StandardCharsets.UTF_8));
    }

    private MessageDigest[] createMessageDigests(String[] digestAlgorithms) {
        try {
            MessageDigest[] manifestDigests = new MessageDigest[digestAlgorithms.length];
            for (int index = 0; index < digestAlgorithms.length; ++index) {
                manifestDigests[index] = MessageDigest.getInstance(digestAlgorithms[index]);
            }
            return manifestDigests;
        }
        catch (Exception e) {
            throw new UnsupportedOperationException(e.getMessage(), e);
        }
    }

    public static void main(String[] args) {
        try {
            String jarFileName = args[0];
            JarWriter writer = new JarWriter(new ZipWriter(new FixedStringMatcher("file1.txt"), 4, false, 0, new FixedFileWriter(new File(jarFileName))));
            PrintWriter printWriter = new PrintWriter(writer.createOutputStream(new DummyDataEntry(null, "file1.txt", 0L, false)));
            printWriter.println("Hello, world!");
            printWriter.close();
            printWriter = new PrintWriter(writer.createOutputStream(new DummyDataEntry(null, "file2.txt", 0L, false)));
            printWriter.println("Hello again, world!");
            printWriter.close();
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected static class MyMultiDigestOutputStream
    extends FilterOutputStream {
        private final String entryName;
        private final MessageDigest[] manifestDigests;
        private final PrintWriter manifestWriter;

        public MyMultiDigestOutputStream(String entryName, MessageDigest[] manifestDigests, PrintWriter manifestWriter, OutputStream outputStream) {
            super(outputStream);
            this.entryName = entryName;
            this.manifestDigests = manifestDigests;
            this.manifestWriter = manifestWriter;
        }

        @Override
        public void write(int b) throws IOException {
            this.out.write(b);
            for (int index = 0; index < this.manifestDigests.length; ++index) {
                this.manifestDigests[index].update((byte)b);
            }
        }

        @Override
        public void write(byte[] bytes, int off, int len) throws IOException {
            this.out.write(bytes, off, len);
            for (int index = 0; index < this.manifestDigests.length; ++index) {
                this.manifestDigests[index].update(bytes, off, len);
            }
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.appendDigests(this.entryName);
        }

        private void appendDigests(String entryName) {
            this.manifestWriter.println("Name: " + entryName);
            for (int index = 0; index < this.manifestDigests.length; ++index) {
                MessageDigest manifestDigest = this.manifestDigests[index];
                this.manifestWriter.println(manifestDigest.getAlgorithm() + "-Digest: " + Base64Util.encode(manifestDigest.digest()));
            }
            this.manifestWriter.println();
            this.manifestWriter.flush();
        }
    }
}

