/*
 * Decompiled with CFR 0.152.
 */
package com.haibin.calendarview;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import java.util.ArrayList;
import java.util.List;

abstract class BaseRecyclerAdapter<T>
extends RecyclerView.Adapter {
    LayoutInflater mInflater;
    private List<T> mItems;
    private OnItemClickListener onItemClickListener;
    private OnClickListener onClickListener;
    Context mContext;

    BaseRecyclerAdapter(Context context) {
        this.mContext = context;
        this.mItems = new ArrayList<T>();
        this.mInflater = LayoutInflater.from((Context)context);
        this.onClickListener = new OnClickListener(){

            @Override
            public void onClick(int position, long itemId) {
                if (BaseRecyclerAdapter.this.onItemClickListener != null) {
                    BaseRecyclerAdapter.this.onItemClickListener.onItemClick(position, itemId);
                }
            }
        };
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        RecyclerView.ViewHolder holder = this.onCreateDefaultViewHolder(parent, viewType);
        if (holder != null) {
            holder.itemView.setTag((Object)holder);
            holder.itemView.setOnClickListener((View.OnClickListener)this.onClickListener);
        }
        return holder;
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        this.onBindViewHolder(holder, this.mItems.get(position), position);
    }

    abstract RecyclerView.ViewHolder onCreateDefaultViewHolder(ViewGroup var1, int var2);

    abstract void onBindViewHolder(RecyclerView.ViewHolder var1, T var2, int var3);

    public int getItemCount() {
        return this.mItems.size();
    }

    void setOnItemClickListener(OnItemClickListener onItemClickListener) {
        this.onItemClickListener = onItemClickListener;
    }

    void addAll(List<T> items) {
        if (items != null && items.size() > 0) {
            this.mItems.addAll(items);
            this.notifyItemRangeInserted(this.mItems.size(), items.size());
        }
    }

    final void addItem(T item) {
        if (item != null) {
            this.mItems.add(item);
            this.notifyItemChanged(this.mItems.size());
        }
    }

    final List<T> getItems() {
        return this.mItems;
    }

    final T getItem(int position) {
        if (position < 0 || position >= this.mItems.size()) {
            return null;
        }
        return this.mItems.get(position);
    }

    static interface OnItemClickListener {
        public void onItemClick(int var1, long var2);
    }

    static abstract class OnClickListener
    implements View.OnClickListener {
        OnClickListener() {
        }

        public void onClick(View v) {
            RecyclerView.ViewHolder holder = (RecyclerView.ViewHolder)v.getTag();
            this.onClick(holder.getAdapterPosition(), holder.getItemId());
        }

        public abstract void onClick(int var1, long var2);
    }
}

