/*
 * Decompiled with CFR 0.152.
 */
package com.haibin.calendarview;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Paint;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import com.haibin.calendarview.Calendar;
import com.haibin.calendarview.CalendarLayout;
import com.haibin.calendarview.CalendarUtil;
import com.haibin.calendarview.CalendarViewDelegate;
import java.util.List;

public abstract class BaseView
extends View
implements View.OnClickListener,
View.OnLongClickListener {
    CalendarViewDelegate mDelegate;
    protected Paint mCurMonthTextPaint = new Paint();
    protected Paint mOtherMonthTextPaint = new Paint();
    protected Paint mCurMonthLunarTextPaint = new Paint();
    protected Paint mSelectedLunarTextPaint = new Paint();
    protected Paint mOtherMonthLunarTextPaint = new Paint();
    protected Paint mSchemeLunarTextPaint = new Paint();
    protected Paint mSchemePaint = new Paint();
    protected Paint mSelectedPaint = new Paint();
    protected Paint mSchemeTextPaint = new Paint();
    protected Paint mSelectTextPaint = new Paint();
    protected Paint mCurDayTextPaint = new Paint();
    protected Paint mCurDayLunarTextPaint = new Paint();
    CalendarLayout mParentLayout;
    List<Calendar> mItems;
    protected int mItemHeight;
    protected int mItemWidth;
    protected float mTextBaseLine;
    float mX;
    float mY;
    boolean isClick = true;
    static final int TEXT_SIZE = 14;
    int mCurrentItem = -1;

    public BaseView(Context context) {
        this(context, null);
    }

    public BaseView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.initPaint(context);
    }

    private void initPaint(Context context) {
        this.mCurMonthTextPaint.setAntiAlias(true);
        this.mCurMonthTextPaint.setTextAlign(Paint.Align.CENTER);
        this.mCurMonthTextPaint.setColor(-15658735);
        this.mCurMonthTextPaint.setFakeBoldText(true);
        this.mCurMonthTextPaint.setTextSize((float)CalendarUtil.dipToPx(context, 14.0f));
        this.mOtherMonthTextPaint.setAntiAlias(true);
        this.mOtherMonthTextPaint.setTextAlign(Paint.Align.CENTER);
        this.mOtherMonthTextPaint.setColor(-1973791);
        this.mOtherMonthTextPaint.setFakeBoldText(true);
        this.mOtherMonthTextPaint.setTextSize((float)CalendarUtil.dipToPx(context, 14.0f));
        this.mCurMonthLunarTextPaint.setAntiAlias(true);
        this.mCurMonthLunarTextPaint.setTextAlign(Paint.Align.CENTER);
        this.mSelectedLunarTextPaint.setAntiAlias(true);
        this.mSelectedLunarTextPaint.setTextAlign(Paint.Align.CENTER);
        this.mOtherMonthLunarTextPaint.setAntiAlias(true);
        this.mOtherMonthLunarTextPaint.setTextAlign(Paint.Align.CENTER);
        this.mSchemeLunarTextPaint.setAntiAlias(true);
        this.mSchemeLunarTextPaint.setTextAlign(Paint.Align.CENTER);
        this.mSchemeTextPaint.setAntiAlias(true);
        this.mSchemeTextPaint.setStyle(Paint.Style.FILL);
        this.mSchemeTextPaint.setTextAlign(Paint.Align.CENTER);
        this.mSchemeTextPaint.setColor(-1223853);
        this.mSchemeTextPaint.setFakeBoldText(true);
        this.mSchemeTextPaint.setTextSize((float)CalendarUtil.dipToPx(context, 14.0f));
        this.mSelectTextPaint.setAntiAlias(true);
        this.mSelectTextPaint.setStyle(Paint.Style.FILL);
        this.mSelectTextPaint.setTextAlign(Paint.Align.CENTER);
        this.mSelectTextPaint.setColor(-1223853);
        this.mSelectTextPaint.setFakeBoldText(true);
        this.mSelectTextPaint.setTextSize((float)CalendarUtil.dipToPx(context, 14.0f));
        this.mSchemePaint.setAntiAlias(true);
        this.mSchemePaint.setStyle(Paint.Style.FILL);
        this.mSchemePaint.setStrokeWidth(2.0f);
        this.mSchemePaint.setColor(-1052689);
        this.mCurDayTextPaint.setAntiAlias(true);
        this.mCurDayTextPaint.setTextAlign(Paint.Align.CENTER);
        this.mCurDayTextPaint.setColor(-65536);
        this.mCurDayTextPaint.setFakeBoldText(true);
        this.mCurDayTextPaint.setTextSize((float)CalendarUtil.dipToPx(context, 14.0f));
        this.mCurDayLunarTextPaint.setAntiAlias(true);
        this.mCurDayLunarTextPaint.setTextAlign(Paint.Align.CENTER);
        this.mCurDayLunarTextPaint.setColor(-65536);
        this.mCurDayLunarTextPaint.setFakeBoldText(true);
        this.mCurDayLunarTextPaint.setTextSize((float)CalendarUtil.dipToPx(context, 14.0f));
        this.mSelectedPaint.setAntiAlias(true);
        this.mSelectedPaint.setStyle(Paint.Style.FILL);
        this.mSelectedPaint.setStrokeWidth(2.0f);
        this.setOnClickListener(this);
        this.setOnLongClickListener(this);
    }

    void setup(CalendarViewDelegate delegate) {
        this.mDelegate = delegate;
        this.mCurDayTextPaint.setColor(delegate.getCurDayTextColor());
        this.mCurDayLunarTextPaint.setColor(delegate.getCurDayLunarTextColor());
        this.mCurMonthTextPaint.setColor(delegate.getCurrentMonthTextColor());
        this.mOtherMonthTextPaint.setColor(delegate.getOtherMonthTextColor());
        this.mCurMonthLunarTextPaint.setColor(delegate.getCurrentMonthLunarTextColor());
        this.mSelectedLunarTextPaint.setColor(delegate.getSelectedLunarTextColor());
        this.mSelectTextPaint.setColor(delegate.getSelectedTextColor());
        this.mOtherMonthLunarTextPaint.setColor(delegate.getOtherMonthLunarTextColor());
        this.mSchemeLunarTextPaint.setColor(delegate.getSchemeLunarTextColor());
        this.mSchemePaint.setColor(delegate.getSchemeThemeColor());
        this.mSchemeTextPaint.setColor(delegate.getSchemeTextColor());
        this.mCurMonthTextPaint.setTextSize((float)delegate.getDayTextSize());
        this.mOtherMonthTextPaint.setTextSize((float)delegate.getDayTextSize());
        this.mCurDayTextPaint.setTextSize((float)delegate.getDayTextSize());
        this.mSchemeTextPaint.setTextSize((float)delegate.getDayTextSize());
        this.mSelectTextPaint.setTextSize((float)delegate.getDayTextSize());
        this.mCurMonthLunarTextPaint.setTextSize((float)delegate.getLunarTextSize());
        this.mSelectedLunarTextPaint.setTextSize((float)delegate.getLunarTextSize());
        this.mCurDayLunarTextPaint.setTextSize((float)delegate.getLunarTextSize());
        this.mOtherMonthLunarTextPaint.setTextSize((float)delegate.getLunarTextSize());
        this.mSchemeLunarTextPaint.setTextSize((float)delegate.getLunarTextSize());
        this.mSelectedPaint.setStyle(Paint.Style.FILL);
        this.mSelectedPaint.setColor(delegate.getSelectedThemeColor());
        this.setItemHeight(delegate.getCalendarItemHeight());
    }

    final void removeSchemes() {
        for (Calendar a : this.mItems) {
            a.setScheme("");
            a.setSchemeColor(0);
            a.setSchemes(null);
        }
    }

    final void addSchemesFromList() {
        if (this.mDelegate.mSchemeDate == null || this.mDelegate.mSchemeDate.size() == 0) {
            return;
        }
        for (Calendar a : this.mItems) {
            if (this.mDelegate.mSchemeDate.contains(a)) {
                Calendar d = this.mDelegate.mSchemeDate.get(this.mDelegate.mSchemeDate.indexOf(a));
                a.setScheme(TextUtils.isEmpty((CharSequence)d.getScheme()) ? this.mDelegate.getSchemeText() : d.getScheme());
                a.setSchemeColor(d.getSchemeColor());
                a.setSchemes(d.getSchemes());
                continue;
            }
            a.setScheme("");
            a.setSchemeColor(0);
            a.setSchemes(null);
        }
    }

    final void addSchemesFromMap() {
        if (this.mDelegate.mSchemeDatesMap == null || this.mDelegate.mSchemeDatesMap.size() == 0) {
            return;
        }
        for (Calendar a : this.mItems) {
            if (this.mDelegate.mSchemeDatesMap.containsKey(a.toString())) {
                Calendar d = this.mDelegate.mSchemeDatesMap.get(a.toString());
                a.setScheme(TextUtils.isEmpty((CharSequence)d.getScheme()) ? this.mDelegate.getSchemeText() : d.getScheme());
                a.setSchemeColor(d.getSchemeColor());
                a.setSchemes(d.getSchemes());
                continue;
            }
            a.setScheme("");
            a.setSchemeColor(0);
            a.setSchemes(null);
        }
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(MotionEvent event) {
        if (event.getPointerCount() > 1) {
            return false;
        }
        switch (event.getAction()) {
            case 0: {
                this.mX = event.getX();
                this.mY = event.getY();
                this.isClick = true;
                break;
            }
            case 2: {
                if (!this.isClick) break;
                float mDY = event.getY() - this.mY;
                this.isClick = Math.abs(mDY) <= 50.0f;
                break;
            }
            case 1: {
                this.mX = event.getX();
                this.mY = event.getY();
            }
        }
        return super.onTouchEvent(event);
    }

    protected void onPreviewHook() {
    }

    private void setItemHeight(int itemHeight) {
        this.mItemHeight = itemHeight;
        Paint.FontMetrics metrics = this.mCurMonthTextPaint.getFontMetrics();
        this.mTextBaseLine = (float)(this.mItemHeight / 2) - metrics.descent + (metrics.bottom - metrics.top) / 2.0f;
    }

    protected boolean isSelected(Calendar calendar) {
        return this.mItems != null && this.mItems.indexOf(calendar) == this.mCurrentItem;
    }

    final void update() {
        if (this.mDelegate.getSchemeType() == 1) {
            if (this.mDelegate.mSchemeDate == null || this.mDelegate.mSchemeDate.size() == 0) {
                this.removeSchemes();
                this.invalidate();
                return;
            }
            this.addSchemesFromList();
        } else {
            if (this.mDelegate.mSchemeDatesMap == null || this.mDelegate.mSchemeDatesMap.size() == 0) {
                this.removeSchemes();
                this.invalidate();
                return;
            }
            this.addSchemesFromMap();
        }
        this.invalidate();
    }

    protected boolean onCalendarIntercept(Calendar calendar) {
        return this.mDelegate.mCalendarInterceptListener != null && this.mDelegate.mCalendarInterceptListener.onCalendarIntercept(calendar);
    }

    protected final boolean isInRange(Calendar calendar) {
        return this.mDelegate != null && CalendarUtil.isCalendarInRange(calendar, this.mDelegate);
    }

    abstract void updateCurrentDate();

    protected abstract void onDestroy();
}

