/*
 * Decompiled with CFR 0.152.
 */
package com.haibin.calendarview;

import android.text.TextUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public final class Calendar
implements Serializable {
    private static final long serialVersionUID = 141315161718191143L;
    private int year;
    private int month;
    private int leapMonth;
    private int day;
    private boolean isLeapYear;
    private boolean isCurrentMonth;
    private boolean isCurrentDay;
    private String lunar;
    private String solarTerm;
    private String gregorianFestival;
    private String traditionFestival;
    private String scheme;
    private int schemeColor;
    private List<Scheme> schemes;
    private boolean isWeekend;
    private int week;
    private Calendar lunarCakendar;

    public int getYear() {
        return this.year;
    }

    public void setYear(int year) {
        this.year = year;
    }

    public int getMonth() {
        return this.month;
    }

    public void setMonth(int month) {
        this.month = month;
    }

    public int getDay() {
        return this.day;
    }

    public void setDay(int day) {
        this.day = day;
    }

    public boolean isCurrentMonth() {
        return this.isCurrentMonth;
    }

    public void setCurrentMonth(boolean currentMonth) {
        this.isCurrentMonth = currentMonth;
    }

    public boolean isCurrentDay() {
        return this.isCurrentDay;
    }

    public void setCurrentDay(boolean currentDay) {
        this.isCurrentDay = currentDay;
    }

    public String getLunar() {
        return this.lunar;
    }

    public void setLunar(String lunar) {
        this.lunar = lunar;
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public int getSchemeColor() {
        return this.schemeColor;
    }

    public void setSchemeColor(int schemeColor) {
        this.schemeColor = schemeColor;
    }

    public List<Scheme> getSchemes() {
        return this.schemes;
    }

    public void setSchemes(List<Scheme> schemes) {
        this.schemes = schemes;
    }

    public void addScheme(Scheme scheme) {
        if (this.schemes == null) {
            this.schemes = new ArrayList<Scheme>();
        }
        this.schemes.add(scheme);
    }

    public void addScheme(int schemeColor, String scheme) {
        if (this.schemes == null) {
            this.schemes = new ArrayList<Scheme>();
        }
        this.schemes.add(new Scheme(schemeColor, scheme));
    }

    public void addScheme(int type, int schemeColor, String scheme) {
        if (this.schemes == null) {
            this.schemes = new ArrayList<Scheme>();
        }
        this.schemes.add(new Scheme(type, schemeColor, scheme));
    }

    public void addScheme(int type, int schemeColor, String scheme, String other) {
        if (this.schemes == null) {
            this.schemes = new ArrayList<Scheme>();
        }
        this.schemes.add(new Scheme(type, schemeColor, scheme, other));
    }

    public void addScheme(int schemeColor, String scheme, String other) {
        if (this.schemes == null) {
            this.schemes = new ArrayList<Scheme>();
        }
        this.schemes.add(new Scheme(schemeColor, scheme, other));
    }

    public boolean isWeekend() {
        return this.isWeekend;
    }

    public void setWeekend(boolean weekend) {
        this.isWeekend = weekend;
    }

    public int getWeek() {
        return this.week;
    }

    public void setWeek(int week) {
        this.week = week;
    }

    public Calendar getLunarCakendar() {
        return this.lunarCakendar;
    }

    public void setLunarCakendar(Calendar lunarCakendar) {
        this.lunarCakendar = lunarCakendar;
    }

    public String getSolarTerm() {
        return this.solarTerm;
    }

    public void setSolarTerm(String solarTerm) {
        this.solarTerm = solarTerm;
    }

    public String getGregorianFestival() {
        return this.gregorianFestival;
    }

    public void setGregorianFestival(String gregorianFestival) {
        this.gregorianFestival = gregorianFestival;
    }

    public int getLeapMonth() {
        return this.leapMonth;
    }

    public void setLeapMonth(int leapMonth) {
        this.leapMonth = leapMonth;
    }

    public boolean isLeapYear() {
        return this.isLeapYear;
    }

    public void setLeapYear(boolean leapYear) {
        this.isLeapYear = leapYear;
    }

    public String getTraditionFestival() {
        return this.traditionFestival;
    }

    public void setTraditionFestival(String traditionFestival) {
        this.traditionFestival = traditionFestival;
    }

    public boolean hasScheme() {
        if (this.schemes != null && this.schemes.size() != 0) {
            return true;
        }
        return !TextUtils.isEmpty((CharSequence)this.scheme);
    }

    public boolean isSameMonth(Calendar calendar) {
        return this.year == calendar.getYear() && this.month == calendar.getMonth();
    }

    public int compareTo(Calendar calendar) {
        return this.toString().compareTo(calendar.toString());
    }

    public boolean isAvailable() {
        return this.year > 0 & this.month > 0 & this.day > 0;
    }

    public long getTimeInMillis() {
        java.util.Calendar calendar = java.util.Calendar.getInstance();
        calendar.set(1, this.year);
        calendar.set(2, this.month - 1);
        calendar.set(5, this.day);
        return calendar.getTimeInMillis();
    }

    public boolean equals(Object o) {
        if (o != null && o instanceof Calendar && ((Calendar)o).getYear() == this.year && ((Calendar)o).getMonth() == this.month && ((Calendar)o).getDay() == this.day) {
            return true;
        }
        return super.equals(o);
    }

    public String toString() {
        return this.year + "" + (this.month < 10 ? "0" + this.month : Integer.valueOf(this.month)) + "" + (this.day < 10 ? "0" + this.day : Integer.valueOf(this.day));
    }

    void mergeScheme(Calendar calendar, String defaultScheme) {
        if (calendar == null) {
            return;
        }
        this.setScheme(TextUtils.isEmpty((CharSequence)calendar.getScheme()) ? defaultScheme : calendar.getScheme());
        this.setSchemeColor(calendar.getSchemeColor());
        this.setSchemes(calendar.getSchemes());
    }

    void clearScheme() {
        this.setScheme("");
        this.setSchemeColor(0);
        this.setSchemes(null);
    }

    public static final class Scheme
    implements Serializable {
        private int type;
        private int shcemeColor;
        private String scheme;
        private String other;

        public Scheme() {
        }

        public Scheme(int type, int shcemeColor, String scheme, String other) {
            this.type = type;
            this.shcemeColor = shcemeColor;
            this.scheme = scheme;
            this.other = other;
        }

        public Scheme(int type, int shcemeColor, String scheme) {
            this.type = type;
            this.shcemeColor = shcemeColor;
            this.scheme = scheme;
        }

        public Scheme(int shcemeColor, String scheme) {
            this.shcemeColor = shcemeColor;
            this.scheme = scheme;
        }

        public Scheme(int shcemeColor, String scheme, String other) {
            this.shcemeColor = shcemeColor;
            this.scheme = scheme;
            this.other = other;
        }

        public int getShcemeColor() {
            return this.shcemeColor;
        }

        public void setShcemeColor(int shcemeColor) {
            this.shcemeColor = shcemeColor;
        }

        public String getScheme() {
            return this.scheme;
        }

        public void setScheme(String scheme) {
            this.scheme = scheme;
        }

        public String getOther() {
            return this.other;
        }

        public void setOther(String other) {
            this.other = other;
        }

        public int getType() {
            return this.type;
        }

        public void setType(int type) {
            this.type = type;
        }
    }
}

