/*
 * Decompiled with CFR 0.152.
 */
package com.haibin.calendarview;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.support.v4.view.MotionEventCompat;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.animation.LinearInterpolator;
import android.widget.AbsListView;
import android.widget.LinearLayout;
import com.haibin.calendarview.Calendar;
import com.haibin.calendarview.CalendarUtil;
import com.haibin.calendarview.CalendarViewDelegate;
import com.haibin.calendarview.MonthViewPager;
import com.haibin.calendarview.R;
import com.haibin.calendarview.WeekBar;
import com.haibin.calendarview.WeekViewPager;
import com.haibin.calendarview.YearSelectLayout;

public class CalendarLayout
extends LinearLayout {
    private int mActivePointerId;
    private static final int ACTIVE_POINTER = 1;
    private static final int INVALID_POINTER = -1;
    private static final int CALENDAR_SHOW_MODE_BOTH_MONTH_WEEK_VIEW = 0;
    private static final int CALENDAR_SHOW_MODE_ONLY_WEEK_VIEW = 1;
    private static final int CALENDAR_SHOW_MODE_ONLY_MONTH_VIEW = 2;
    private static final int STATUS_EXPAND = 0;
    private static final int STATUS_SHRINK = 1;
    private int mDefaultStatus;
    WeekBar mWeekBar;
    MonthViewPager mMonthView;
    WeekViewPager mWeekPager;
    YearSelectLayout mYearView;
    ViewGroup mContentView;
    private static final int GESTURE_MODE_DEFAULT = 0;
    private static final int GESTURE_MODE_DISABLED = 2;
    private int mGestureMode;
    private int mCalendarShowMode;
    private int mTouchSlop;
    private int mContentViewTranslateY;
    private int mViewPagerTranslateY = 0;
    private float downY;
    private float mLastY;
    private boolean isAnimating = false;
    private int mContentViewId;
    private VelocityTracker mVelocityTracker;
    private int mMaximumVelocity;
    int mItemHeight;
    private CalendarViewDelegate mDelegate;

    public CalendarLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setOrientation(1);
        TypedArray array2 = context.obtainStyledAttributes(attrs, R.styleable.CalendarLayout);
        this.mContentViewId = array2.getResourceId(R.styleable.CalendarLayout_calendar_content_view_id, 0);
        this.mDefaultStatus = array2.getInt(R.styleable.CalendarLayout_default_status, 0);
        this.mCalendarShowMode = array2.getInt(R.styleable.CalendarLayout_calendar_show_mode, 0);
        this.mGestureMode = array2.getInt(R.styleable.CalendarLayout_gesture_mode, 0);
        array2.recycle();
        this.mVelocityTracker = VelocityTracker.obtain();
        ViewConfiguration configuration = ViewConfiguration.get((Context)context);
        this.mTouchSlop = configuration.getScaledTouchSlop();
        this.mMaximumVelocity = configuration.getScaledMaximumFlingVelocity();
    }

    final void setup(CalendarViewDelegate delegate) {
        this.mDelegate = delegate;
        this.initCalendarPosition(delegate.mSelectedCalendar.isAvailable() ? delegate.mSelectedCalendar : delegate.createCurrentDate());
        this.updateContentViewTranslateY();
    }

    private void initCalendarPosition(Calendar cur) {
        int diff = CalendarUtil.getMonthViewStartDiff(cur, this.mDelegate.getWeekStart());
        int size = diff + cur.getDay() - 1;
        this.updateSelectPosition(size);
    }

    final void updateSelectPosition(int selectPosition) {
        int line = (selectPosition + 7) / 7;
        this.mViewPagerTranslateY = (line - 1) * this.mItemHeight;
    }

    final void updateSelectWeek(int week) {
        this.mViewPagerTranslateY = (week - 1) * this.mItemHeight;
    }

    void updateContentViewTranslateY() {
        if (this.mDelegate == null || this.mContentView == null) {
            return;
        }
        Calendar calendar = this.mDelegate.mIndexCalendar;
        this.mContentViewTranslateY = this.mDelegate.getMonthViewShowMode() == 0 ? 5 * this.mItemHeight : CalendarUtil.getMonthViewHeight(calendar.getYear(), calendar.getMonth(), this.mItemHeight, this.mDelegate.getWeekStart()) - this.mItemHeight;
        if (this.mWeekPager.getVisibility() == 0) {
            if (this.mContentView == null) {
                return;
            }
            this.mContentView.setTranslationY((float)(-this.mContentViewTranslateY));
        }
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(MotionEvent event) {
        if (this.mDelegate.isShowYearSelectedLayout) {
            return false;
        }
        if (this.mContentView == null) {
            return false;
        }
        int action = event.getAction();
        float y = event.getY();
        this.mVelocityTracker.addMovement(event);
        switch (action) {
            case 0: {
                int index = MotionEventCompat.getActionIndex((MotionEvent)event);
                this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)event, (int)index);
                this.mLastY = this.downY = y;
                return true;
            }
            case 5: {
                int indexx = MotionEventCompat.getActionIndex((MotionEvent)event);
                this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)event, (int)indexx);
                if (this.mActivePointerId != 0) break;
                this.mLastY = MotionEventCompat.getY((MotionEvent)event, (int)this.mActivePointerId);
                break;
            }
            case 2: {
                float dy;
                if (this.mGestureMode == 2 || this.mCalendarShowMode == 2 || this.mCalendarShowMode == 1) {
                    return false;
                }
                this.getPointerIndex(event, this.mActivePointerId);
                if (this.mActivePointerId == -1) {
                    this.mLastY = y;
                    this.mActivePointerId = 1;
                }
                if ((dy = y - this.mLastY) < 0.0f && this.mContentView.getTranslationY() == (float)(-this.mContentViewTranslateY)) {
                    this.showWeek();
                    return false;
                }
                this.hideWeek();
                if (dy > 0.0f && this.mContentView.getTranslationY() + dy >= 0.0f) {
                    this.mContentView.setTranslationY(0.0f);
                    this.translationViewPager();
                    return super.onTouchEvent(event);
                }
                if (dy < 0.0f && this.mContentView.getTranslationY() + dy <= (float)(-this.mContentViewTranslateY)) {
                    this.mContentView.setTranslationY((float)(-this.mContentViewTranslateY));
                    this.translationViewPager();
                    return super.onTouchEvent(event);
                }
                this.mContentView.setTranslationY(this.mContentView.getTranslationY() + dy);
                this.translationViewPager();
                this.mLastY = y;
                break;
            }
            case 3: 
            case 6: {
                int pointerIndex = this.getPointerIndex(event, this.mActivePointerId);
                if (this.mActivePointerId == -1) break;
                this.mLastY = MotionEventCompat.getY((MotionEvent)event, (int)pointerIndex);
                break;
            }
            case 1: {
                VelocityTracker velocityTracker = this.mVelocityTracker;
                velocityTracker.computeCurrentVelocity(1000, (float)this.mMaximumVelocity);
                float mYVelocity = velocityTracker.getYVelocity();
                if (this.mContentView.getTranslationY() == 0.0f || this.mContentView.getTranslationY() == (float)this.mContentViewTranslateY) break;
                if (Math.abs(mYVelocity) >= 800.0f) {
                    if (mYVelocity < 0.0f) {
                        this.shrink();
                    } else {
                        this.expand();
                    }
                    return super.onTouchEvent(event);
                }
                if (event.getY() - this.downY > 0.0f) {
                    this.expand();
                    break;
                }
                this.shrink();
            }
        }
        return super.onTouchEvent(event);
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (this.isAnimating) {
            return true;
        }
        if (this.mGestureMode == 2) {
            return false;
        }
        if (this.mYearView == null || this.mContentView == null || this.mContentView.getVisibility() != 0) {
            return super.onInterceptTouchEvent(ev);
        }
        if (this.mCalendarShowMode == 2 || this.mCalendarShowMode == 1) {
            return false;
        }
        if (this.mYearView.getVisibility() == 0 || this.mDelegate.isShowYearSelectedLayout) {
            return super.onInterceptTouchEvent(ev);
        }
        int action = ev.getAction();
        float y = ev.getY();
        switch (action) {
            case 0: {
                int index = MotionEventCompat.getActionIndex((MotionEvent)ev);
                this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)index);
                this.mLastY = this.downY = y;
                break;
            }
            case 2: {
                float dy = y - this.mLastY;
                if (dy < 0.0f && this.mContentView.getTranslationY() == (float)(-this.mContentViewTranslateY)) {
                    return false;
                }
                if (dy > 0.0f && this.mContentView.getTranslationY() == (float)(-this.mContentViewTranslateY) && y >= (float)CalendarUtil.dipToPx(this.getContext(), 98.0f) && !this.isScrollTop()) {
                    return false;
                }
                if (dy > 0.0f && this.mContentView.getTranslationY() == 0.0f && y >= (float)CalendarUtil.dipToPx(this.getContext(), 98.0f)) {
                    return false;
                }
                if (!(Math.abs(dy) > (float)this.mTouchSlop) || !(dy > 0.0f && this.mContentView.getTranslationY() <= 0.0f) && (!(dy < 0.0f) || !(this.mContentView.getTranslationY() >= (float)(-this.mContentViewTranslateY)))) break;
                this.mLastY = y;
                return true;
            }
        }
        return super.onInterceptTouchEvent(ev);
    }

    private int getPointerIndex(MotionEvent ev, int id2) {
        int activePointerIndex = MotionEventCompat.findPointerIndex((MotionEvent)ev, (int)id2);
        if (activePointerIndex == -1) {
            this.mActivePointerId = -1;
        }
        return activePointerIndex;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.mContentView != null && this.mMonthView != null) {
            int h = this.getHeight() - this.mItemHeight - (this.mDelegate != null ? this.mDelegate.getWeekBarHeight() : CalendarUtil.dipToPx(this.getContext(), 40.0f)) - CalendarUtil.dipToPx(this.getContext(), 1.0f);
            int heightSpec = View.MeasureSpec.makeMeasureSpec((int)h, (int)0x40000000);
            this.mContentView.measure(widthMeasureSpec, heightSpec);
            this.mContentView.layout(this.mContentView.getLeft(), this.mContentView.getTop(), this.mContentView.getRight(), this.mContentView.getBottom());
        }
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.mMonthView = (MonthViewPager)this.findViewById(R.id.vp_month);
        this.mWeekPager = (WeekViewPager)this.findViewById(R.id.vp_week);
        this.mContentView = (ViewGroup)this.findViewById(this.mContentViewId);
        this.mYearView = (YearSelectLayout)this.findViewById(R.id.selectLayout);
        if (this.mContentView != null) {
            this.mContentView.setOverScrollMode(2);
        }
    }

    private void translationViewPager() {
        float percent = this.mContentView.getTranslationY() * 1.0f / (float)this.mContentViewTranslateY;
        this.mMonthView.setTranslationY((float)this.mViewPagerTranslateY * percent);
    }

    public final boolean isExpand() {
        return this.mContentView == null || this.mMonthView.getVisibility() == 0;
    }

    public boolean expand() {
        if (this.isAnimating || this.mCalendarShowMode == 1 || this.mContentView == null) {
            return false;
        }
        if (this.mMonthView.getVisibility() != 0) {
            this.mWeekPager.setVisibility(8);
            this.onShowMonthView();
            this.mMonthView.setVisibility(0);
        }
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)this.mContentView, (String)"translationY", (float[])new float[]{this.mContentView.getTranslationY(), 0.0f});
        objectAnimator.setDuration(240L);
        objectAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                float currentValue = ((Float)animation.getAnimatedValue()).floatValue();
                float percent = currentValue * 1.0f / (float)CalendarLayout.this.mContentViewTranslateY;
                CalendarLayout.this.mMonthView.setTranslationY((float)CalendarLayout.this.mViewPagerTranslateY * percent);
                CalendarLayout.this.isAnimating = true;
            }
        });
        objectAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                CalendarLayout.this.isAnimating = false;
                CalendarLayout.this.hideWeek();
            }
        });
        objectAnimator.start();
        return true;
    }

    public boolean shrink() {
        if (this.isAnimating || this.mContentView == null) {
            return false;
        }
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)this.mContentView, (String)"translationY", (float[])new float[]{this.mContentView.getTranslationY(), -this.mContentViewTranslateY});
        objectAnimator.setDuration(240L);
        objectAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                float currentValue = ((Float)animation.getAnimatedValue()).floatValue();
                float percent = currentValue * 1.0f / (float)CalendarLayout.this.mContentViewTranslateY;
                CalendarLayout.this.mMonthView.setTranslationY((float)CalendarLayout.this.mViewPagerTranslateY * percent);
                CalendarLayout.this.isAnimating = true;
            }
        });
        objectAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                CalendarLayout.this.isAnimating = false;
                CalendarLayout.this.showWeek();
            }
        });
        objectAnimator.start();
        return true;
    }

    final void initStatus() {
        if (this.mContentView == null) {
            return;
        }
        if ((this.mDefaultStatus == 1 || this.mCalendarShowMode == 1) && this.mCalendarShowMode != 2) {
            this.post(new Runnable(){

                @Override
                public void run() {
                    ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)CalendarLayout.this.mContentView, (String)"translationY", (float[])new float[]{CalendarLayout.this.mContentView.getTranslationY(), -CalendarLayout.this.mContentViewTranslateY});
                    objectAnimator.setDuration(0L);
                    objectAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                        public void onAnimationUpdate(ValueAnimator animation) {
                            float currentValue = ((Float)animation.getAnimatedValue()).floatValue();
                            float percent = currentValue * 1.0f / (float)CalendarLayout.this.mContentViewTranslateY;
                            CalendarLayout.this.mMonthView.setTranslationY((float)CalendarLayout.this.mViewPagerTranslateY * percent);
                            CalendarLayout.this.isAnimating = true;
                        }
                    });
                    objectAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                        public void onAnimationEnd(Animator animation) {
                            super.onAnimationEnd(animation);
                            CalendarLayout.this.isAnimating = false;
                            CalendarLayout.this.showWeek();
                        }
                    });
                    objectAnimator.start();
                }
            });
        } else {
            if (this.mDelegate.mViewChangeListener == null) {
                return;
            }
            this.post(new Runnable(){

                @Override
                public void run() {
                    ((CalendarLayout)CalendarLayout.this).mDelegate.mViewChangeListener.onViewChange(true);
                }
            });
        }
    }

    private void hideWeek() {
        this.onShowMonthView();
        this.mWeekPager.setVisibility(8);
        this.mMonthView.setVisibility(0);
    }

    private void showWeek() {
        this.onShowWeekView();
        this.mWeekPager.getAdapter().notifyDataSetChanged();
        this.mWeekPager.setVisibility(0);
        this.mMonthView.setVisibility(4);
    }

    private void onShowWeekView() {
        if (this.mWeekPager.getVisibility() == 0) {
            return;
        }
        if (this.mDelegate.mViewChangeListener != null) {
            this.mDelegate.mViewChangeListener.onViewChange(false);
        }
    }

    private void onShowMonthView() {
        if (this.mMonthView.getVisibility() == 0) {
            return;
        }
        if (this.mDelegate.mViewChangeListener != null) {
            this.mDelegate.mViewChangeListener.onViewChange(true);
        }
    }

    protected boolean isScrollTop() {
        if (this.mContentView instanceof CalendarScrollView) {
            return ((CalendarScrollView)this.mContentView).isScrollToTop();
        }
        if (this.mContentView instanceof RecyclerView) {
            return ((RecyclerView)this.mContentView).computeVerticalScrollOffset() == 0;
        }
        if (this.mContentView instanceof AbsListView) {
            boolean result = false;
            AbsListView listView = (AbsListView)this.mContentView;
            if (listView.getFirstVisiblePosition() == 0) {
                View topChildView = listView.getChildAt(0);
                result = topChildView.getTop() == 0;
            }
            return result;
        }
        return this.mContentView.getScrollY() == 0;
    }

    @SuppressLint(value={"NewApi"})
    final void hideContentView() {
        if (this.mContentView == null) {
            return;
        }
        this.mContentView.animate().translationY((float)(this.getHeight() - this.mMonthView.getHeight())).setDuration(220L).setInterpolator((TimeInterpolator)new LinearInterpolator()).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                CalendarLayout.this.mContentView.setVisibility(4);
                CalendarLayout.this.mContentView.clearAnimation();
            }
        });
    }

    @SuppressLint(value={"NewApi"})
    final void showContentView() {
        if (this.mContentView == null) {
            return;
        }
        this.mContentView.setTranslationY((float)(this.getHeight() - this.mMonthView.getHeight()));
        this.mContentView.setVisibility(0);
        this.mContentView.animate().translationY(0.0f).setDuration(180L).setInterpolator((TimeInterpolator)new LinearInterpolator()).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
            }
        });
    }

    private int getCalendarViewHeight() {
        return this.mMonthView.getVisibility() == 0 ? this.mDelegate.getWeekBarHeight() + this.mMonthView.getHeight() : this.mDelegate.getWeekBarHeight() + this.mDelegate.getCalendarItemHeight();
    }

    public static interface CalendarScrollView {
        public boolean isScrollToTop();
    }
}

