/*
 * Decompiled with CFR 0.152.
 */
package com.haibin.calendarview;

import android.annotation.SuppressLint;
import android.content.Context;
import com.haibin.calendarview.Calendar;
import com.haibin.calendarview.CalendarViewDelegate;
import com.haibin.calendarview.LunarCalendar;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

final class CalendarUtil {
    private static final long ONE_DAY = 86400000L;

    CalendarUtil() {
    }

    @SuppressLint(value={"SimpleDateFormat"})
    static int getDate(String formatStr, Date date) {
        SimpleDateFormat format = new SimpleDateFormat(formatStr);
        return Integer.parseInt(format.format(date));
    }

    static boolean isWeekend(Calendar calendar) {
        int week = CalendarUtil.getWeekFormCalendar(calendar);
        return week == 0 || week == 6;
    }

    static int getMonthDaysCount(int year, int month) {
        int count = 0;
        if (month == 1 || month == 3 || month == 5 || month == 7 || month == 8 || month == 10 || month == 12) {
            count = 31;
        }
        if (month == 4 || month == 6 || month == 9 || month == 11) {
            count = 30;
        }
        if (month == 2) {
            count = CalendarUtil.isLeapYear(year) ? 29 : 28;
        }
        return count;
    }

    static boolean isLeapYear(int year) {
        return year % 4 == 0 && year % 100 != 0 || year % 400 == 0;
    }

    static int getMonthViewHeight(int year, int month, int itemHeight, int weekStartWith) {
        java.util.Calendar date = java.util.Calendar.getInstance();
        date.set(year, month - 1, 1);
        int preDiff = CalendarUtil.getMonthViewStartDiff(year, month, weekStartWith);
        int monthDaysCount = CalendarUtil.getMonthDaysCount(year, month);
        int nextDiff = CalendarUtil.getMonthEndDiff(year, month, monthDaysCount, weekStartWith);
        return (preDiff + monthDaysCount + nextDiff) / 7 * itemHeight;
    }

    static int getWeekFromDayInMonth(Calendar calendar, int weekStart) {
        java.util.Calendar date = java.util.Calendar.getInstance();
        date.set(calendar.getYear(), calendar.getMonth() - 1, 1);
        int diff = CalendarUtil.getMonthViewStartDiff(calendar, weekStart);
        return (calendar.getDay() + diff - 1) / 7 + 1;
    }

    static int getMonthViewStartDiff(Calendar calendar, int weekStart) {
        java.util.Calendar date = java.util.Calendar.getInstance();
        date.set(calendar.getYear(), calendar.getMonth() - 1, 1);
        int week = date.get(7);
        if (weekStart == 1) {
            return week - 1;
        }
        if (weekStart == 2) {
            return week == 1 ? 6 : week - weekStart;
        }
        return week == 7 ? 0 : week;
    }

    static int getMonthEndDiff(Calendar calendar, int weekStart) {
        java.util.Calendar date = java.util.Calendar.getInstance();
        date.set(calendar.getYear(), calendar.getMonth() - 1, CalendarUtil.getMonthDaysCount(calendar.getYear(), calendar.getMonth()));
        int week = date.get(7);
        if (weekStart == 1) {
            return 7 - week;
        }
        if (weekStart == 2) {
            return week == 1 ? 0 : 7 - week + 1;
        }
        return week == 7 ? 6 : 7 - week - 1;
    }

    static int getMonthViewStartDiff(int year, int month, int weekStart) {
        java.util.Calendar date = java.util.Calendar.getInstance();
        date.set(year, month - 1, 1);
        int week = date.get(7);
        if (weekStart == 1) {
            return week - 1;
        }
        if (weekStart == 2) {
            return week == 1 ? 6 : week - weekStart;
        }
        return week == 7 ? 0 : week;
    }

    static int getMonthEndDiff(int year, int month, int weekStart) {
        return CalendarUtil.getMonthEndDiff(year, month, CalendarUtil.getMonthDaysCount(year, month), weekStart);
    }

    private static int getMonthEndDiff(int year, int month, int day, int weekStart) {
        java.util.Calendar date = java.util.Calendar.getInstance();
        date.set(year, month - 1, day);
        int week = date.get(7);
        if (weekStart == 1) {
            return 7 - week;
        }
        if (weekStart == 2) {
            return week == 1 ? 0 : 7 - week + 1;
        }
        return week == 7 ? 6 : 7 - week - 1;
    }

    static int getWeekFormCalendar(Calendar calendar) {
        java.util.Calendar date = java.util.Calendar.getInstance();
        date.set(calendar.getYear(), calendar.getMonth() - 1, calendar.getDay());
        return date.get(7) - 1;
    }

    static int getWeekViewIndexFromCalendar(Calendar calendar, int weekStart) {
        java.util.Calendar date = java.util.Calendar.getInstance();
        date.set(calendar.getYear(), calendar.getMonth() - 1, calendar.getDay());
        int weekStartDiff = CalendarUtil.getWeekViewStartDiff(calendar.getYear(), calendar.getMonth(), calendar.getDay(), weekStart);
        if (weekStart == 1) {
            return weekStartDiff;
        }
        if (weekStart == 2) {
            return weekStartDiff == 1 ? 6 : weekStartDiff;
        }
        return weekStartDiff == 7 ? 0 : weekStartDiff;
    }

    @Deprecated
    static int getWeekCountBetweenYearAndYear(int minYear, int minYearMonth, int maxYear, int maxYearMonth, int weekStart) {
        java.util.Calendar date = java.util.Calendar.getInstance();
        date.set(minYear, minYearMonth - 1, 1);
        long minTimeMills = date.getTimeInMillis();
        int preDiff = CalendarUtil.getMonthViewStartDiff(minYear, minYearMonth, weekStart);
        date.set(maxYear, maxYearMonth - 1, CalendarUtil.getMonthDaysCount(maxYear, maxYearMonth));
        long maxTimeMills = date.getTimeInMillis();
        int nextDiff = CalendarUtil.getMonthEndDiff(maxYear, maxYearMonth, weekStart);
        int count = preDiff + nextDiff;
        int c = (int)((maxTimeMills - minTimeMills) / 86400000L) + 1;
        return (count += c) / 7;
    }

    static boolean isCalendarInRange(Calendar calendar, int minYear, int minYearMonth, int minYearDay, int maxYear, int maxYearMonth, int maxYearDay) {
        java.util.Calendar c = java.util.Calendar.getInstance();
        c.set(minYear, minYearMonth - 1, minYearDay);
        long minTime = c.getTimeInMillis();
        c.set(maxYear, maxYearMonth - 1, maxYearDay);
        long maxTime = c.getTimeInMillis();
        c.set(calendar.getYear(), calendar.getMonth() - 1, calendar.getDay());
        long curTime = c.getTimeInMillis();
        return curTime >= minTime && curTime <= maxTime;
    }

    static int getWeekCountBetweenBothCalendar(int minYear, int minYearMonth, int minYearDay, int maxYear, int maxYearMonth, int maxYearDay, int weekStart) {
        java.util.Calendar date = java.util.Calendar.getInstance();
        date.set(minYear, minYearMonth - 1, minYearDay);
        long minTimeMills = date.getTimeInMillis();
        int preDiff = CalendarUtil.getWeekViewStartDiff(minYear, minYearMonth, minYearDay, weekStart);
        date.set(maxYear, maxYearMonth - 1, maxYearDay);
        long maxTimeMills = date.getTimeInMillis();
        int nextDiff = CalendarUtil.getWeekViewEndDiff(maxYear, maxYearMonth, maxYearDay, weekStart);
        int count = preDiff + nextDiff;
        int c = (int)((maxTimeMills - minTimeMills) / 86400000L) + 1;
        return (count += c) / 7;
    }

    static int getWeekFromCalendarStartWithMinCalendar(Calendar calendar, int minYear, int minYearMonth, int minYearDay, int weekStart) {
        java.util.Calendar date = java.util.Calendar.getInstance();
        date.set(minYear, minYearMonth - 1, minYearDay);
        long firstTimeMill = date.getTimeInMillis();
        int preDiff = CalendarUtil.getWeekViewStartDiff(minYear, minYearMonth, minYearDay, weekStart);
        int weekStartDiff = CalendarUtil.getWeekViewStartDiff(calendar.getYear(), calendar.getMonth(), calendar.getDay(), weekStart);
        date.set(calendar.getYear(), calendar.getMonth() - 1, weekStartDiff == 0 ? calendar.getDay() + 1 : calendar.getDay());
        long curTimeMills = date.getTimeInMillis();
        int c = (int)((curTimeMills - firstTimeMill) / 86400000L);
        int count = preDiff + c;
        return count / 7 + 1;
    }

    static Calendar getFirstCalendarStartWithMinCalendar(int minYear, int minYearMonth, int minYearDay, int week, int weekStart) {
        java.util.Calendar date = java.util.Calendar.getInstance();
        date.set(minYear, minYearMonth - 1, minYearDay);
        long firstTimeMills = date.getTimeInMillis();
        long weekTimeMills = (long)((week - 1) * 7) * 86400000L;
        long timeCountMills = weekTimeMills + firstTimeMills;
        date.setTimeInMillis(timeCountMills);
        int startDiff = CalendarUtil.getWeekViewStartDiff(date.get(1), date.get(2) + 1, date.get(5), weekStart);
        date.setTimeInMillis(timeCountMills -= (long)startDiff * 86400000L);
        Calendar calendar = new Calendar();
        calendar.setYear(date.get(1));
        calendar.setMonth(date.get(2) + 1);
        calendar.setDay(date.get(5));
        return calendar;
    }

    @Deprecated
    static int getWeekFromCalendarBetweenYearAndYear(Calendar calendar, int minYear, int minYearMonth, int weekStar) {
        java.util.Calendar date = java.util.Calendar.getInstance();
        date.set(minYear, minYearMonth - 1, 1);
        long firstTimeMill = date.getTimeInMillis();
        int preDiff = CalendarUtil.getWeekViewStartDiff(minYear, minYearMonth, 1, weekStar);
        int weekStartDiff = CalendarUtil.getWeekViewStartDiff(calendar.getYear(), calendar.getMonth(), calendar.getDay(), weekStar);
        date.set(calendar.getYear(), calendar.getMonth() - 1, weekStartDiff == 0 ? calendar.getDay() + 1 : calendar.getDay());
        long curTimeMills = date.getTimeInMillis();
        int c = (int)((curTimeMills - firstTimeMill) / 86400000L);
        int count = preDiff + c;
        return count / 7 + 1;
    }

    @Deprecated
    static boolean isCalendarInRange(Calendar calendar, int minYear, int minYearMonth, int maxYear, int maxYearMonth) {
        java.util.Calendar c = java.util.Calendar.getInstance();
        c.set(minYear, minYearMonth - 1, 1);
        long minTime = c.getTimeInMillis();
        c.set(maxYear, maxYearMonth - 1, CalendarUtil.getMonthDaysCount(maxYear, maxYearMonth));
        long maxTime = c.getTimeInMillis();
        c.set(calendar.getYear(), calendar.getMonth() - 1, calendar.getDay());
        long curTime = c.getTimeInMillis();
        return curTime >= minTime && curTime <= maxTime;
    }

    static boolean isCalendarInRange(Calendar calendar, CalendarViewDelegate delegate) {
        return CalendarUtil.isCalendarInRange(calendar, delegate.getMinYear(), delegate.getMinYearMonth(), delegate.getMinYearDay(), delegate.getMaxYear(), delegate.getMaxYearMonth(), delegate.getMaxYearDay());
    }

    static boolean isMonthInRange(int year, int month, int minYear, int minYearMonth, int maxYear, int maxYearMonth) {
        return !(year < minYear || year > maxYear || year == minYear && month < minYearMonth || year == maxYear && month > maxYearMonth);
    }

    @Deprecated
    static Calendar getFirstCalendarFromWeekCount(int minYear, int minYearMonth, int week, int weekStart) {
        java.util.Calendar date = java.util.Calendar.getInstance();
        date.set(minYear, minYearMonth - 1, 1);
        long firstTimeMills = date.getTimeInMillis();
        long weekTimeMills = (long)((week - 1) * 7) * 86400000L;
        long timeCountMills = weekTimeMills + firstTimeMills;
        date.setTimeInMillis(timeCountMills);
        int startDiff = CalendarUtil.getWeekViewStartDiff(date.get(1), date.get(2) + 1, date.get(5), weekStart);
        date.setTimeInMillis(timeCountMills -= (long)startDiff * 86400000L);
        Calendar calendar = new Calendar();
        calendar.setYear(date.get(1));
        calendar.setMonth(date.get(2) + 1);
        calendar.setDay(date.get(5));
        return calendar;
    }

    static int compareTo(int minYear, int minYearMonth, int minYearDay, int maxYear, int maxYearMonth, int maxYearDay) {
        Calendar first = new Calendar();
        first.setYear(minYear);
        first.setMonth(minYearMonth);
        first.setDay(minYearDay);
        Calendar second = new Calendar();
        second.setYear(maxYear);
        second.setMonth(maxYearMonth);
        second.setDay(maxYearDay);
        return first.compareTo(second);
    }

    static List<Calendar> initCalendarForMonthView(int year, int month, Calendar currentDate, int weekStar) {
        int preMonthDaysCount;
        int nextMonth;
        int nextYear;
        int preMonth;
        int preYear;
        java.util.Calendar date = java.util.Calendar.getInstance();
        date.set(year, month - 1, 1);
        int mPreDiff = CalendarUtil.getMonthViewStartDiff(year, month, weekStar);
        int monthDayCount = CalendarUtil.getMonthDaysCount(year, month);
        int size = 42;
        ArrayList<Calendar> mItems = new ArrayList<Calendar>();
        if (month == 1) {
            preYear = year - 1;
            preMonth = 12;
            nextYear = year;
            nextMonth = month + 1;
            preMonthDaysCount = mPreDiff == 0 ? 0 : CalendarUtil.getMonthDaysCount(preYear, preMonth);
        } else if (month == 12) {
            preYear = year;
            preMonth = month - 1;
            nextYear = year + 1;
            nextMonth = 1;
            preMonthDaysCount = mPreDiff == 0 ? 0 : CalendarUtil.getMonthDaysCount(preYear, preMonth);
        } else {
            preYear = year;
            preMonth = month - 1;
            nextYear = year;
            nextMonth = month + 1;
            preMonthDaysCount = mPreDiff == 0 ? 0 : CalendarUtil.getMonthDaysCount(preYear, preMonth);
        }
        int nextDay = 1;
        for (int i = 0; i < size; ++i) {
            Calendar calendarDate = new Calendar();
            if (i < mPreDiff) {
                calendarDate.setYear(preYear);
                calendarDate.setMonth(preMonth);
                calendarDate.setDay(preMonthDaysCount - mPreDiff + i + 1);
            } else if (i >= monthDayCount + mPreDiff) {
                calendarDate.setYear(nextYear);
                calendarDate.setMonth(nextMonth);
                calendarDate.setDay(nextDay);
                ++nextDay;
            } else {
                calendarDate.setYear(year);
                calendarDate.setMonth(month);
                calendarDate.setCurrentMonth(true);
                calendarDate.setDay(i - mPreDiff + 1);
            }
            if (calendarDate.equals(currentDate)) {
                calendarDate.setCurrentDay(true);
            }
            LunarCalendar.setupLunarCalendar(calendarDate);
            mItems.add(calendarDate);
        }
        return mItems;
    }

    static List<Calendar> getWeekCalendars(Calendar calendar, CalendarViewDelegate mDelegate) {
        long curTime = calendar.getTimeInMillis();
        java.util.Calendar date = java.util.Calendar.getInstance();
        date.set(calendar.getYear(), calendar.getMonth() - 1, calendar.getDay());
        int week = date.get(7);
        int startDiff = mDelegate.getWeekStart() == 1 ? week - 1 : (mDelegate.getWeekStart() == 2 ? (week == 1 ? 6 : week - mDelegate.getWeekStart()) : (week == 7 ? 0 : week));
        java.util.Calendar minCalendar = java.util.Calendar.getInstance();
        minCalendar.setTimeInMillis(curTime -= (long)startDiff * 86400000L);
        Calendar startCalendar = new Calendar();
        startCalendar.setYear(minCalendar.get(1));
        startCalendar.setMonth(minCalendar.get(2) + 1);
        startCalendar.setDay(minCalendar.get(5));
        return CalendarUtil.initCalendarForWeekView(startCalendar, mDelegate, mDelegate.getWeekStart());
    }

    static List<Calendar> initCalendarForWeekView(Calendar calendar, CalendarViewDelegate mDelegate, int weekStart) {
        java.util.Calendar date = java.util.Calendar.getInstance();
        date.set(calendar.getYear(), calendar.getMonth() - 1, calendar.getDay());
        long curDateMills = date.getTimeInMillis();
        int weekEndDiff = CalendarUtil.getWeekViewEndDiff(calendar.getYear(), calendar.getMonth(), calendar.getDay(), weekStart);
        ArrayList<Calendar> mItems = new ArrayList<Calendar>();
        date.setTimeInMillis(curDateMills);
        Calendar selectCalendar = new Calendar();
        selectCalendar.setYear(date.get(1));
        selectCalendar.setMonth(date.get(2) + 1);
        selectCalendar.setDay(date.get(5));
        if (selectCalendar.equals(mDelegate.getCurrentDay())) {
            selectCalendar.setCurrentDay(true);
        }
        LunarCalendar.setupLunarCalendar(selectCalendar);
        selectCalendar.setCurrentMonth(true);
        mItems.add(selectCalendar);
        for (int i = 1; i <= weekEndDiff; ++i) {
            date.setTimeInMillis(curDateMills + (long)i * 86400000L);
            Calendar calendarDate = new Calendar();
            calendarDate.setYear(date.get(1));
            calendarDate.setMonth(date.get(2) + 1);
            calendarDate.setDay(date.get(5));
            if (calendarDate.equals(mDelegate.getCurrentDay())) {
                calendarDate.setCurrentDay(true);
            }
            LunarCalendar.setupLunarCalendar(calendarDate);
            calendarDate.setCurrentMonth(true);
            mItems.add(calendarDate);
        }
        return mItems;
    }

    private static int getWeekViewStartDiff(int year, int month, int day, int weekStart) {
        java.util.Calendar date = java.util.Calendar.getInstance();
        date.set(year, month - 1, day);
        int week = date.get(7);
        if (weekStart == 1) {
            return week - 1;
        }
        if (weekStart == 2) {
            return week == 1 ? 6 : week - weekStart;
        }
        return week == 7 ? 0 : week;
    }

    private static int getWeekViewEndDiff(int year, int month, int day, int weekStart) {
        java.util.Calendar date = java.util.Calendar.getInstance();
        date.set(year, month - 1, day);
        int week = date.get(7);
        if (weekStart == 1) {
            return 7 - week;
        }
        if (weekStart == 2) {
            return week == 1 ? 0 : 7 - week + 1;
        }
        return week == 7 ? 6 : 7 - week - 1;
    }

    @Deprecated
    static Calendar getCalendarFromMonthViewPager(int position, CalendarViewDelegate delegate) {
        Calendar calendar = new Calendar();
        calendar.setYear((position + delegate.getMinYearMonth() - 1) / 12 + delegate.getMinYear());
        calendar.setMonth((position + delegate.getMinYearMonth() - 1) % 12 + 1);
        calendar.setDay(1);
        calendar.setCurrentMonth(calendar.getYear() == delegate.getCurrentDay().getYear() && calendar.getMonth() == delegate.getCurrentDay().getMonth());
        calendar.setCurrentDay(calendar.equals(delegate.getCurrentDay()));
        LunarCalendar.setupLunarCalendar(calendar);
        return calendar;
    }

    static Calendar getFirstCalendarFromMonthViewPager(int position, CalendarViewDelegate delegate) {
        Calendar calendar = new Calendar();
        calendar.setYear((position + delegate.getMinYearMonth() - 1) / 12 + delegate.getMinYear());
        calendar.setMonth((position + delegate.getMinYearMonth() - 1) % 12 + 1);
        calendar.setDay(1);
        if (!CalendarUtil.isCalendarInRange(calendar, delegate)) {
            calendar = CalendarUtil.isMinRangeEdge(calendar, delegate) ? delegate.getMinRangeCalendar() : delegate.getMaxRangeCalendar();
        }
        calendar.setCurrentMonth(calendar.getYear() == delegate.getCurrentDay().getYear() && calendar.getMonth() == delegate.getCurrentDay().getMonth());
        calendar.setCurrentDay(calendar.equals(delegate.getCurrentDay()));
        LunarCalendar.setupLunarCalendar(calendar);
        return calendar;
    }

    static Calendar getRangeEdgeCalendar(Calendar calendar, CalendarViewDelegate delegate) {
        if (CalendarUtil.isCalendarInRange(delegate.getCurrentDay(), delegate)) {
            return delegate.createCurrentDate();
        }
        if (CalendarUtil.isCalendarInRange(calendar, delegate)) {
            return calendar;
        }
        Calendar minRangeCalendar = delegate.getMinRangeCalendar();
        if (minRangeCalendar.isSameMonth(calendar)) {
            return delegate.getMinRangeCalendar();
        }
        return delegate.getMaxRangeCalendar();
    }

    private static boolean isMinRangeEdge(Calendar calendar, CalendarViewDelegate delegate) {
        java.util.Calendar c = java.util.Calendar.getInstance();
        c.set(delegate.getMinYear(), delegate.getMinYearMonth() - 1, delegate.getMinYearDay());
        long minTime = c.getTimeInMillis();
        c.set(calendar.getYear(), calendar.getMonth() - 1, calendar.getDay());
        long curTime = c.getTimeInMillis();
        return curTime < minTime;
    }

    static int dipToPx(Context context, float dpValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }
}

