/*
 * Decompiled with CFR 0.152.
 */
package com.haibin.calendarview;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.view.ViewPager;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.LinearInterpolator;
import android.widget.FrameLayout;
import com.haibin.calendarview.Calendar;
import com.haibin.calendarview.CalendarLayout;
import com.haibin.calendarview.CalendarUtil;
import com.haibin.calendarview.CalendarViewDelegate;
import com.haibin.calendarview.MonthViewPager;
import com.haibin.calendarview.R;
import com.haibin.calendarview.WeekBar;
import com.haibin.calendarview.WeekViewPager;
import com.haibin.calendarview.YearRecyclerView;
import com.haibin.calendarview.YearSelectLayout;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.Map;

public class CalendarView
extends FrameLayout {
    private final CalendarViewDelegate mDelegate;
    private MonthViewPager mMonthPager;
    private WeekViewPager mWeekPager;
    private View mWeekLine;
    private YearSelectLayout mSelectLayout;
    private WeekBar mWeekBar;
    CalendarLayout mParentLayout;

    public CalendarView(@NonNull Context context) {
        this(context, null);
    }

    public CalendarView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.mDelegate = new CalendarViewDelegate(context, attrs);
        this.init(context);
    }

    private void init(Context context) {
        LayoutInflater.from((Context)context).inflate(R.layout.cv_layout_calendar_view, (ViewGroup)this, true);
        FrameLayout frameContent = (FrameLayout)this.findViewById(R.id.frameContent);
        this.mWeekPager = (WeekViewPager)this.findViewById(R.id.vp_week);
        this.mWeekPager.setup(this.mDelegate);
        if (TextUtils.isEmpty((CharSequence)this.mDelegate.getWeekBarClass())) {
            this.mWeekBar = new WeekBar(this.getContext());
        } else {
            try {
                Class<?> cls = Class.forName(this.mDelegate.getWeekBarClass());
                Constructor<?> constructor = cls.getConstructor(Context.class);
                this.mWeekBar = (WeekBar)((Object)constructor.newInstance(this.getContext()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        frameContent.addView((View)this.mWeekBar, 2);
        this.mWeekBar.setup(this.mDelegate);
        this.mWeekBar.onWeekStartChange(this.mDelegate.getWeekStart());
        this.mWeekLine = this.findViewById(R.id.line);
        this.mWeekLine.setBackgroundColor(this.mDelegate.getWeekLineBackground());
        FrameLayout.LayoutParams lineParams = (FrameLayout.LayoutParams)this.mWeekLine.getLayoutParams();
        lineParams.setMargins(this.mDelegate.getWeekLineMargin(), this.mDelegate.getWeekBarHeight(), this.mDelegate.getWeekLineMargin(), 0);
        this.mWeekLine.setLayoutParams((ViewGroup.LayoutParams)lineParams);
        this.mMonthPager = (MonthViewPager)this.findViewById(R.id.vp_month);
        this.mMonthPager.mWeekPager = this.mWeekPager;
        this.mMonthPager.mWeekBar = this.mWeekBar;
        FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)this.mMonthPager.getLayoutParams();
        params.setMargins(0, this.mDelegate.getWeekBarHeight() + CalendarUtil.dipToPx(context, 1.0f), 0, 0);
        this.mWeekPager.setLayoutParams((ViewGroup.LayoutParams)params);
        this.mSelectLayout = (YearSelectLayout)this.findViewById(R.id.selectLayout);
        this.mSelectLayout.setBackgroundColor(this.mDelegate.getYearViewBackground());
        this.mSelectLayout.addOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            }

            public void onPageSelected(int position) {
                if (CalendarView.this.mWeekPager.getVisibility() == 0) {
                    return;
                }
                if (((CalendarView)CalendarView.this).mDelegate.mYearChangeListener != null) {
                    ((CalendarView)CalendarView.this).mDelegate.mYearChangeListener.onYearChange(position + CalendarView.this.mDelegate.getMinYear());
                }
            }

            public void onPageScrollStateChanged(int state) {
            }
        });
        this.mDelegate.mInnerListener = new OnInnerDateSelectedListener(){

            @Override
            public void onMonthDateSelected(Calendar calendar, boolean isClick) {
                if (calendar.getYear() == CalendarView.this.mDelegate.getCurrentDay().getYear() && calendar.getMonth() == CalendarView.this.mDelegate.getCurrentDay().getMonth() && CalendarView.this.mMonthPager.getCurrentItem() != ((CalendarView)CalendarView.this).mDelegate.mCurrentMonthViewItem) {
                    return;
                }
                ((CalendarView)CalendarView.this).mDelegate.mIndexCalendar = calendar;
                if (CalendarView.this.mDelegate.getSelectMode() == 0 || isClick) {
                    ((CalendarView)CalendarView.this).mDelegate.mSelectedCalendar = calendar;
                }
                CalendarView.this.mWeekPager.updateSelected(((CalendarView)CalendarView.this).mDelegate.mIndexCalendar, false);
                CalendarView.this.mMonthPager.updateSelected();
                if (CalendarView.this.mWeekBar != null && (CalendarView.this.mDelegate.getSelectMode() == 0 || isClick)) {
                    CalendarView.this.mWeekBar.onDateSelected(calendar, CalendarView.this.mDelegate.getWeekStart(), isClick);
                }
            }

            @Override
            public void onWeekDateSelected(Calendar calendar, boolean isClick) {
                ((CalendarView)CalendarView.this).mDelegate.mIndexCalendar = calendar;
                if (CalendarView.this.mDelegate.getSelectMode() == 0 || isClick || ((CalendarView)CalendarView.this).mDelegate.mIndexCalendar.equals(((CalendarView)CalendarView.this).mDelegate.mSelectedCalendar)) {
                    ((CalendarView)CalendarView.this).mDelegate.mSelectedCalendar = calendar;
                }
                int y = calendar.getYear() - CalendarView.this.mDelegate.getMinYear();
                int position = 12 * y + ((CalendarView)CalendarView.this).mDelegate.mIndexCalendar.getMonth() - CalendarView.this.mDelegate.getMinYearMonth();
                CalendarView.this.mWeekPager.updateSingleSelect();
                CalendarView.this.mMonthPager.setCurrentItem(position, false);
                CalendarView.this.mMonthPager.updateSelected();
                if (CalendarView.this.mWeekBar != null && (CalendarView.this.mDelegate.getSelectMode() == 0 || isClick || ((CalendarView)CalendarView.this).mDelegate.mIndexCalendar.equals(((CalendarView)CalendarView.this).mDelegate.mSelectedCalendar))) {
                    CalendarView.this.mWeekBar.onDateSelected(calendar, CalendarView.this.mDelegate.getWeekStart(), isClick);
                }
            }
        };
        this.mDelegate.mSelectedCalendar = this.isInRange(this.mDelegate.getCurrentDay()) ? this.mDelegate.createCurrentDate() : this.mDelegate.getMinRangeCalendar();
        this.mDelegate.mIndexCalendar = this.mDelegate.mSelectedCalendar;
        this.mWeekBar.onDateSelected(this.mDelegate.mSelectedCalendar, this.mDelegate.getWeekStart(), false);
        this.mMonthPager.setup(this.mDelegate);
        this.mMonthPager.setCurrentItem(this.mDelegate.mCurrentMonthViewItem);
        this.mSelectLayout.setOnMonthSelectedListener(new YearRecyclerView.OnMonthSelectedListener(){

            @Override
            public void onMonthSelected(int year, int month) {
                int position = 12 * (year - CalendarView.this.mDelegate.getMinYear()) + month - CalendarView.this.mDelegate.getMinYearMonth();
                ((CalendarView)CalendarView.this).mDelegate.isShowYearSelectedLayout = false;
                CalendarView.this.closeSelectLayout(position);
            }
        });
        this.mSelectLayout.setup(this.mDelegate);
        this.mWeekPager.updateSelected(this.mDelegate.createCurrentDate(), false);
    }

    @Deprecated
    public void setRange(int minYear, int minYearMonth, int maxYear, int maxYearMonth) {
        this.setRange(minYear, minYearMonth, 0, maxYear, maxYearMonth, -1);
    }

    public void setRange(int minYear, int minYearMonth, int minYearDay, int maxYear, int maxYearMonth, int maxYearDay) {
        if (CalendarUtil.compareTo(minYear, minYearMonth, minYearDay, maxYear, maxYearMonth, maxYearDay) > 0) {
            return;
        }
        this.mDelegate.setRange(minYear, minYearMonth, minYearDay, maxYear, maxYearMonth, maxYearDay);
        this.mWeekPager.notifyDataSetChanged();
        this.mSelectLayout.notifyDataSetChanged();
        this.mMonthPager.notifyDataSetChanged();
        if (!this.isInRange(this.mDelegate.mSelectedCalendar)) {
            this.mDelegate.mSelectedCalendar = this.mDelegate.getMinRangeCalendar();
            this.mDelegate.updateSelectCalendarScheme();
            this.mDelegate.mIndexCalendar = this.mDelegate.mSelectedCalendar;
        }
        this.mWeekPager.updateRange();
        this.mMonthPager.updateRange();
        this.mSelectLayout.updateRange();
    }

    public int getCurDay() {
        return this.mDelegate.getCurrentDay().getDay();
    }

    public int getCurMonth() {
        return this.mDelegate.getCurrentDay().getMonth();
    }

    public int getCurYear() {
        return this.mDelegate.getCurrentDay().getYear();
    }

    public void showYearSelectLayout(int year) {
        this.showSelectLayout(year);
    }

    @Deprecated
    private void showSelectLayout(final int year) {
        if (this.mParentLayout != null && this.mParentLayout.mContentView != null && !this.mParentLayout.isExpand()) {
            this.mParentLayout.expand();
            return;
        }
        this.mWeekPager.setVisibility(8);
        this.mDelegate.isShowYearSelectedLayout = true;
        if (this.mParentLayout != null) {
            this.mParentLayout.hideContentView();
        }
        this.mWeekBar.animate().translationY((float)(-this.mWeekBar.getHeight())).setInterpolator((TimeInterpolator)new LinearInterpolator()).setDuration(260L).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                CalendarView.this.mWeekBar.setVisibility(8);
                CalendarView.this.mSelectLayout.setVisibility(0);
                CalendarView.this.mSelectLayout.scrollToYear(year, false);
                if (CalendarView.this.mParentLayout != null && CalendarView.this.mParentLayout.mContentView != null) {
                    CalendarView.this.mParentLayout.expand();
                }
            }
        });
        this.mMonthPager.animate().scaleX(0.0f).scaleY(0.0f).setDuration(260L).setInterpolator((TimeInterpolator)new LinearInterpolator()).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
            }
        });
    }

    public boolean isYearSelectLayoutVisible() {
        return this.mSelectLayout.getVisibility() == 0;
    }

    public void closeYearSelectLayout() {
        int position = 12 * (this.mDelegate.mSelectedCalendar.getYear() - this.mDelegate.getMinYear()) + this.mDelegate.mSelectedCalendar.getMonth() - this.mDelegate.getMinYearMonth();
        this.closeSelectLayout(position);
        this.mDelegate.isShowYearSelectedLayout = false;
    }

    private void closeSelectLayout(int position) {
        this.mSelectLayout.setVisibility(8);
        this.mWeekBar.setVisibility(0);
        if (position == this.mMonthPager.getCurrentItem()) {
            if (this.mDelegate.mDateSelectedListener != null && this.mDelegate.getSelectMode() != 1) {
                this.mDelegate.mDateSelectedListener.onDateSelected(this.mDelegate.mSelectedCalendar, false);
            }
            if (this.mDelegate.mCalendarSelectListener != null && this.mDelegate.getSelectMode() != 1) {
                this.mDelegate.mCalendarSelectListener.onCalendarSelect(this.mDelegate.mSelectedCalendar, false);
            }
        } else {
            this.mMonthPager.setCurrentItem(position, false);
        }
        this.mWeekBar.animate().translationY(0.0f).setInterpolator((TimeInterpolator)new LinearInterpolator()).setDuration(280L).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                CalendarView.this.mWeekBar.setVisibility(0);
            }
        });
        this.mMonthPager.animate().scaleX(1.0f).scaleY(1.0f).setDuration(180L).setInterpolator((TimeInterpolator)new LinearInterpolator()).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                CalendarView.this.mMonthPager.setVisibility(0);
                CalendarView.this.mMonthPager.clearAnimation();
                if (CalendarView.this.mParentLayout != null) {
                    CalendarView.this.mParentLayout.showContentView();
                }
            }
        });
    }

    public void scrollToCurrent() {
        this.scrollToCurrent(false);
    }

    public void scrollToCurrent(boolean smoothScroll) {
        if (!this.isInRange(this.mDelegate.getCurrentDay())) {
            return;
        }
        Calendar calendar = this.mDelegate.createCurrentDate();
        if (this.mDelegate.mCalendarInterceptListener != null && this.mDelegate.mCalendarInterceptListener.onCalendarIntercept(calendar)) {
            this.mDelegate.mCalendarInterceptListener.onCalendarInterceptClick(calendar, false);
            return;
        }
        this.mDelegate.mIndexCalendar = this.mDelegate.mSelectedCalendar = this.mDelegate.createCurrentDate();
        this.mDelegate.updateSelectCalendarScheme();
        this.mWeekBar.onDateSelected(this.mDelegate.mSelectedCalendar, this.mDelegate.getWeekStart(), false);
        if (this.mMonthPager.getVisibility() == 0) {
            this.mMonthPager.scrollToCurrent(smoothScroll);
            this.mWeekPager.updateSelected(this.mDelegate.mIndexCalendar, false);
        } else {
            this.mWeekPager.scrollToCurrent(smoothScroll);
        }
        this.mSelectLayout.scrollToYear(this.mDelegate.getCurrentDay().getYear(), smoothScroll);
    }

    public void scrollToNext() {
        this.scrollToNext(false);
    }

    public void scrollToNext(boolean smoothScroll) {
        if (this.isYearSelectLayoutVisible()) {
            this.mSelectLayout.setCurrentItem(this.mSelectLayout.getCurrentItem() + 1, smoothScroll);
        } else if (this.mWeekPager.getVisibility() == 0) {
            this.mWeekPager.setCurrentItem(this.mWeekPager.getCurrentItem() + 1, smoothScroll);
        } else {
            this.mMonthPager.setCurrentItem(this.mMonthPager.getCurrentItem() + 1, smoothScroll);
        }
    }

    public void scrollToPre() {
        this.scrollToPre(false);
    }

    public void scrollToPre(boolean smoothScroll) {
        if (this.isYearSelectLayoutVisible()) {
            this.mSelectLayout.setCurrentItem(this.mSelectLayout.getCurrentItem() - 1, smoothScroll);
        } else if (this.mWeekPager.getVisibility() == 0) {
            this.mWeekPager.setCurrentItem(this.mWeekPager.getCurrentItem() - 1, smoothScroll);
        } else {
            this.mMonthPager.setCurrentItem(this.mMonthPager.getCurrentItem() - 1, smoothScroll);
        }
    }

    public void scrollToSelectCalendar() {
        if (!this.mDelegate.mSelectedCalendar.isAvailable()) {
            return;
        }
        this.scrollToCalendar(this.mDelegate.mSelectedCalendar.getYear(), this.mDelegate.mSelectedCalendar.getMonth(), this.mDelegate.mSelectedCalendar.getDay(), false);
    }

    public void scrollToCalendar(int year, int month, int day) {
        this.scrollToCalendar(year, month, day, false);
    }

    public void scrollToCalendar(int year, int month, int day, boolean smoothScroll) {
        Calendar calendar = new Calendar();
        calendar.setYear(year);
        calendar.setMonth(month);
        calendar.setDay(day);
        if (!this.isInRange(calendar)) {
            return;
        }
        if (this.mDelegate.mCalendarInterceptListener != null && this.mDelegate.mCalendarInterceptListener.onCalendarIntercept(calendar)) {
            this.mDelegate.mCalendarInterceptListener.onCalendarInterceptClick(calendar, false);
            return;
        }
        if (this.mWeekPager.getVisibility() == 0) {
            this.mWeekPager.scrollToCalendar(year, month, day, smoothScroll);
        } else {
            this.mMonthPager.scrollToCalendar(year, month, day, smoothScroll);
        }
    }

    public void scrollToYear(int year) {
        this.scrollToYear(year, false);
    }

    public void scrollToYear(int year, boolean smoothScroll) {
        if (this.mSelectLayout.getVisibility() != 0) {
            return;
        }
        this.mSelectLayout.scrollToYear(year, smoothScroll);
    }

    public void setMonthView(Class<?> cls) {
        if (cls == null) {
            return;
        }
        String monthViewClassPath = cls.getName();
        if (monthViewClassPath.equals(this.mDelegate.getMonthViewClass()) && !TextUtils.isEmpty((CharSequence)this.mDelegate.getMonthViewClass())) {
            return;
        }
        this.mDelegate.setMonthViewClass(monthViewClassPath);
        this.mMonthPager.updateMonthViewClass();
    }

    public void setWeekView(Class<?> cls) {
        if (cls == null) {
            return;
        }
        String weekViewClassPath = cls.getName();
        if (weekViewClassPath.equals(this.mDelegate.getWeekViewClass()) && !TextUtils.isEmpty((CharSequence)this.mDelegate.getWeekViewClass())) {
            return;
        }
        this.mDelegate.setWeekViewClass(weekViewClassPath);
        this.mWeekPager.updateWeekViewClass();
    }

    public void setWeekBar(Class<?> cls) {
        if (cls == null) {
            return;
        }
        String weekBarClassPath = cls.getName();
        if (weekBarClassPath.equals(this.mDelegate.getWeekBarClass()) && !TextUtils.isEmpty((CharSequence)this.mDelegate.getWeekBarClass())) {
            return;
        }
        this.mDelegate.setWeekBarClass(weekBarClassPath);
        FrameLayout frameContent = (FrameLayout)this.findViewById(R.id.frameContent);
        frameContent.removeView((View)this.mWeekBar);
        try {
            Constructor<?> constructor = cls.getConstructor(Context.class);
            this.mWeekBar = (WeekBar)((Object)constructor.newInstance(this.getContext()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        frameContent.addView((View)this.mWeekBar, 2);
        this.mWeekBar.setup(this.mDelegate);
        this.mWeekBar.onWeekStartChange(this.mDelegate.getWeekStart());
        this.mMonthPager.mWeekBar = this.mWeekBar;
        this.mWeekBar.onDateSelected(this.mDelegate.mSelectedCalendar, this.mDelegate.getWeekStart(), false);
    }

    public void setOnCalendarInterceptListener(OnCalendarInterceptListener listener) {
        if (listener == null) {
            this.mDelegate.mCalendarInterceptListener = null;
        }
        if (listener == null || this.mDelegate.getSelectMode() != 1) {
            return;
        }
        this.mDelegate.mCalendarInterceptListener = listener;
        if (!listener.onCalendarIntercept(this.mDelegate.mSelectedCalendar)) {
            return;
        }
        this.mDelegate.mSelectedCalendar = new Calendar();
    }

    public void setOnYearChangeListener(OnYearChangeListener listener) {
        this.mDelegate.mYearChangeListener = listener;
    }

    public void setOnMonthChangeListener(OnMonthChangeListener listener) {
        this.mDelegate.mMonthChangeListener = listener;
        if (this.mDelegate.mMonthChangeListener == null) {
            return;
        }
        this.post(new Runnable(){

            @Override
            public void run() {
                ((CalendarView)CalendarView.this).mDelegate.mMonthChangeListener.onMonthChange(((CalendarView)CalendarView.this).mDelegate.mSelectedCalendar.getYear(), ((CalendarView)CalendarView.this).mDelegate.mSelectedCalendar.getMonth());
            }
        });
    }

    public void setOnWeekChangeListener(OnWeekChangeListener listener) {
        this.mDelegate.mWeekChangeListener = listener;
    }

    @Deprecated
    public void setOnDateSelectedListener(OnDateSelectedListener listener) {
        this.mDelegate.mDateSelectedListener = listener;
        if (this.mDelegate.mDateSelectedListener == null) {
            return;
        }
        if (!this.isInRange(this.mDelegate.mSelectedCalendar)) {
            return;
        }
        this.post(new Runnable(){

            @Override
            public void run() {
                CalendarView.this.mDelegate.updateSelectCalendarScheme();
                ((CalendarView)CalendarView.this).mDelegate.mDateSelectedListener.onDateSelected(((CalendarView)CalendarView.this).mDelegate.mSelectedCalendar, false);
            }
        });
    }

    public void setOnCalendarSelectListener(OnCalendarSelectListener listener) {
        this.mDelegate.mCalendarSelectListener = listener;
        if (this.mDelegate.mCalendarSelectListener == null) {
            return;
        }
        if (!this.isInRange(this.mDelegate.mSelectedCalendar)) {
            return;
        }
        this.post(new Runnable(){

            @Override
            public void run() {
                CalendarView.this.mDelegate.updateSelectCalendarScheme();
                ((CalendarView)CalendarView.this).mDelegate.mCalendarSelectListener.onCalendarSelect(((CalendarView)CalendarView.this).mDelegate.mSelectedCalendar, false);
            }
        });
    }

    @Deprecated
    public void setOnDateLongClickListener(OnDateLongClickListener listener) {
        this.mDelegate.mDateLongClickListener = listener;
    }

    public void setOnCalendarLongClickListener(OnCalendarLongClickListener listener) {
        this.mDelegate.mCalendarLongClickListener = listener;
    }

    @Deprecated
    public void setOnDateLongClickListener(OnDateLongClickListener listener, boolean preventLongPressedSelect) {
        this.mDelegate.mDateLongClickListener = listener;
        this.mDelegate.setPreventLongPressedSelected(preventLongPressedSelect);
    }

    public void setOnCalendarLongClickListener(OnCalendarLongClickListener listener, boolean preventLongPressedSelect) {
        this.mDelegate.mCalendarLongClickListener = listener;
        this.mDelegate.setPreventLongPressedSelected(preventLongPressedSelect);
    }

    public void setOnViewChangeListener(OnViewChangeListener listener) {
        this.mDelegate.mViewChangeListener = listener;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.getParent() != null && this.getParent() instanceof CalendarLayout) {
            this.mParentLayout = (CalendarLayout)this.getParent();
            this.mParentLayout.mItemHeight = this.mDelegate.getCalendarItemHeight();
            this.mMonthPager.mParentLayout = this.mParentLayout;
            this.mWeekPager.mParentLayout = this.mParentLayout;
            this.mParentLayout.mWeekBar = this.mWeekBar;
            this.mParentLayout.setup(this.mDelegate);
            this.mParentLayout.initStatus();
        }
    }

    @Deprecated
    public void setSchemeDate(List<Calendar> mSchemeDate) {
        this.mDelegate.mSchemeDate = mSchemeDate;
        this.mDelegate.mSchemeDatesMap = null;
        this.mDelegate.clearSelectedScheme();
        this.mDelegate.setSchemeType(1);
        this.mSelectLayout.update();
        this.mMonthPager.updateScheme();
        this.mWeekPager.updateScheme();
    }

    public void setSchemeDate(Map<String, Calendar> mSchemeDates) {
        this.mDelegate.mSchemeDatesMap = mSchemeDates;
        this.mDelegate.mSchemeDate = null;
        this.mDelegate.clearSelectedScheme();
        this.mDelegate.setSchemeType(2);
        this.mSelectLayout.update();
        this.mMonthPager.updateScheme();
        this.mWeekPager.updateScheme();
    }

    public void clearSchemeDate() {
        this.mDelegate.mSchemeDatesMap = null;
        this.mDelegate.mSchemeDate = null;
        this.mDelegate.clearSelectedScheme();
        this.mSelectLayout.update();
        this.mMonthPager.updateScheme();
        this.mWeekPager.updateScheme();
    }

    public void removeSchemeDate(Calendar calendar) {
        if (calendar == null) {
            return;
        }
        if (this.mDelegate.getSchemeType() == 1) {
            if (this.mDelegate.mSchemeDate == null || this.mDelegate.mSchemeDate.size() == 0) {
                return;
            }
            if (this.mDelegate.mSchemeDate.contains(calendar)) {
                this.mDelegate.mSchemeDate.remove(calendar);
            }
        } else {
            if (this.mDelegate.mSchemeDatesMap == null || this.mDelegate.mSchemeDatesMap.size() == 0) {
                return;
            }
            if (this.mDelegate.mSchemeDatesMap.containsKey(calendar.toString())) {
                this.mDelegate.mSchemeDatesMap.remove(calendar.toString());
            }
        }
        if (this.mDelegate.mSelectedCalendar.equals(calendar)) {
            this.mDelegate.clearSelectedScheme();
        }
        this.mSelectLayout.update();
        this.mMonthPager.updateScheme();
        this.mWeekPager.updateScheme();
    }

    public void setBackground(int yearViewBackground, int weekBackground, int lineBg) {
        this.mWeekBar.setBackgroundColor(weekBackground);
        this.mSelectLayout.setBackgroundColor(yearViewBackground);
        this.mWeekLine.setBackgroundColor(lineBg);
    }

    public void setTextColor(int currentDayTextColor, int curMonthTextColor, int otherMonthColor, int curMonthLunarTextColor, int otherMonthLunarTextColor) {
        this.mDelegate.setTextColor(currentDayTextColor, curMonthTextColor, otherMonthColor, curMonthLunarTextColor, otherMonthLunarTextColor);
    }

    public void setSelectedColor(int selectedThemeColor, int selectedTextColor, int selectedLunarTextColor) {
        this.mDelegate.setSelectColor(selectedThemeColor, selectedTextColor, selectedLunarTextColor);
    }

    public void setThemeColor(int selectedThemeColor, int schemeColor) {
        this.mDelegate.setThemeColor(selectedThemeColor, schemeColor);
    }

    public void setSchemeColor(int schemeColor, int schemeTextColor, int schemeLunarTextColor) {
        this.mDelegate.setSchemeColor(schemeColor, schemeTextColor, schemeLunarTextColor);
    }

    public void setYearViewTextColor(int yearViewMonthTextColor, int yearViewDayTextColor, int yarViewSchemeTextColor) {
        this.mDelegate.setYearViewTextColor(yearViewMonthTextColor, yearViewDayTextColor, yarViewSchemeTextColor);
    }

    public void setWeeColor(int weekBackground, int weekTextColor) {
        this.mWeekBar.setBackgroundColor(weekBackground);
        this.mWeekBar.setTextColor(weekTextColor);
    }

    public void setSelectDefaultMode() {
        if (this.mDelegate.getSelectMode() == 0) {
            return;
        }
        this.mDelegate.mSelectedCalendar = this.mDelegate.mIndexCalendar;
        this.mDelegate.setSelectMode(0);
        this.mWeekBar.onDateSelected(this.mDelegate.mSelectedCalendar, this.mDelegate.getWeekStart(), false);
        this.mMonthPager.updateDefaultSelect();
        this.mWeekPager.updateDefaultSelect();
    }

    public void setSelectSingleMode() {
        if (this.mDelegate.getSelectMode() == 1) {
            return;
        }
        this.mDelegate.setSelectMode(1);
        this.mWeekPager.updateSelected();
        this.mMonthPager.updateSelected();
    }

    public void setWeekStarWithSun() {
        this.setWeekStart(1);
    }

    public void setWeekStarWithMon() {
        this.setWeekStart(2);
    }

    public void setWeekStarWithSat() {
        this.setWeekStart(7);
    }

    private void setWeekStart(int weekStart) {
        if (weekStart != 1 && weekStart != 2 && weekStart != 7) {
            return;
        }
        if (weekStart == this.mDelegate.getWeekStart()) {
            return;
        }
        this.mDelegate.setWeekStart(weekStart);
        this.mWeekBar.onWeekStartChange(weekStart);
        this.mWeekBar.onDateSelected(this.mDelegate.mSelectedCalendar, weekStart, false);
        this.mWeekPager.updateWeekStart();
        this.mMonthPager.updateWeekStart();
        this.mSelectLayout.updateWeekStart();
    }

    public boolean isSingleSelectMode() {
        return this.mDelegate.getSelectMode() == 1;
    }

    public void setAllMode() {
        this.setShowMode(0);
    }

    public void setOnlyCurrentMode() {
        this.setShowMode(1);
    }

    public void setFixMode() {
        this.setShowMode(2);
    }

    private void setShowMode(int mode) {
        if (mode != 0 && mode != 1 && mode != 2) {
            return;
        }
        if (this.mDelegate.getMonthViewShowMode() == mode) {
            return;
        }
        this.mDelegate.setMonthViewShowMode(mode);
        this.mWeekPager.updateShowMode();
        this.mMonthPager.updateShowMode();
        this.mWeekPager.notifyDataSetChanged();
    }

    public void update() {
        this.mWeekBar.onWeekStartChange(this.mDelegate.getWeekStart());
        this.mSelectLayout.update();
        this.mMonthPager.updateScheme();
        this.mWeekPager.updateScheme();
    }

    public void updateWeekBar() {
        this.mWeekBar.onWeekStartChange(this.mDelegate.getWeekStart());
    }

    public void updateCurrentDate() {
        this.mDelegate.updateCurrentDay();
        this.mMonthPager.updateCurrentDate();
        this.mWeekPager.updateCurrentDate();
    }

    public List<Calendar> getCurrentWeekCalendars() {
        return this.mWeekPager.getCurrentWeekCalendars();
    }

    public Calendar getSelectedCalendar() {
        return this.mDelegate.mSelectedCalendar;
    }

    public Calendar getMinRangeCalendar() {
        return this.mDelegate.getMinRangeCalendar();
    }

    public Calendar getMaxRangeCalendar() {
        return this.mDelegate.getMaxRangeCalendar();
    }

    public MonthViewPager getMonthViewPager() {
        return this.mMonthPager;
    }

    public WeekViewPager getWeekViewPager() {
        return this.mWeekPager;
    }

    protected final boolean isInRange(Calendar calendar) {
        return this.mDelegate != null && CalendarUtil.isCalendarInRange(calendar, this.mDelegate);
    }

    public static interface OnCalendarInterceptListener {
        public boolean onCalendarIntercept(Calendar var1);

        public void onCalendarInterceptClick(Calendar var1, boolean var2);
    }

    public static interface OnViewChangeListener {
        public void onViewChange(boolean var1);
    }

    public static interface OnCalendarLongClickListener {
        public void onCalendarLongClickOutOfRange(Calendar var1);

        public void onCalendarLongClick(Calendar var1);
    }

    @Deprecated
    public static interface OnDateLongClickListener {
        @Deprecated
        public void onDateLongClick(Calendar var1);
    }

    public static interface OnCalendarSelectListener {
        public void onCalendarOutOfRange(Calendar var1);

        public void onCalendarSelect(Calendar var1, boolean var2);
    }

    @Deprecated
    public static interface OnDateSelectedListener {
        @Deprecated
        public void onDateSelected(Calendar var1, boolean var2);
    }

    static interface OnInnerDateSelectedListener {
        public void onMonthDateSelected(Calendar var1, boolean var2);

        public void onWeekDateSelected(Calendar var1, boolean var2);
    }

    public static interface OnWeekChangeListener {
        public void onWeekChange(List<Calendar> var1);
    }

    public static interface OnMonthChangeListener {
        public void onMonthChange(int var1, int var2);
    }

    public static interface OnYearChangeListener {
        public void onYearChange(int var1);
    }
}

