/*
 * Decompiled with CFR 0.152.
 */
package com.haibin.calendarview;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.AttributeSet;
import com.haibin.calendarview.Calendar;
import com.haibin.calendarview.CalendarUtil;
import com.haibin.calendarview.CalendarView;
import com.haibin.calendarview.LunarCalendar;
import com.haibin.calendarview.R;
import java.util.Date;
import java.util.List;
import java.util.Map;

final class CalendarViewDelegate {
    static final int WEEK_START_WITH_SUN = 1;
    static final int WEEK_START_WITH_MON = 2;
    static final int WEEK_START_WITH_SAT = 7;
    static final int SCHEME_TYPE_LIST = 1;
    static final int SCHEME_TYPE_MAP = 2;
    static final int MODE_ALL_MONTH = 0;
    static final int MODE_ONLY_CURRENT_MONTH = 1;
    static final int MODE_FIT_MONTH = 2;
    private int mMonthViewShowMode;
    private int mWeekStart;
    static final int SELECT_MODE_DEFAULT = 0;
    static final int SELECT_MODE_SINGLE = 1;
    private int mSelectMode;
    static final int MIN_YEAR = 1900;
    private static final int MAX_YEAR = 2099;
    private int mCurDayTextColor;
    private int mCurDayLunarTextColor;
    private int mWeekTextColor;
    private int mSchemeTextColor;
    private int mSchemeLunarTextColor;
    private int mOtherMonthTextColor;
    private int mCurrentMonthTextColor;
    private int mSelectedTextColor;
    private int mSelectedLunarTextColor;
    private int mCurMonthLunarTextColor;
    private int mOtherMonthLunarTextColor;
    private boolean preventLongPressedSelected;
    private int mCalendarPadding;
    private int mYearViewMonthTextSize;
    private int mYearViewDayTextSize;
    private int mYearViewMonthTextColor;
    private int mYearViewDayTextColor;
    private int mYearViewSchemeTextColor;
    private int mWeekLineBackground;
    private int mYearViewBackground;
    private int mWeekBackground;
    private int mWeekLineMargin;
    private int mWeekTextSize;
    private int mSchemeThemeColor;
    private int mSelectedThemeColor;
    private String mMonthViewClass;
    private String mWeekViewClass;
    private String mWeekBarClass;
    boolean isShowYearSelectedLayout;
    private String mSchemeText;
    private int mMinYear;
    private int mMaxYear;
    private int mMinYearMonth;
    private int mMaxYearMonth;
    private int mMinYearDay;
    private int mMaxYearDay;
    private int mDayTextSize;
    private int mLunarTextSize;
    private int mCalendarItemHeight;
    private int mWeekBarHeight;
    private Calendar mCurrentDate;
    private boolean mMonthViewScrollable;
    private boolean mWeekViewScrollable;
    private boolean mYearViewScrollable;
    int mCurrentMonthViewItem;
    private int mSchemeType;
    List<Calendar> mSchemeDate;
    Map<String, Calendar> mSchemeDatesMap;
    CalendarView.OnCalendarInterceptListener mCalendarInterceptListener;
    @Deprecated
    CalendarView.OnDateSelectedListener mDateSelectedListener;
    CalendarView.OnCalendarSelectListener mCalendarSelectListener;
    @Deprecated
    CalendarView.OnDateLongClickListener mDateLongClickListener;
    CalendarView.OnCalendarLongClickListener mCalendarLongClickListener;
    CalendarView.OnInnerDateSelectedListener mInnerListener;
    CalendarView.OnYearChangeListener mYearChangeListener;
    CalendarView.OnMonthChangeListener mMonthChangeListener;
    CalendarView.OnWeekChangeListener mWeekChangeListener;
    CalendarView.OnViewChangeListener mViewChangeListener;
    Calendar mSelectedCalendar;
    Calendar mIndexCalendar;

    CalendarViewDelegate(Context context, @Nullable AttributeSet attrs) {
        TypedArray array2 = context.obtainStyledAttributes(attrs, R.styleable.CalendarView);
        LunarCalendar.init(context);
        this.mCalendarPadding = (int)array2.getDimension(R.styleable.CalendarView_calendar_padding, 0.0f);
        this.mSchemeTextColor = array2.getColor(R.styleable.CalendarView_scheme_text_color, -1);
        this.mSchemeLunarTextColor = array2.getColor(R.styleable.CalendarView_scheme_lunar_text_color, -1973791);
        this.mSchemeThemeColor = array2.getColor(R.styleable.CalendarView_scheme_theme_color, 1355796431);
        this.mMonthViewClass = array2.getString(R.styleable.CalendarView_month_view);
        this.mWeekViewClass = array2.getString(R.styleable.CalendarView_week_view);
        this.mWeekBarClass = array2.getString(R.styleable.CalendarView_week_bar_view);
        this.mWeekTextSize = array2.getDimensionPixelSize(R.styleable.CalendarView_week_text_size, CalendarUtil.dipToPx(context, 12.0f));
        this.mWeekBarHeight = (int)array2.getDimension(R.styleable.CalendarView_week_bar_height, (float)CalendarUtil.dipToPx(context, 40.0f));
        this.mWeekLineMargin = (int)array2.getDimension(R.styleable.CalendarView_week_line_margin, (float)CalendarUtil.dipToPx(context, 0.0f));
        this.mSchemeText = array2.getString(R.styleable.CalendarView_scheme_text);
        if (TextUtils.isEmpty((CharSequence)this.mSchemeText)) {
            this.mSchemeText = "\u8bb0";
        }
        this.mMonthViewScrollable = array2.getBoolean(R.styleable.CalendarView_month_view_scrollable, true);
        this.mWeekViewScrollable = array2.getBoolean(R.styleable.CalendarView_week_view_scrollable, true);
        this.mYearViewScrollable = array2.getBoolean(R.styleable.CalendarView_year_view_scrollable, true);
        this.mMonthViewShowMode = array2.getInt(R.styleable.CalendarView_month_view_show_mode, 0);
        this.mWeekStart = array2.getInt(R.styleable.CalendarView_week_start_with, 1);
        this.mSelectMode = array2.getInt(R.styleable.CalendarView_select_mode, 0);
        this.mWeekBackground = array2.getColor(R.styleable.CalendarView_week_background, -1);
        this.mWeekLineBackground = array2.getColor(R.styleable.CalendarView_week_line_background, 0);
        this.mYearViewBackground = array2.getColor(R.styleable.CalendarView_year_view_background, -1);
        this.mWeekTextColor = array2.getColor(R.styleable.CalendarView_week_text_color, -13421773);
        this.mCurDayTextColor = array2.getColor(R.styleable.CalendarView_current_day_text_color, -65536);
        this.mCurDayLunarTextColor = array2.getColor(R.styleable.CalendarView_current_day_lunar_text_color, -65536);
        this.mSelectedThemeColor = array2.getColor(R.styleable.CalendarView_selected_theme_color, 1355796431);
        this.mSelectedTextColor = array2.getColor(R.styleable.CalendarView_selected_text_color, -15658735);
        this.mSelectedLunarTextColor = array2.getColor(R.styleable.CalendarView_selected_lunar_text_color, -15658735);
        this.mCurrentMonthTextColor = array2.getColor(R.styleable.CalendarView_current_month_text_color, -15658735);
        this.mOtherMonthTextColor = array2.getColor(R.styleable.CalendarView_other_month_text_color, -1973791);
        this.mCurMonthLunarTextColor = array2.getColor(R.styleable.CalendarView_current_month_lunar_text_color, -1973791);
        this.mOtherMonthLunarTextColor = array2.getColor(R.styleable.CalendarView_other_month_lunar_text_color, -1973791);
        this.mMinYear = array2.getInt(R.styleable.CalendarView_min_year, 1971);
        this.mMaxYear = array2.getInt(R.styleable.CalendarView_max_year, 2055);
        this.mMinYearMonth = array2.getInt(R.styleable.CalendarView_min_year_month, 1);
        this.mMaxYearMonth = array2.getInt(R.styleable.CalendarView_max_year_month, 12);
        this.mMinYearDay = array2.getInt(R.styleable.CalendarView_min_year_day, 1);
        this.mMaxYearDay = array2.getInt(R.styleable.CalendarView_max_year_day, -1);
        this.mDayTextSize = array2.getDimensionPixelSize(R.styleable.CalendarView_day_text_size, CalendarUtil.dipToPx(context, 16.0f));
        this.mLunarTextSize = array2.getDimensionPixelSize(R.styleable.CalendarView_lunar_text_size, CalendarUtil.dipToPx(context, 10.0f));
        this.mCalendarItemHeight = (int)array2.getDimension(R.styleable.CalendarView_calendar_height, (float)CalendarUtil.dipToPx(context, 56.0f));
        this.mYearViewMonthTextSize = array2.getDimensionPixelSize(R.styleable.CalendarView_year_view_month_text_size, CalendarUtil.dipToPx(context, 18.0f));
        this.mYearViewDayTextSize = array2.getDimensionPixelSize(R.styleable.CalendarView_year_view_day_text_size, CalendarUtil.dipToPx(context, 8.0f));
        this.mYearViewMonthTextColor = array2.getColor(R.styleable.CalendarView_year_view_month_text_color, -15658735);
        this.mYearViewDayTextColor = array2.getColor(R.styleable.CalendarView_year_view_day_text_color, -15658735);
        this.mYearViewSchemeTextColor = array2.getColor(R.styleable.CalendarView_year_view_scheme_color, this.mSchemeThemeColor);
        if (this.mMinYear <= 1900) {
            this.mMinYear = 1971;
        }
        if (this.mMaxYear >= 2099) {
            this.mMaxYear = 2055;
        }
        array2.recycle();
        this.init();
    }

    private void init() {
        this.mCurrentDate = new Calendar();
        Date d = new Date();
        this.mCurrentDate.setYear(CalendarUtil.getDate("yyyy", d));
        this.mCurrentDate.setMonth(CalendarUtil.getDate("MM", d));
        this.mCurrentDate.setDay(CalendarUtil.getDate("dd", d));
        this.mCurrentDate.setCurrentDay(true);
        LunarCalendar.setupLunarCalendar(this.mCurrentDate);
        this.setRange(this.mMinYear, this.mMinYearMonth, this.mMaxYear, this.mMaxYearMonth);
    }

    private void setRange(int minYear, int minYearMonth, int maxYear, int maxYearMonth) {
        this.mMinYear = minYear;
        this.mMinYearMonth = minYearMonth;
        this.mMaxYear = maxYear;
        this.mMaxYearMonth = maxYearMonth;
        if (this.mMaxYear < this.mCurrentDate.getYear()) {
            this.mMaxYear = this.mCurrentDate.getYear();
        }
        if (this.mMaxYearDay == -1) {
            this.mMaxYearDay = CalendarUtil.getMonthDaysCount(this.mMaxYear, this.mMaxYearMonth);
        }
        int y = this.mCurrentDate.getYear() - this.mMinYear;
        this.mCurrentMonthViewItem = 12 * y + this.mCurrentDate.getMonth() - this.mMinYearMonth;
    }

    void setRange(int minYear, int minYearMonth, int minYearDay, int maxYear, int maxYearMonth, int maxYearDay) {
        this.mMinYear = minYear;
        this.mMinYearMonth = minYearMonth;
        this.mMinYearDay = minYearDay;
        this.mMaxYear = maxYear;
        this.mMaxYearMonth = maxYearMonth;
        this.mMaxYearDay = maxYearDay;
        if (this.mMaxYear < this.mCurrentDate.getYear()) {
            this.mMaxYear = this.mCurrentDate.getYear();
        }
        if (this.mMaxYearDay == -1) {
            this.mMaxYearDay = CalendarUtil.getMonthDaysCount(this.mMaxYear, this.mMaxYearMonth);
        }
        int y = this.mCurrentDate.getYear() - this.mMinYear;
        this.mCurrentMonthViewItem = 12 * y + this.mCurrentDate.getMonth() - this.mMinYearMonth;
    }

    String getSchemeText() {
        return this.mSchemeText;
    }

    int getCurDayTextColor() {
        return this.mCurDayTextColor;
    }

    int getCurDayLunarTextColor() {
        return this.mCurDayLunarTextColor;
    }

    int getWeekTextColor() {
        return this.mWeekTextColor;
    }

    int getSchemeTextColor() {
        return this.mSchemeTextColor;
    }

    int getSchemeLunarTextColor() {
        return this.mSchemeLunarTextColor;
    }

    int getOtherMonthTextColor() {
        return this.mOtherMonthTextColor;
    }

    int getCurrentMonthTextColor() {
        return this.mCurrentMonthTextColor;
    }

    int getSelectedTextColor() {
        return this.mSelectedTextColor;
    }

    int getSelectedLunarTextColor() {
        return this.mSelectedLunarTextColor;
    }

    int getCurrentMonthLunarTextColor() {
        return this.mCurMonthLunarTextColor;
    }

    int getOtherMonthLunarTextColor() {
        return this.mOtherMonthLunarTextColor;
    }

    int getSchemeThemeColor() {
        return this.mSchemeThemeColor;
    }

    int getSelectedThemeColor() {
        return this.mSelectedThemeColor;
    }

    int getWeekBackground() {
        return this.mWeekBackground;
    }

    int getYearViewBackground() {
        return this.mYearViewBackground;
    }

    int getWeekLineBackground() {
        return this.mWeekLineBackground;
    }

    int getWeekLineMargin() {
        return this.mWeekLineMargin;
    }

    String getMonthViewClass() {
        return this.mMonthViewClass;
    }

    String getWeekViewClass() {
        return this.mWeekViewClass;
    }

    String getWeekBarClass() {
        return this.mWeekBarClass;
    }

    int getWeekBarHeight() {
        return this.mWeekBarHeight;
    }

    int getMinYear() {
        return this.mMinYear;
    }

    int getMaxYear() {
        return this.mMaxYear;
    }

    int getDayTextSize() {
        return this.mDayTextSize;
    }

    int getLunarTextSize() {
        return this.mLunarTextSize;
    }

    int getCalendarItemHeight() {
        return this.mCalendarItemHeight;
    }

    int getMinYearMonth() {
        return this.mMinYearMonth;
    }

    int getMaxYearMonth() {
        return this.mMaxYearMonth;
    }

    int getYearViewMonthTextSize() {
        return this.mYearViewMonthTextSize;
    }

    int getYearViewMonthTextColor() {
        return this.mYearViewMonthTextColor;
    }

    int getYearViewDayTextColor() {
        return this.mYearViewDayTextColor;
    }

    int getYearViewDayTextSize() {
        return this.mYearViewDayTextSize;
    }

    int getYearViewSchemeTextColor() {
        return this.mYearViewSchemeTextColor;
    }

    int getMonthViewShowMode() {
        return this.mMonthViewShowMode;
    }

    void setMonthViewShowMode(int monthViewShowMode) {
        this.mMonthViewShowMode = monthViewShowMode;
    }

    void setTextColor(int curDayTextColor, int curMonthTextColor, int otherMonthTextColor, int curMonthLunarTextColor, int otherMonthLunarTextColor) {
        this.mCurDayTextColor = curDayTextColor;
        this.mOtherMonthTextColor = otherMonthTextColor;
        this.mCurrentMonthTextColor = curMonthTextColor;
        this.mCurMonthLunarTextColor = curMonthLunarTextColor;
        this.mOtherMonthLunarTextColor = otherMonthLunarTextColor;
    }

    void setSchemeColor(int schemeColor, int schemeTextColor, int schemeLunarTextColor) {
        this.mSchemeThemeColor = schemeColor;
        this.mSchemeTextColor = schemeTextColor;
        this.mSchemeLunarTextColor = schemeLunarTextColor;
    }

    void setYearViewTextColor(int yearViewMonthTextColor, int yearViewDayTextColor, int yarViewSchemeTextColor) {
        this.mYearViewMonthTextColor = yearViewMonthTextColor;
        this.mYearViewDayTextColor = yearViewDayTextColor;
        this.mYearViewSchemeTextColor = yarViewSchemeTextColor;
    }

    void setSelectColor(int selectedColor, int selectedTextColor, int selectedLunarTextColor) {
        this.mSelectedThemeColor = selectedColor;
        this.mSelectedTextColor = selectedTextColor;
        this.mSelectedLunarTextColor = selectedLunarTextColor;
    }

    void setThemeColor(int selectedThemeColor, int schemeColor) {
        this.mSelectedThemeColor = selectedThemeColor;
        this.mSchemeThemeColor = schemeColor;
    }

    boolean isMonthViewScrollable() {
        return this.mMonthViewScrollable;
    }

    boolean isWeekViewScrollable() {
        return this.mWeekViewScrollable;
    }

    boolean isYearViewScrollable() {
        return this.mYearViewScrollable;
    }

    int getWeekStart() {
        return this.mWeekStart;
    }

    void setWeekStart(int mWeekStart) {
        this.mWeekStart = mWeekStart;
    }

    int getWeekTextSize() {
        return this.mWeekTextSize;
    }

    int getSelectMode() {
        return this.mSelectMode;
    }

    void setSelectMode(int mSelectMode) {
        this.mSelectMode = mSelectMode;
    }

    Calendar getCurrentDay() {
        return this.mCurrentDate;
    }

    void updateCurrentDay() {
        Date d = new Date();
        this.mCurrentDate.setYear(CalendarUtil.getDate("yyyy", d));
        this.mCurrentDate.setMonth(CalendarUtil.getDate("MM", d));
        this.mCurrentDate.setDay(CalendarUtil.getDate("dd", d));
        LunarCalendar.setupLunarCalendar(this.mCurrentDate);
    }

    int getCalendarPadding() {
        return this.mCalendarPadding;
    }

    int getSchemeType() {
        return this.mSchemeType;
    }

    void setSchemeType(int schemeType) {
        this.mSchemeType = schemeType;
    }

    void setPreventLongPressedSelected(boolean preventLongPressedSelected) {
        this.preventLongPressedSelected = preventLongPressedSelected;
    }

    void setMonthViewClass(String monthViewClass) {
        this.mMonthViewClass = monthViewClass;
    }

    void setWeekBarClass(String weekBarClass) {
        this.mWeekBarClass = weekBarClass;
    }

    void setWeekViewClass(String weekViewClass) {
        this.mWeekViewClass = weekViewClass;
    }

    boolean isPreventLongPressedSelected() {
        return this.preventLongPressedSelected;
    }

    void clearSelectedScheme() {
        this.mSelectedCalendar.clearScheme();
    }

    int getMinYearDay() {
        return this.mMinYearDay;
    }

    int getMaxYearDay() {
        return this.mMaxYearDay;
    }

    final void updateSelectCalendarScheme() {
        String key;
        if (this.getSchemeType() == 1 && this.mSchemeDate != null && this.mSchemeDate.size() > 0 && this.mSchemeDate.contains(this.mSelectedCalendar)) {
            Calendar d = this.mSchemeDate.get(this.mSchemeDate.indexOf(this.mSelectedCalendar));
            this.mSelectedCalendar.mergeScheme(d, this.getSchemeText());
        }
        if (this.getSchemeType() == 2 && this.mSchemeDatesMap != null && this.mSchemeDatesMap.size() > 0 && this.mSchemeDatesMap.containsKey(key = this.mSelectedCalendar.toString())) {
            Calendar d = this.mSchemeDatesMap.get(key);
            this.mSelectedCalendar.mergeScheme(d, this.getSchemeText());
        }
    }

    Calendar createCurrentDate() {
        Calendar calendar = new Calendar();
        calendar.setYear(this.mCurrentDate.getYear());
        calendar.setWeek(this.mCurrentDate.getWeek());
        calendar.setMonth(this.mCurrentDate.getMonth());
        calendar.setDay(this.mCurrentDate.getDay());
        calendar.setCurrentDay(true);
        LunarCalendar.setupLunarCalendar(calendar);
        return calendar;
    }

    final Calendar getMinRangeCalendar() {
        Calendar calendar = new Calendar();
        calendar.setYear(this.mMinYear);
        calendar.setMonth(this.mMinYearMonth);
        calendar.setDay(this.mMinYearDay);
        calendar.setCurrentDay(calendar.equals(this.mCurrentDate));
        LunarCalendar.setupLunarCalendar(calendar);
        return calendar;
    }

    final Calendar getMaxRangeCalendar() {
        Calendar calendar = new Calendar();
        calendar.setYear(this.mMaxYear);
        calendar.setMonth(this.mMaxYearMonth);
        calendar.setDay(this.mMaxYearDay);
        calendar.setCurrentDay(calendar.equals(this.mCurrentDate));
        LunarCalendar.setupLunarCalendar(calendar);
        return calendar;
    }

    final void addSchemesFromList(List<Calendar> mItems) {
        if (this.mSchemeDate == null || this.mSchemeDate.size() == 0) {
            return;
        }
        for (Calendar a : mItems) {
            if (this.mSchemeDate.contains(a)) {
                Calendar d = this.mSchemeDate.get(this.mSchemeDate.indexOf(a));
                a.setScheme(TextUtils.isEmpty((CharSequence)d.getScheme()) ? this.getSchemeText() : d.getScheme());
                a.setSchemeColor(d.getSchemeColor());
                a.setSchemes(d.getSchemes());
                continue;
            }
            a.setScheme("");
            a.setSchemeColor(0);
            a.setSchemes(null);
        }
    }

    final void addSchemesFromMap(List<Calendar> mItems) {
        if (this.mSchemeDatesMap == null || this.mSchemeDatesMap.size() == 0) {
            return;
        }
        for (Calendar a : mItems) {
            if (this.mSchemeDatesMap.containsKey(a.toString())) {
                Calendar d = this.mSchemeDatesMap.get(a.toString());
                a.setScheme(TextUtils.isEmpty((CharSequence)d.getScheme()) ? this.getSchemeText() : d.getScheme());
                a.setSchemeColor(d.getSchemeColor());
                a.setSchemes(d.getSchemes());
                continue;
            }
            a.setScheme("");
            a.setSchemeColor(0);
            a.setSchemes(null);
        }
    }
}

