/*
 * Decompiled with CFR 0.152.
 */
package com.haibin.calendarview;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import com.haibin.calendarview.Calendar;
import com.haibin.calendarview.CalendarUtil;
import com.haibin.calendarview.MonthView;

public final class DefaultMonthView
extends MonthView {
    private Paint mTextPaint = new Paint();
    private Paint mSchemeBasicPaint = new Paint();
    private float mRadio;
    private int mPadding;
    private float mSchemeBaseLine;

    public DefaultMonthView(Context context) {
        super(context);
        this.mTextPaint.setTextSize((float)CalendarUtil.dipToPx(context, 8.0f));
        this.mTextPaint.setColor(-1);
        this.mTextPaint.setAntiAlias(true);
        this.mTextPaint.setFakeBoldText(true);
        this.mSchemeBasicPaint.setAntiAlias(true);
        this.mSchemeBasicPaint.setStyle(Paint.Style.FILL);
        this.mSchemeBasicPaint.setTextAlign(Paint.Align.CENTER);
        this.mSchemeBasicPaint.setColor(-1223853);
        this.mSchemeBasicPaint.setFakeBoldText(true);
        this.mRadio = CalendarUtil.dipToPx(this.getContext(), 7.0f);
        this.mPadding = CalendarUtil.dipToPx(this.getContext(), 4.0f);
        Paint.FontMetrics metrics = this.mSchemeBasicPaint.getFontMetrics();
        this.mSchemeBaseLine = this.mRadio - metrics.descent + (metrics.bottom - metrics.top) / 2.0f + (float)CalendarUtil.dipToPx(this.getContext(), 1.0f);
    }

    @Override
    protected boolean onDrawSelected(Canvas canvas, Calendar calendar, int x, int y, boolean hasScheme) {
        this.mSelectedPaint.setStyle(Paint.Style.FILL);
        canvas.drawRect((float)(x + this.mPadding), (float)(y + this.mPadding), (float)(x + this.mItemWidth - this.mPadding), (float)(y + this.mItemHeight - this.mPadding), this.mSelectedPaint);
        return true;
    }

    @Override
    protected void onDrawScheme(Canvas canvas, Calendar calendar, int x, int y) {
        this.mSchemeBasicPaint.setColor(calendar.getSchemeColor());
        canvas.drawCircle((float)(x + this.mItemWidth - this.mPadding) - this.mRadio / 2.0f, (float)(y + this.mPadding) + this.mRadio, this.mRadio, this.mSchemeBasicPaint);
        canvas.drawText(calendar.getScheme(), (float)(x + this.mItemWidth - this.mPadding) - this.mRadio / 2.0f - this.getTextWidth(calendar.getScheme()) / 2.0f, (float)(y + this.mPadding) + this.mSchemeBaseLine, this.mTextPaint);
    }

    private float getTextWidth(String text) {
        return this.mTextPaint.measureText(text);
    }

    @Override
    protected void onDrawText(Canvas canvas, Calendar calendar, int x, int y, boolean hasScheme, boolean isSelected) {
        int cx = x + this.mItemWidth / 2;
        int top = y - this.mItemHeight / 6;
        if (isSelected) {
            canvas.drawText(String.valueOf(calendar.getDay()), (float)cx, this.mTextBaseLine + (float)top, this.mSelectTextPaint);
            canvas.drawText(calendar.getLunar(), (float)cx, this.mTextBaseLine + (float)y + (float)(this.mItemHeight / 10), this.mSelectedLunarTextPaint);
        } else if (hasScheme) {
            canvas.drawText(String.valueOf(calendar.getDay()), (float)cx, this.mTextBaseLine + (float)top, calendar.isCurrentDay() ? this.mCurDayTextPaint : (calendar.isCurrentMonth() ? this.mSchemeTextPaint : this.mOtherMonthTextPaint));
            canvas.drawText(calendar.getLunar(), (float)cx, this.mTextBaseLine + (float)y + (float)(this.mItemHeight / 10), calendar.isCurrentDay() ? this.mCurDayLunarTextPaint : this.mSchemeLunarTextPaint);
        } else {
            canvas.drawText(String.valueOf(calendar.getDay()), (float)cx, this.mTextBaseLine + (float)top, calendar.isCurrentDay() ? this.mCurDayTextPaint : (calendar.isCurrentMonth() ? this.mCurMonthTextPaint : this.mOtherMonthTextPaint));
            canvas.drawText(calendar.getLunar(), (float)cx, this.mTextBaseLine + (float)y + (float)(this.mItemHeight / 10), calendar.isCurrentDay() ? this.mCurDayLunarTextPaint : (calendar.isCurrentMonth() ? this.mCurMonthLunarTextPaint : this.mOtherMonthLunarTextPaint));
        }
    }
}

