/*
 * Decompiled with CFR 0.152.
 */
package com.haibin.calendarview;

import android.annotation.SuppressLint;
import android.content.Context;
import android.text.TextUtils;
import com.haibin.calendarview.Calendar;
import com.haibin.calendarview.CalendarUtil;
import com.haibin.calendarview.LunarUtil;
import com.haibin.calendarview.R;
import com.haibin.calendarview.SolarTermUtil;
import java.util.HashMap;
import java.util.Map;

final class LunarCalendar {
    private static String[] MONTH_STR = null;
    private static String[] TRADITION_FESTIVAL_STR = null;
    private static String[] DAY_STR = null;
    private static String[] SPECIAL_FESTIVAL_STR = null;
    @SuppressLint(value={"UseSparseArrays"})
    private static final Map<Integer, String[]> SPECIAL_FESTIVAL = new HashMap<Integer, String[]>();
    private static String[] SOLAR_CALENDAR = null;
    @SuppressLint(value={"UseSparseArrays"})
    private static final Map<Integer, String[]> SOLAR_TERMS = new HashMap<Integer, String[]>();
    private static final int[] LUNAR_INFO = new int[]{8697535, 306771, 677704, 5580477, 861776, 890180, 4631225, 354893, 634178, 2404022, 306762, 6966718, 675154, 861510, 6116026, 742478, 879171, 2714935, 613195, 7642049, 300884, 674632, 5973436, 435536, 447557, 4905656, 177741, 612162, 2398135, 300874, 6703934, 870993, 959814, 5690554, 372046, 177732, 3749688, 601675, 8165055, 824659, 870984, 7185723, 742735, 354885, 4894137, 154957, 601410, 2921910, 693578, 8080061, 445009, 742726, 0x555ABB, 318030, 678723, 3484600, 338764, 9082175, 955730, 436808, 7001404, 701775, 308805, 4871993, 677709, 337474, 4100917, 890185, 7711422, 354897, 617798, 5549755, 306511, 675139, 5056183, 861515, 9261759, 742482, 748103, 6909244, 613200, 301893, 4869049, 674637, 11216322, 435540, 447561, 7002685, 702033, 612166, 5543867, 300879, 412484, 3581239, 959818, 8827583, 371795, 702023, 5846716, 601680, 824901, 5065400, 870988, 894273, 2468534, 354889, 8039869, 154962, 601415, 6067642, 693582, 739907, 4937015, 709962, 9788095, 309843, 678728, 6630332, 338768, 693061, 4672185, 436812, 709953, 2415286, 308810, 6969149, 675409, 861766, 6198074, 873293, 371267, 3585335, 617803, 11841215, 306515, 675144, 7153084, 861519, 873028, 6138424, 744012, 355649, 2403766, 301898, 8014782, 674641, 697670, 5984954, 447054, 711234, 3496759, 603979, 8689601, 300883, 412488, 6726972, 959823, 436804, 4896312, 699980, 601666, 3970869, 824905, 8211133, 870993, 894277, 0x55AABA, 354894, 683331, 4533943, 339275, 9082303, 693587, 739911, 7034171, 709967, 350789, 4873528, 678732, 338754, 3838902, 430921, 7809469, 436817, 709958, 5561018, 308814, 677699, 4532024, 861770, 9343806, 873042, 895559, 6731067, 355663, 306757, 4869817, 675148, 857409, 2986677};

    LunarCalendar() {
    }

    static void init(Context context) {
        if (MONTH_STR != null) {
            return;
        }
        SolarTermUtil.init(context);
        MONTH_STR = context.getResources().getStringArray(R.array.lunar_first_of_month);
        TRADITION_FESTIVAL_STR = context.getResources().getStringArray(R.array.tradition_festival);
        DAY_STR = context.getResources().getStringArray(R.array.lunar_str);
        SPECIAL_FESTIVAL_STR = context.getResources().getStringArray(R.array.special_festivals);
        SOLAR_CALENDAR = context.getResources().getStringArray(R.array.solar_festival);
    }

    private static String getTraditionFestival(int year, int month, int day) {
        int count;
        if (month == 12 && day == (count = LunarCalendar.daysInLunarMonth(year, month))) {
            return TRADITION_FESTIVAL_STR[0];
        }
        String text = LunarCalendar.getString(month, day);
        String festivalStr = "";
        for (String festival : TRADITION_FESTIVAL_STR) {
            if (!festival.contains(text)) continue;
            festivalStr = festival.replace(text, "");
            break;
        }
        return festivalStr;
    }

    private static String numToChineseMonth(int month, int leap) {
        if (leap == 1) {
            return String.format("\u95f0%s", MONTH_STR[month - 1]);
        }
        return MONTH_STR[month - 1];
    }

    private static String numToChinese(int month, int day, int leap) {
        if (day == 1) {
            return LunarCalendar.numToChineseMonth(month, leap);
        }
        return DAY_STR[day - 1];
    }

    private static int daysInLunarMonth(int year, int month) {
        if ((LUNAR_INFO[year - 1900] & 0x100000 >> month) == 0) {
            return 29;
        }
        return 30;
    }

    private static String gregorianFestival(int month, int day) {
        String text = LunarCalendar.getString(month, day);
        String solar = "";
        for (String aMSolarCalendar : SOLAR_CALENDAR) {
            if (!aMSolarCalendar.contains(text)) continue;
            solar = aMSolarCalendar.replace(text, "");
            break;
        }
        return solar;
    }

    private static String getString(int month, int day) {
        return (month >= 10 ? String.valueOf(month) : "0" + month) + (day >= 10 ? Integer.valueOf(day) : "0" + day);
    }

    private static String getSolarTerm(int year, int month, int day) {
        if (!SOLAR_TERMS.containsKey(year)) {
            SOLAR_TERMS.put(year, SolarTermUtil.getSolarTerms(year));
        }
        String[] solarTerm = SOLAR_TERMS.get(year);
        String text = String.format("%s%s", year, LunarCalendar.getString(month, day));
        String solar = "";
        for (String solarTermName : solarTerm) {
            if (!solarTermName.contains(text)) continue;
            solar = solarTermName.replace(text, "");
            break;
        }
        return solar;
    }

    private static String getLunarText(int year, int month, int day) {
        String termText = LunarCalendar.getSolarTerm(year, month, day);
        String solar = LunarCalendar.gregorianFestival(month, day);
        if (!TextUtils.isEmpty((CharSequence)solar)) {
            return solar;
        }
        if (!TextUtils.isEmpty((CharSequence)termText)) {
            return termText;
        }
        int[] lunar = LunarUtil.solarToLunar(year, month, day);
        String festival = LunarCalendar.getTraditionFestival(lunar[0], lunar[1], lunar[2]);
        if (!TextUtils.isEmpty((CharSequence)festival)) {
            return festival;
        }
        return LunarCalendar.numToChinese(lunar[1], lunar[2], lunar[3]);
    }

    private static String getSpecialFestival(int year, int month, int day) {
        if (!SPECIAL_FESTIVAL.containsKey(year)) {
            SPECIAL_FESTIVAL.put(year, LunarCalendar.getSpecialFestivals(year));
        }
        String[] specialFestivals = SPECIAL_FESTIVAL.get(year);
        String text = String.format("%s%s", year, LunarCalendar.getString(month, day));
        String solar = "";
        for (String special : specialFestivals) {
            if (!special.contains(text)) continue;
            solar = special.replace(text, "");
            break;
        }
        return solar;
    }

    private static String[] getSpecialFestivals(int year) {
        String[] festivals = new String[3];
        java.util.Calendar date = java.util.Calendar.getInstance();
        date.set(year, 4, 1);
        int week = date.get(7);
        int startDiff = 7 - week + 1;
        festivals[0] = startDiff == 7 ? LunarCalendar.dateToString(year, 5, startDiff + 1) + SPECIAL_FESTIVAL_STR[0] : LunarCalendar.dateToString(year, 5, startDiff + 7 + 1) + SPECIAL_FESTIVAL_STR[0];
        date.set(year, 5, 1);
        week = date.get(7);
        startDiff = 7 - week + 1;
        festivals[1] = startDiff == 7 ? LunarCalendar.dateToString(year, 6, startDiff + 7 + 1) + SPECIAL_FESTIVAL_STR[1] : LunarCalendar.dateToString(year, 6, startDiff + 7 + 7 + 1) + SPECIAL_FESTIVAL_STR[1];
        date.set(year, 10, 1);
        week = date.get(7);
        startDiff = 7 - week + 1;
        festivals[2] = startDiff <= 2 ? LunarCalendar.dateToString(year, 11, startDiff + 21 + 5) + SPECIAL_FESTIVAL_STR[2] : LunarCalendar.dateToString(year, 11, startDiff + 14 + 5) + SPECIAL_FESTIVAL_STR[2];
        return festivals;
    }

    private static String dateToString(int year, int month, int day) {
        return String.format("%s%s", year, LunarCalendar.getString(month, day));
    }

    static void setupLunarCalendar(Calendar calendar) {
        int year = calendar.getYear();
        int month = calendar.getMonth();
        int day = calendar.getDay();
        calendar.setWeekend(CalendarUtil.isWeekend(calendar));
        calendar.setWeek(CalendarUtil.getWeekFormCalendar(calendar));
        Calendar lunarCalendar = new Calendar();
        calendar.setLunarCakendar(lunarCalendar);
        int[] lunar = LunarUtil.solarToLunar(year, month, day);
        lunarCalendar.setYear(lunar[0]);
        lunarCalendar.setMonth(lunar[1]);
        lunarCalendar.setDay(lunar[2]);
        calendar.setLeapYear(CalendarUtil.isLeapYear(year));
        if (lunar[3] == 1) {
            calendar.setLeapMonth(lunar[1]);
            lunarCalendar.setLeapMonth(lunar[1]);
        }
        String solarTerm = LunarCalendar.getSolarTerm(year, month, day);
        String gregorian = LunarCalendar.gregorianFestival(month, day);
        String festival = LunarCalendar.getTraditionFestival(lunar[0], lunar[1], lunar[2]);
        if (TextUtils.isEmpty((CharSequence)gregorian)) {
            gregorian = LunarCalendar.getSpecialFestival(year, month, day);
        }
        calendar.setSolarTerm(solarTerm);
        calendar.setGregorianFestival(gregorian);
        calendar.setTraditionFestival(festival);
        lunarCalendar.setTraditionFestival(festival);
        lunarCalendar.setSolarTerm(solarTerm);
        if (!TextUtils.isEmpty((CharSequence)solarTerm)) {
            calendar.setLunar(solarTerm);
        } else if (!TextUtils.isEmpty((CharSequence)gregorian)) {
            calendar.setLunar(gregorian);
        } else if (!TextUtils.isEmpty((CharSequence)festival)) {
            calendar.setLunar(festival);
        } else {
            calendar.setLunar(LunarCalendar.numToChinese(lunar[1], lunar[2], lunar[3]));
        }
        lunarCalendar.setLunar(calendar.getLunar());
    }

    static String getLunarText(Calendar calendar) {
        return LunarCalendar.getLunarText(calendar.getYear(), calendar.getMonth(), calendar.getDay());
    }
}

