/*
 * Decompiled with CFR 0.152.
 */
package com.haibin.calendarview;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Canvas;
import android.view.View;
import com.haibin.calendarview.BaseView;
import com.haibin.calendarview.Calendar;
import com.haibin.calendarview.CalendarUtil;
import com.haibin.calendarview.MonthViewPager;

public abstract class MonthView
extends BaseView {
    MonthViewPager mMonthViewPager;
    private int mYear;
    private int mMonth;
    private int mLineCount;
    private int mHeight;
    private int mNextDiff;

    public MonthView(Context context) {
        super(context);
    }

    protected void onDraw(Canvas canvas) {
        if (this.mLineCount == 0) {
            return;
        }
        this.mItemWidth = (this.getWidth() - 2 * this.mDelegate.getCalendarPadding()) / 7;
        this.onPreviewHook();
        int count = this.mLineCount * 7;
        int d = 0;
        for (int i = 0; i < this.mLineCount; ++i) {
            for (int j = 0; j < 7; ++j) {
                Calendar calendar = (Calendar)this.mItems.get(d);
                if (this.mDelegate.getMonthViewShowMode() == 1) {
                    if (d > this.mItems.size() - this.mNextDiff) {
                        return;
                    }
                    if (!calendar.isCurrentMonth()) {
                        ++d;
                        continue;
                    }
                } else if (this.mDelegate.getMonthViewShowMode() == 2 && d >= count) {
                    return;
                }
                this.draw(canvas, calendar, i, j, d);
                ++d;
            }
        }
    }

    private void draw(Canvas canvas, Calendar calendar, int i, int j, int d) {
        int x = j * this.mItemWidth + this.mDelegate.getCalendarPadding();
        int y = i * this.mItemHeight;
        this.onLoopStart(x, y);
        boolean isSelected = d == this.mCurrentItem;
        boolean hasScheme = calendar.hasScheme();
        if (hasScheme) {
            boolean isDrawSelected = false;
            if (isSelected) {
                isDrawSelected = this.onDrawSelected(canvas, calendar, x, y, true);
            }
            if (isDrawSelected || !isSelected) {
                this.mSchemePaint.setColor(calendar.getSchemeColor() != 0 ? calendar.getSchemeColor() : this.mDelegate.getSchemeThemeColor());
                this.onDrawScheme(canvas, calendar, x, y);
            }
        } else if (isSelected) {
            this.onDrawSelected(canvas, calendar, x, y, false);
        }
        this.onDrawText(canvas, calendar, x, y, hasScheme, isSelected);
    }

    public void onClick(View v) {
        if (!this.isClick) {
            return;
        }
        Calendar calendar = this.getIndex();
        if (calendar == null) {
            return;
        }
        if (this.onCalendarIntercept(calendar)) {
            this.mDelegate.mCalendarInterceptListener.onCalendarInterceptClick(calendar, true);
            return;
        }
        if (this.mDelegate.getMonthViewShowMode() == 1 && !calendar.isCurrentMonth()) {
            return;
        }
        if (!this.isInRange(calendar)) {
            if (this.mDelegate.mCalendarSelectListener != null) {
                this.mDelegate.mCalendarSelectListener.onCalendarOutOfRange(calendar);
            }
            return;
        }
        this.mCurrentItem = this.mItems.indexOf(calendar);
        if (!calendar.isCurrentMonth() && this.mMonthViewPager != null) {
            int cur = this.mMonthViewPager.getCurrentItem();
            int position = this.mCurrentItem < 7 ? cur - 1 : cur + 1;
            this.mMonthViewPager.setCurrentItem(position);
        }
        if (this.mDelegate.mInnerListener != null) {
            this.mDelegate.mInnerListener.onMonthDateSelected(calendar, true);
        }
        if (this.mParentLayout != null) {
            if (calendar.isCurrentMonth()) {
                this.mParentLayout.updateSelectPosition(this.mItems.indexOf(calendar));
            } else {
                this.mParentLayout.updateSelectWeek(CalendarUtil.getWeekFromDayInMonth(calendar, this.mDelegate.getWeekStart()));
            }
        }
        if (this.mDelegate.mDateSelectedListener != null) {
            this.mDelegate.mDateSelectedListener.onDateSelected(calendar, true);
        }
        if (this.mDelegate.mCalendarSelectListener != null) {
            this.mDelegate.mCalendarSelectListener.onCalendarSelect(calendar, true);
        }
    }

    public boolean onLongClick(View v) {
        if (this.mDelegate.mDateLongClickListener == null && this.mDelegate.mCalendarLongClickListener == null) {
            return false;
        }
        if (!this.isClick) {
            return false;
        }
        Calendar calendar = this.getIndex();
        if (calendar == null) {
            return false;
        }
        if (this.onCalendarIntercept(calendar)) {
            this.mDelegate.mCalendarInterceptListener.onCalendarInterceptClick(calendar, true);
            return false;
        }
        if (this.mDelegate.getMonthViewShowMode() == 1 && !calendar.isCurrentMonth()) {
            return false;
        }
        boolean isCalendarInRange = this.isInRange(calendar);
        if (!isCalendarInRange) {
            if (this.mDelegate.mCalendarLongClickListener != null) {
                this.mDelegate.mCalendarLongClickListener.onCalendarLongClickOutOfRange(calendar);
            }
            return true;
        }
        if (this.mDelegate.isPreventLongPressedSelected()) {
            if (this.mDelegate.mDateLongClickListener != null) {
                this.mDelegate.mDateLongClickListener.onDateLongClick(calendar);
            }
            if (this.mDelegate.mCalendarLongClickListener != null) {
                this.mDelegate.mCalendarLongClickListener.onCalendarLongClick(calendar);
            }
            return true;
        }
        this.mCurrentItem = this.mItems.indexOf(calendar);
        if (!calendar.isCurrentMonth() && this.mMonthViewPager != null) {
            int cur = this.mMonthViewPager.getCurrentItem();
            int position = this.mCurrentItem < 7 ? cur - 1 : cur + 1;
            this.mMonthViewPager.setCurrentItem(position);
        }
        if (this.mDelegate.mInnerListener != null) {
            this.mDelegate.mInnerListener.onMonthDateSelected(calendar, true);
        }
        if (this.mParentLayout != null) {
            if (calendar.isCurrentMonth()) {
                this.mParentLayout.updateSelectPosition(this.mItems.indexOf(calendar));
            } else {
                this.mParentLayout.updateSelectWeek(CalendarUtil.getWeekFromDayInMonth(calendar, this.mDelegate.getWeekStart()));
            }
        }
        if (this.mDelegate.mDateSelectedListener != null) {
            this.mDelegate.mDateSelectedListener.onDateSelected(calendar, true);
        }
        if (this.mDelegate.mCalendarSelectListener != null) {
            this.mDelegate.mCalendarSelectListener.onCalendarSelect(calendar, true);
        }
        if (this.mDelegate.mDateLongClickListener != null) {
            this.mDelegate.mDateLongClickListener.onDateLongClick(calendar);
        }
        if (this.mDelegate.mCalendarLongClickListener != null) {
            this.mDelegate.mCalendarLongClickListener.onCalendarLongClick(calendar);
        }
        this.invalidate();
        return true;
    }

    protected Calendar getIndex() {
        int indexY;
        int position;
        int indexX = (int)this.mX / this.mItemWidth;
        if (indexX >= 7) {
            indexX = 6;
        }
        if ((position = (indexY = (int)this.mY / this.mItemHeight) * 7 + indexX) >= 0 && position < this.mItems.size()) {
            return (Calendar)this.mItems.get(position);
        }
        return null;
    }

    void setSelectedCalendar(Calendar calendar) {
        this.mCurrentItem = this.mItems.indexOf(calendar);
    }

    void updateShowMode() {
        if (this.mDelegate.getMonthViewShowMode() == 0) {
            this.mLineCount = 6;
            this.mHeight = this.mItemHeight * this.mLineCount;
        } else {
            this.mHeight = CalendarUtil.getMonthViewHeight(this.mYear, this.mMonth, this.mItemHeight, this.mDelegate.getWeekStart());
        }
        this.invalidate();
    }

    void updateWeekStart() {
        this.initCalendar();
        this.mHeight = this.mDelegate.getMonthViewShowMode() == 0 ? this.mItemHeight * this.mLineCount : CalendarUtil.getMonthViewHeight(this.mYear, this.mMonth, this.mItemHeight, this.mDelegate.getWeekStart());
    }

    void setCurrentDate(int year, int month) {
        this.mYear = year;
        this.mMonth = month;
        this.initCalendar();
        this.mHeight = this.mDelegate.getMonthViewShowMode() == 0 ? this.mItemHeight * this.mLineCount : CalendarUtil.getMonthViewHeight(year, month, this.mItemHeight, this.mDelegate.getWeekStart());
    }

    @SuppressLint(value={"WrongConstant"})
    private void initCalendar() {
        this.mNextDiff = CalendarUtil.getMonthEndDiff(this.mYear, this.mMonth, this.mDelegate.getWeekStart());
        int preDiff = CalendarUtil.getMonthViewStartDiff(this.mYear, this.mMonth, this.mDelegate.getWeekStart());
        int monthDayCount = CalendarUtil.getMonthDaysCount(this.mYear, this.mMonth);
        this.mItems = CalendarUtil.initCalendarForMonthView(this.mYear, this.mMonth, this.mDelegate.getCurrentDay(), this.mDelegate.getWeekStart());
        this.mCurrentItem = this.mItems.contains(this.mDelegate.getCurrentDay()) ? this.mItems.indexOf(this.mDelegate.getCurrentDay()) : this.mItems.indexOf(this.mDelegate.mSelectedCalendar);
        if (this.mCurrentItem > 0 && this.mDelegate.mCalendarInterceptListener != null && this.mDelegate.mCalendarInterceptListener.onCalendarIntercept(this.mDelegate.mSelectedCalendar)) {
            this.mCurrentItem = -1;
        }
        this.mLineCount = this.mDelegate.getMonthViewShowMode() == 0 ? 6 : (preDiff + monthDayCount + this.mNextDiff) / 7;
        if (this.mDelegate.getSchemeType() == 1) {
            this.addSchemesFromList();
        } else {
            this.addSchemesFromMap();
        }
        this.invalidate();
    }

    @Override
    void updateCurrentDate() {
        if (this.mItems == null) {
            return;
        }
        if (this.mItems.contains(this.mDelegate.getCurrentDay())) {
            for (Calendar a : this.mItems) {
                a.setCurrentDay(false);
            }
            int index = this.mItems.indexOf(this.mDelegate.getCurrentDay());
            ((Calendar)this.mItems.get(index)).setCurrentDay(true);
        }
        this.invalidate();
    }

    int getSelectedIndex(Calendar calendar) {
        return this.mItems.indexOf(calendar);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.mLineCount != 0) {
            heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)this.mHeight, (int)0x40000000);
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    @Override
    protected void onPreviewHook() {
    }

    protected void onLoopStart(int x, int y) {
    }

    @Override
    protected void onDestroy() {
    }

    protected abstract boolean onDrawSelected(Canvas var1, Calendar var2, int var3, int var4, boolean var5);

    protected abstract void onDrawScheme(Canvas var1, Calendar var2, int var3, int var4);

    protected abstract void onDrawText(Canvas var1, Calendar var2, int var3, int var4, boolean var5, boolean var6);
}

