/*
 * Decompiled with CFR 0.152.
 */
package com.haibin.calendarview;

import android.annotation.SuppressLint;
import android.content.Context;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import com.haibin.calendarview.BaseView;
import com.haibin.calendarview.Calendar;
import com.haibin.calendarview.CalendarLayout;
import com.haibin.calendarview.CalendarUtil;
import com.haibin.calendarview.CalendarViewDelegate;
import com.haibin.calendarview.DefaultMonthView;
import com.haibin.calendarview.LunarCalendar;
import com.haibin.calendarview.MonthView;
import com.haibin.calendarview.WeekBar;
import com.haibin.calendarview.WeekViewPager;
import java.lang.reflect.Constructor;

public final class MonthViewPager
extends ViewPager {
    private boolean isUpdateMonthView;
    private int mMonthCount;
    private CalendarViewDelegate mDelegate;
    private int mNextViewHeight;
    private int mPreViewHeight;
    private int mCurrentViewHeight;
    CalendarLayout mParentLayout;
    WeekViewPager mWeekPager;
    WeekBar mWeekBar;
    private boolean isUsingScrollToCalendar = false;

    public MonthViewPager(Context context) {
        this(context, null);
    }

    public MonthViewPager(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    void setup(CalendarViewDelegate delegate) {
        this.mDelegate = delegate;
        this.updateMonthViewHeight(this.mDelegate.getCurrentDay().getYear(), this.mDelegate.getCurrentDay().getMonth());
        ViewGroup.LayoutParams params = this.getLayoutParams();
        params.height = this.mCurrentViewHeight;
        this.setLayoutParams(params);
        this.init();
    }

    private void init() {
        this.mMonthCount = 12 * (this.mDelegate.getMaxYear() - this.mDelegate.getMinYear()) - this.mDelegate.getMinYearMonth() + 1 + this.mDelegate.getMaxYearMonth();
        this.setAdapter(new MonthViewPagerAdapter());
        this.addOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
                if (MonthViewPager.this.mDelegate.getMonthViewShowMode() == 0) {
                    return;
                }
                int height = position < MonthViewPager.this.getCurrentItem() ? (int)((float)MonthViewPager.this.mPreViewHeight * (1.0f - positionOffset) + (float)MonthViewPager.this.mCurrentViewHeight * positionOffset) : (int)((float)MonthViewPager.this.mCurrentViewHeight * (1.0f - positionOffset) + (float)MonthViewPager.this.mNextViewHeight * positionOffset);
                ViewGroup.LayoutParams params = MonthViewPager.this.getLayoutParams();
                params.height = height;
                MonthViewPager.this.setLayoutParams(params);
            }

            public void onPageSelected(int position) {
                MonthView view;
                Calendar calendar;
                ((MonthViewPager)MonthViewPager.this).mDelegate.mIndexCalendar = calendar = CalendarUtil.getFirstCalendarFromMonthViewPager(position, MonthViewPager.this.mDelegate);
                if (((MonthViewPager)MonthViewPager.this).mDelegate.mMonthChangeListener != null) {
                    ((MonthViewPager)MonthViewPager.this).mDelegate.mMonthChangeListener.onMonthChange(calendar.getYear(), calendar.getMonth());
                }
                if (MonthViewPager.this.mWeekPager.getVisibility() == 0) {
                    MonthViewPager.this.updateMonthViewHeight(calendar.getYear(), calendar.getMonth());
                    return;
                }
                if (MonthViewPager.this.mDelegate.getSelectMode() == 0) {
                    ((MonthViewPager)MonthViewPager.this).mDelegate.mSelectedCalendar = !calendar.isCurrentMonth() ? calendar : CalendarUtil.getRangeEdgeCalendar(calendar, MonthViewPager.this.mDelegate);
                    ((MonthViewPager)MonthViewPager.this).mDelegate.mIndexCalendar = ((MonthViewPager)MonthViewPager.this).mDelegate.mSelectedCalendar;
                } else if (calendar.isSameMonth(((MonthViewPager)MonthViewPager.this).mDelegate.mSelectedCalendar)) {
                    ((MonthViewPager)MonthViewPager.this).mDelegate.mIndexCalendar = ((MonthViewPager)MonthViewPager.this).mDelegate.mSelectedCalendar;
                }
                MonthViewPager.this.mDelegate.updateSelectCalendarScheme();
                if (!MonthViewPager.this.isUsingScrollToCalendar && MonthViewPager.this.mDelegate.getSelectMode() != 1) {
                    MonthViewPager.this.mWeekBar.onDateSelected(((MonthViewPager)MonthViewPager.this).mDelegate.mSelectedCalendar, MonthViewPager.this.mDelegate.getWeekStart(), false);
                    if (((MonthViewPager)MonthViewPager.this).mDelegate.mDateSelectedListener != null) {
                        ((MonthViewPager)MonthViewPager.this).mDelegate.mDateSelectedListener.onDateSelected(((MonthViewPager)MonthViewPager.this).mDelegate.mSelectedCalendar, false);
                    }
                    if (((MonthViewPager)MonthViewPager.this).mDelegate.mCalendarSelectListener != null) {
                        ((MonthViewPager)MonthViewPager.this).mDelegate.mCalendarSelectListener.onCalendarSelect(((MonthViewPager)MonthViewPager.this).mDelegate.mSelectedCalendar, false);
                    }
                }
                if ((view = (MonthView)MonthViewPager.this.findViewWithTag(position)) != null) {
                    int index = view.getSelectedIndex(((MonthViewPager)MonthViewPager.this).mDelegate.mIndexCalendar);
                    if (MonthViewPager.this.mDelegate.getSelectMode() != 1) {
                        view.mCurrentItem = index;
                    }
                    if (index >= 0 && MonthViewPager.this.mParentLayout != null) {
                        MonthViewPager.this.mParentLayout.updateSelectPosition(index);
                    }
                    view.invalidate();
                }
                MonthViewPager.this.mWeekPager.updateSelected(((MonthViewPager)MonthViewPager.this).mDelegate.mIndexCalendar, false);
                MonthViewPager.this.updateMonthViewHeight(calendar.getYear(), calendar.getMonth());
                MonthViewPager.this.isUsingScrollToCalendar = false;
            }

            public void onPageScrollStateChanged(int state) {
            }
        });
    }

    private void updateMonthViewHeight(int year, int month) {
        if (this.mDelegate.getMonthViewShowMode() == 0) {
            this.mCurrentViewHeight = 6 * this.mDelegate.getCalendarItemHeight();
            return;
        }
        if (this.mParentLayout != null) {
            if (this.getVisibility() != 0) {
                ViewGroup.LayoutParams params = this.getLayoutParams();
                params.height = CalendarUtil.getMonthViewHeight(year, month, this.mDelegate.getCalendarItemHeight(), this.mDelegate.getWeekStart());
                this.setLayoutParams(params);
            }
            this.mParentLayout.updateContentViewTranslateY();
        }
        this.mCurrentViewHeight = CalendarUtil.getMonthViewHeight(year, month, this.mDelegate.getCalendarItemHeight(), this.mDelegate.getWeekStart());
        if (month == 1) {
            this.mPreViewHeight = CalendarUtil.getMonthViewHeight(year - 1, 12, this.mDelegate.getCalendarItemHeight(), this.mDelegate.getWeekStart());
            this.mNextViewHeight = CalendarUtil.getMonthViewHeight(year, 2, this.mDelegate.getCalendarItemHeight(), this.mDelegate.getWeekStart());
        } else {
            this.mPreViewHeight = CalendarUtil.getMonthViewHeight(year, month - 1, this.mDelegate.getCalendarItemHeight(), this.mDelegate.getWeekStart());
            this.mNextViewHeight = month == 12 ? CalendarUtil.getMonthViewHeight(year + 1, 1, this.mDelegate.getCalendarItemHeight(), this.mDelegate.getWeekStart()) : CalendarUtil.getMonthViewHeight(year, month + 1, this.mDelegate.getCalendarItemHeight(), this.mDelegate.getWeekStart());
        }
    }

    void notifyDataSetChanged() {
        this.mMonthCount = 12 * (this.mDelegate.getMaxYear() - this.mDelegate.getMinYear()) - this.mDelegate.getMinYearMonth() + 1 + this.mDelegate.getMaxYearMonth();
        this.getAdapter().notifyDataSetChanged();
    }

    void updateMonthViewClass() {
        this.isUpdateMonthView = true;
        this.getAdapter().notifyDataSetChanged();
        this.isUpdateMonthView = false;
    }

    void updateRange() {
        this.isUpdateMonthView = true;
        this.notifyDataSetChanged();
        this.isUpdateMonthView = false;
        if (this.getVisibility() != 0) {
            return;
        }
        this.isUsingScrollToCalendar = true;
        Calendar calendar = this.mDelegate.mSelectedCalendar;
        int y = calendar.getYear() - this.mDelegate.getMinYear();
        int position = 12 * y + calendar.getMonth() - this.mDelegate.getMinYearMonth();
        this.setCurrentItem(position, false);
        MonthView view = (MonthView)this.findViewWithTag(position);
        if (view != null) {
            view.setSelectedCalendar(this.mDelegate.mIndexCalendar);
            view.invalidate();
            if (this.mParentLayout != null) {
                this.mParentLayout.updateSelectPosition(view.getSelectedIndex(this.mDelegate.mIndexCalendar));
            }
        }
        if (this.mParentLayout != null) {
            int week = CalendarUtil.getWeekFromDayInMonth(calendar, this.mDelegate.getWeekStart());
            this.mParentLayout.updateSelectWeek(week);
        }
        if (this.mDelegate.mInnerListener != null) {
            this.mDelegate.mInnerListener.onMonthDateSelected(calendar, false);
        }
        if (this.mDelegate.mDateSelectedListener != null) {
            this.mDelegate.mDateSelectedListener.onDateSelected(calendar, false);
        }
        if (this.mDelegate.mCalendarSelectListener != null) {
            this.mDelegate.mCalendarSelectListener.onCalendarSelect(calendar, false);
        }
        this.updateSelected();
    }

    void scrollToCalendar(int year, int month, int day, boolean smoothScroll) {
        this.isUsingScrollToCalendar = true;
        Calendar calendar = new Calendar();
        calendar.setYear(year);
        calendar.setMonth(month);
        calendar.setDay(day);
        calendar.setCurrentDay(calendar.equals(this.mDelegate.getCurrentDay()));
        LunarCalendar.setupLunarCalendar(calendar);
        this.mDelegate.mIndexCalendar = calendar;
        this.mDelegate.mSelectedCalendar = calendar;
        this.mDelegate.updateSelectCalendarScheme();
        int y = calendar.getYear() - this.mDelegate.getMinYear();
        int position = 12 * y + calendar.getMonth() - this.mDelegate.getMinYearMonth();
        int curItem = this.getCurrentItem();
        if (curItem == position) {
            this.isUsingScrollToCalendar = false;
        }
        this.setCurrentItem(position, smoothScroll);
        MonthView view = (MonthView)this.findViewWithTag(position);
        if (view != null) {
            view.setSelectedCalendar(this.mDelegate.mIndexCalendar);
            view.invalidate();
            if (this.mParentLayout != null) {
                this.mParentLayout.updateSelectPosition(view.getSelectedIndex(this.mDelegate.mIndexCalendar));
            }
        }
        if (this.mParentLayout != null) {
            int week = CalendarUtil.getWeekFromDayInMonth(calendar, this.mDelegate.getWeekStart());
            this.mParentLayout.updateSelectWeek(week);
        }
        if (this.mDelegate.mInnerListener != null) {
            this.mDelegate.mInnerListener.onMonthDateSelected(calendar, false);
        }
        if (this.mDelegate.mDateSelectedListener != null) {
            this.mDelegate.mDateSelectedListener.onDateSelected(calendar, false);
        }
        this.updateSelected();
    }

    void scrollToCurrent(boolean smoothScroll) {
        this.isUsingScrollToCalendar = true;
        int position = 12 * (this.mDelegate.getCurrentDay().getYear() - this.mDelegate.getMinYear()) + this.mDelegate.getCurrentDay().getMonth() - this.mDelegate.getMinYearMonth();
        int curItem = this.getCurrentItem();
        if (curItem == position) {
            this.isUsingScrollToCalendar = false;
        }
        this.setCurrentItem(position, smoothScroll);
        MonthView view = (MonthView)this.findViewWithTag(position);
        if (view != null) {
            view.setSelectedCalendar(this.mDelegate.getCurrentDay());
            view.invalidate();
            if (this.mParentLayout != null) {
                this.mParentLayout.updateSelectPosition(view.getSelectedIndex(this.mDelegate.getCurrentDay()));
            }
        }
        if (this.mDelegate.mDateSelectedListener != null && this.getVisibility() == 0) {
            this.mDelegate.mDateSelectedListener.onDateSelected(this.mDelegate.mSelectedCalendar, false);
        }
        if (this.mDelegate.mCalendarSelectListener != null && this.getVisibility() == 0) {
            this.mDelegate.mCalendarSelectListener.onCalendarSelect(this.mDelegate.mSelectedCalendar, false);
        }
    }

    void updateDefaultSelect() {
        MonthView view = (MonthView)this.findViewWithTag(this.getCurrentItem());
        if (view != null) {
            int index;
            view.mCurrentItem = index = view.getSelectedIndex(this.mDelegate.mSelectedCalendar);
            if (index >= 0 && this.mParentLayout != null) {
                this.mParentLayout.updateSelectPosition(index);
            }
            view.invalidate();
        }
    }

    void updateSelected() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            MonthView view = (MonthView)this.getChildAt(i);
            view.setSelectedCalendar(this.mDelegate.mSelectedCalendar);
            view.invalidate();
        }
    }

    void updateScheme() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            MonthView view = (MonthView)this.getChildAt(i);
            view.update();
        }
    }

    void updateCurrentDate() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            MonthView view = (MonthView)this.getChildAt(i);
            view.updateCurrentDate();
        }
    }

    void updateShowMode() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            MonthView view = (MonthView)this.getChildAt(i);
            view.updateShowMode();
            view.requestLayout();
        }
        if (this.mDelegate.getMonthViewShowMode() == 0) {
            this.mNextViewHeight = this.mCurrentViewHeight = 6 * this.mDelegate.getCalendarItemHeight();
            this.mPreViewHeight = this.mCurrentViewHeight;
        } else {
            this.updateMonthViewHeight(this.mDelegate.mSelectedCalendar.getYear(), this.mDelegate.mSelectedCalendar.getMonth());
        }
        ViewGroup.LayoutParams params = this.getLayoutParams();
        params.height = this.mCurrentViewHeight;
        this.setLayoutParams(params);
        if (this.mParentLayout != null) {
            this.mParentLayout.updateContentViewTranslateY();
        }
    }

    void updateWeekStart() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            MonthView view = (MonthView)this.getChildAt(i);
            view.updateWeekStart();
            view.requestLayout();
        }
        this.updateMonthViewHeight(this.mDelegate.mSelectedCalendar.getYear(), this.mDelegate.mSelectedCalendar.getMonth());
        ViewGroup.LayoutParams params = this.getLayoutParams();
        params.height = this.mCurrentViewHeight;
        this.setLayoutParams(params);
        if (this.mParentLayout != null) {
            int i = CalendarUtil.getWeekFromDayInMonth(this.mDelegate.mSelectedCalendar, this.mDelegate.getWeekStart());
            this.mParentLayout.updateSelectWeek(i);
        }
        this.updateSelected();
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(MotionEvent ev) {
        return this.mDelegate.isMonthViewScrollable() && super.onTouchEvent(ev);
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        return this.mDelegate.isMonthViewScrollable() && super.onInterceptTouchEvent(ev);
    }

    public void setCurrentItem(int item) {
        this.setCurrentItem(item, true);
    }

    public void setCurrentItem(int item, boolean smoothScroll) {
        if (Math.abs(this.getCurrentItem() - item) > 1) {
            super.setCurrentItem(item, false);
        } else {
            super.setCurrentItem(item, smoothScroll);
        }
    }

    private final class MonthViewPagerAdapter
    extends PagerAdapter {
        private MonthViewPagerAdapter() {
        }

        public int getCount() {
            return MonthViewPager.this.mMonthCount;
        }

        public int getItemPosition(Object object) {
            return MonthViewPager.this.isUpdateMonthView ? -2 : super.getItemPosition(object);
        }

        public boolean isViewFromObject(View view, Object object) {
            return view.equals(object);
        }

        public Object instantiateItem(ViewGroup container, int position) {
            MonthView view;
            int year = (position + MonthViewPager.this.mDelegate.getMinYearMonth() - 1) / 12 + MonthViewPager.this.mDelegate.getMinYear();
            int month = (position + MonthViewPager.this.mDelegate.getMinYearMonth() - 1) % 12 + 1;
            if (TextUtils.isEmpty((CharSequence)MonthViewPager.this.mDelegate.getMonthViewClass())) {
                view = new DefaultMonthView(MonthViewPager.this.getContext());
            } else {
                try {
                    Class<?> cls = Class.forName(MonthViewPager.this.mDelegate.getMonthViewClass());
                    Constructor<?> constructor = cls.getConstructor(Context.class);
                    view = (MonthView)((Object)constructor.newInstance(MonthViewPager.this.getContext()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
            view.mParentLayout = MonthViewPager.this.mParentLayout;
            view.mMonthViewPager = MonthViewPager.this;
            view.setup(MonthViewPager.this.mDelegate);
            view.setTag(position);
            view.setCurrentDate(year, month);
            view.setSelectedCalendar(((MonthViewPager)MonthViewPager.this).mDelegate.mSelectedCalendar);
            container.addView((View)view);
            return view;
        }

        public void destroyItem(ViewGroup container, int position, Object object) {
            BaseView view = (BaseView)((Object)object);
            view.onDestroy();
            container.removeView((View)view);
        }
    }
}

