/*
 * Decompiled with CFR 0.152.
 */
package com.haibin.calendarview;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.haibin.calendarview.Calendar;
import com.haibin.calendarview.CalendarUtil;
import com.haibin.calendarview.CalendarViewDelegate;
import com.haibin.calendarview.R;

public class WeekBar
extends LinearLayout {
    private CalendarViewDelegate mDelegate;

    public WeekBar(Context context) {
        super(context);
        if ("com.haibin.calendarview.WeekBar".equals(((Object)((Object)this)).getClass().getName())) {
            LayoutInflater.from((Context)context).inflate(R.layout.cv_week_bar, (ViewGroup)this, true);
        }
    }

    void setup(CalendarViewDelegate delegate) {
        this.mDelegate = delegate;
        if ("com.haibin.calendarview.WeekBar".equalsIgnoreCase(((Object)((Object)this)).getClass().getName())) {
            this.setTextSize(this.mDelegate.getWeekTextSize());
            this.setTextColor(delegate.getWeekTextColor());
            this.setBackgroundColor(delegate.getWeekBackground());
            this.setPadding(delegate.getCalendarPadding(), 0, delegate.getCalendarPadding(), 0);
        }
    }

    protected void setTextColor(int color) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            ((TextView)this.getChildAt(i)).setTextColor(color);
        }
    }

    protected void setTextSize(int size) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            ((TextView)this.getChildAt(i)).setTextSize(0, (float)size);
        }
    }

    protected void onDateSelected(Calendar calendar, int weekStart, boolean isClick) {
    }

    protected void onWeekStartChange(int weekStart) {
        if (!"com.haibin.calendarview.WeekBar".equalsIgnoreCase(((Object)((Object)this)).getClass().getName())) {
            return;
        }
        for (int i = 0; i < this.getChildCount(); ++i) {
            ((TextView)this.getChildAt(i)).setText((CharSequence)this.getWeekString(i, weekStart));
        }
    }

    protected int getViewIndexByCalendar(Calendar calendar, int weekStart) {
        int week = calendar.getWeek() + 1;
        if (weekStart == 1) {
            return week - 1;
        }
        if (weekStart == 2) {
            return week == 1 ? 6 : week - 2;
        }
        return week == 7 ? 0 : week;
    }

    private String getWeekString(int index, int weekStart) {
        String[] weeks = this.getContext().getResources().getStringArray(R.array.week_string_array);
        if (weekStart == 1) {
            return weeks[index];
        }
        if (weekStart == 2) {
            return weeks[index == 6 ? 0 : index + 1];
        }
        return weeks[index == 0 ? 6 : index - 1];
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        heightMeasureSpec = this.mDelegate != null ? View.MeasureSpec.makeMeasureSpec((int)this.mDelegate.getWeekBarHeight(), (int)0x40000000) : View.MeasureSpec.makeMeasureSpec((int)CalendarUtil.dipToPx(this.getContext(), 40.0f), (int)0x40000000);
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }
}

