/*
 * Decompiled with CFR 0.152.
 */
package com.haibin.calendarview;

import android.content.Context;
import android.graphics.Canvas;
import android.view.View;
import com.haibin.calendarview.BaseView;
import com.haibin.calendarview.Calendar;
import com.haibin.calendarview.CalendarUtil;

public abstract class WeekView
extends BaseView {
    public WeekView(Context context) {
        super(context);
    }

    protected void onDraw(Canvas canvas) {
        if (this.mItems.size() == 0) {
            return;
        }
        this.mItemWidth = (this.getWidth() - 2 * this.mDelegate.getCalendarPadding()) / 7;
        this.onPreviewHook();
        for (int i = 0; i < 7; ++i) {
            int x = i * this.mItemWidth + this.mDelegate.getCalendarPadding();
            this.onLoopStart(x);
            Calendar calendar = (Calendar)this.mItems.get(i);
            boolean isSelected = i == this.mCurrentItem;
            boolean hasScheme = calendar.hasScheme();
            if (hasScheme) {
                boolean isDrawSelected = false;
                if (isSelected) {
                    isDrawSelected = this.onDrawSelected(canvas, calendar, x, true);
                }
                if (isDrawSelected || !isSelected) {
                    this.mSchemePaint.setColor(calendar.getSchemeColor() != 0 ? calendar.getSchemeColor() : this.mDelegate.getSchemeThemeColor());
                    this.onDrawScheme(canvas, calendar, x);
                }
            } else if (isSelected) {
                this.onDrawSelected(canvas, calendar, x, false);
            }
            this.onDrawText(canvas, calendar, x, hasScheme, isSelected);
        }
    }

    public void onClick(View v) {
        if (!this.isClick) {
            return;
        }
        Calendar calendar = this.getIndex();
        if (calendar == null) {
            return;
        }
        if (this.onCalendarIntercept(calendar)) {
            this.mDelegate.mCalendarInterceptListener.onCalendarInterceptClick(calendar, true);
            return;
        }
        if (!this.isInRange(calendar)) {
            if (this.mDelegate.mCalendarSelectListener != null) {
                this.mDelegate.mCalendarSelectListener.onCalendarOutOfRange(calendar);
            }
            return;
        }
        this.mCurrentItem = this.mItems.indexOf(calendar);
        if (this.mDelegate.mInnerListener != null) {
            this.mDelegate.mInnerListener.onWeekDateSelected(calendar, true);
        }
        if (this.mParentLayout != null) {
            int i = CalendarUtil.getWeekFromDayInMonth(calendar, this.mDelegate.getWeekStart());
            this.mParentLayout.updateSelectWeek(i);
        }
        if (this.mDelegate.mDateSelectedListener != null) {
            this.mDelegate.mDateSelectedListener.onDateSelected(calendar, true);
        }
        if (this.mDelegate.mCalendarSelectListener != null) {
            this.mDelegate.mCalendarSelectListener.onCalendarSelect(calendar, true);
        }
        this.invalidate();
    }

    public boolean onLongClick(View v) {
        if (this.mDelegate.mDateLongClickListener == null && this.mDelegate.mCalendarLongClickListener == null) {
            return false;
        }
        if (!this.isClick) {
            return false;
        }
        Calendar calendar = this.getIndex();
        if (calendar == null) {
            return false;
        }
        if (this.onCalendarIntercept(calendar)) {
            this.mDelegate.mCalendarInterceptListener.onCalendarInterceptClick(calendar, true);
            return true;
        }
        boolean isCalendarInRange = this.isInRange(calendar);
        if (!isCalendarInRange) {
            if (this.mDelegate.mCalendarLongClickListener != null) {
                this.mDelegate.mCalendarLongClickListener.onCalendarLongClickOutOfRange(calendar);
            }
            return true;
        }
        if (this.mDelegate.isPreventLongPressedSelected()) {
            if (this.mDelegate.mDateLongClickListener != null) {
                this.mDelegate.mDateLongClickListener.onDateLongClick(calendar);
            }
            if (this.mDelegate.mCalendarLongClickListener != null) {
                this.mDelegate.mCalendarLongClickListener.onCalendarLongClick(calendar);
            }
            return true;
        }
        this.mCurrentItem = this.mItems.indexOf(calendar);
        this.mDelegate.mIndexCalendar = this.mDelegate.mSelectedCalendar;
        if (this.mDelegate.mInnerListener != null) {
            this.mDelegate.mInnerListener.onWeekDateSelected(calendar, true);
        }
        if (this.mParentLayout != null) {
            int i = CalendarUtil.getWeekFromDayInMonth(calendar, this.mDelegate.getWeekStart());
            this.mParentLayout.updateSelectWeek(i);
        }
        if (this.mDelegate.mDateSelectedListener != null) {
            this.mDelegate.mDateSelectedListener.onDateSelected(calendar, true);
        }
        if (this.mDelegate.mCalendarSelectListener != null) {
            this.mDelegate.mCalendarSelectListener.onCalendarSelect(calendar, true);
        }
        if (this.mDelegate.mDateLongClickListener != null) {
            this.mDelegate.mDateLongClickListener.onDateLongClick(calendar);
        }
        if (this.mDelegate.mCalendarLongClickListener != null) {
            this.mDelegate.mCalendarLongClickListener.onCalendarLongClick(calendar);
        }
        this.invalidate();
        return true;
    }

    void performClickCalendar(Calendar calendar, boolean isNotice) {
        if (this.mParentLayout == null || this.mDelegate.mInnerListener == null || this.mItems == null || this.mItems.size() == 0) {
            return;
        }
        int week = CalendarUtil.getWeekViewIndexFromCalendar(calendar, this.mDelegate.getWeekStart());
        if (this.mItems.contains(this.mDelegate.getCurrentDay())) {
            week = CalendarUtil.getWeekViewIndexFromCalendar(this.mDelegate.getCurrentDay(), this.mDelegate.getWeekStart());
        }
        int curIndex = week;
        Calendar currentCalendar = (Calendar)this.mItems.get(week);
        if (this.mDelegate.getSelectMode() == 1) {
            if (this.mItems.contains(this.mDelegate.mSelectedCalendar)) {
                currentCalendar = this.mDelegate.mSelectedCalendar;
            } else {
                this.mCurrentItem = -1;
            }
        }
        if (!this.isInRange(currentCalendar)) {
            curIndex = this.getEdgeIndex(this.isMinRangeEdge(currentCalendar));
            currentCalendar = (Calendar)this.mItems.get(curIndex);
        }
        currentCalendar.setCurrentDay(currentCalendar.equals(this.mDelegate.getCurrentDay()));
        this.mDelegate.mInnerListener.onWeekDateSelected(currentCalendar, false);
        int i = CalendarUtil.getWeekFromDayInMonth(currentCalendar, this.mDelegate.getWeekStart());
        this.mParentLayout.updateSelectWeek(i);
        if (this.mDelegate.mDateSelectedListener != null && isNotice && this.mDelegate.getSelectMode() == 0) {
            this.mDelegate.mDateSelectedListener.onDateSelected(currentCalendar, false);
        }
        if (this.mDelegate.mCalendarSelectListener != null && isNotice && this.mDelegate.getSelectMode() == 0) {
            this.mDelegate.mCalendarSelectListener.onCalendarSelect(currentCalendar, false);
        }
        this.mParentLayout.updateContentViewTranslateY();
        if (this.mDelegate.getSelectMode() == 0) {
            this.mCurrentItem = curIndex;
        }
        this.mDelegate.mIndexCalendar = currentCalendar;
        this.invalidate();
    }

    private boolean isMinRangeEdge(Calendar calendar) {
        java.util.Calendar c = java.util.Calendar.getInstance();
        c.set(this.mDelegate.getMinYear(), this.mDelegate.getMinYearMonth() - 1, this.mDelegate.getMinYearDay());
        long minTime = c.getTimeInMillis();
        c.set(calendar.getYear(), calendar.getMonth() - 1, calendar.getDay());
        long curTime = c.getTimeInMillis();
        return curTime < minTime;
    }

    private int getEdgeIndex(boolean isMinEdge) {
        for (int i = 0; i < this.mItems.size(); ++i) {
            Calendar item = (Calendar)this.mItems.get(i);
            boolean isInRange = this.isInRange(item);
            if (isMinEdge && isInRange) {
                return i;
            }
            if (isMinEdge || isInRange) continue;
            return i - 1;
        }
        return isMinEdge ? 6 : 0;
    }

    protected Calendar getIndex() {
        int indexY;
        int position;
        int indexX = (int)this.mX / this.mItemWidth;
        if (indexX >= 7) {
            indexX = 6;
        }
        if ((position = (indexY = (int)this.mY / this.mItemHeight) * 7 + indexX) >= 0 && position < this.mItems.size()) {
            return (Calendar)this.mItems.get(position);
        }
        return null;
    }

    void setSelectedCalendar(Calendar calendar) {
        if (this.mDelegate.getSelectMode() == 1 && !calendar.equals(this.mDelegate.mSelectedCalendar)) {
            return;
        }
        this.mCurrentItem = this.mItems.indexOf(calendar);
    }

    void setup(Calendar calendar) {
        this.mItems = CalendarUtil.initCalendarForWeekView(calendar, this.mDelegate, this.mDelegate.getWeekStart());
        if (this.mDelegate.getSchemeType() == 1) {
            this.addSchemesFromList();
        } else {
            this.addSchemesFromMap();
        }
        this.invalidate();
    }

    void updateShowMode() {
        this.invalidate();
    }

    void updateWeekStart() {
        int position = (Integer)this.getTag();
        Calendar calendar = CalendarUtil.getFirstCalendarStartWithMinCalendar(this.mDelegate.getMinYear(), this.mDelegate.getMinYearMonth(), this.mDelegate.getMinYearDay(), position + 1, this.mDelegate.getWeekStart());
        this.setSelectedCalendar(this.mDelegate.mSelectedCalendar);
        this.setup(calendar);
    }

    void updateSingleSelect() {
        if (!this.mItems.contains(this.mDelegate.mSelectedCalendar)) {
            this.mCurrentItem = -1;
            this.invalidate();
        }
    }

    @Override
    void updateCurrentDate() {
        if (this.mItems == null) {
            return;
        }
        if (this.mItems.contains(this.mDelegate.getCurrentDay())) {
            for (Calendar a : this.mItems) {
                a.setCurrentDay(false);
            }
            int index = this.mItems.indexOf(this.mDelegate.getCurrentDay());
            ((Calendar)this.mItems.get(index)).setCurrentDay(true);
        }
        this.invalidate();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)this.mItemHeight, (int)0x40000000);
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    @Override
    protected void onPreviewHook() {
    }

    protected void onLoopStart(int x) {
    }

    @Override
    protected void onDestroy() {
    }

    protected abstract boolean onDrawSelected(Canvas var1, Calendar var2, int var3, boolean var4);

    protected abstract void onDrawScheme(Canvas var1, Calendar var2, int var3);

    protected abstract void onDrawText(Canvas var1, Calendar var2, int var3, boolean var4, boolean var5);
}

