/*
 * Decompiled with CFR 0.152.
 */
package com.haibin.calendarview;

import android.annotation.SuppressLint;
import android.content.Context;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import com.haibin.calendarview.BaseView;
import com.haibin.calendarview.Calendar;
import com.haibin.calendarview.CalendarLayout;
import com.haibin.calendarview.CalendarUtil;
import com.haibin.calendarview.CalendarViewDelegate;
import com.haibin.calendarview.DefaultWeekView;
import com.haibin.calendarview.LunarCalendar;
import com.haibin.calendarview.WeekView;
import java.lang.reflect.Constructor;
import java.util.List;

public final class WeekViewPager
extends ViewPager {
    private boolean isUpdateWeekView;
    private int mWeekCount;
    private CalendarViewDelegate mDelegate;
    CalendarLayout mParentLayout;
    private boolean isUsingScrollToCalendar = false;

    public WeekViewPager(Context context) {
        this(context, null);
    }

    public WeekViewPager(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    void setup(CalendarViewDelegate delegate) {
        this.mDelegate = delegate;
        this.init();
    }

    private void init() {
        this.mWeekCount = CalendarUtil.getWeekCountBetweenBothCalendar(this.mDelegate.getMinYear(), this.mDelegate.getMinYearMonth(), this.mDelegate.getMinYearDay(), this.mDelegate.getMaxYear(), this.mDelegate.getMaxYearMonth(), this.mDelegate.getMaxYearDay(), this.mDelegate.getWeekStart());
        this.setAdapter(new WeekViewPagerAdapter());
        this.addOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            }

            public void onPageSelected(int position) {
                if (WeekViewPager.this.getVisibility() != 0) {
                    WeekViewPager.this.isUsingScrollToCalendar = false;
                    return;
                }
                if (WeekViewPager.this.isUsingScrollToCalendar) {
                    WeekViewPager.this.isUsingScrollToCalendar = false;
                    return;
                }
                WeekView view = (WeekView)WeekViewPager.this.findViewWithTag(position);
                if (view != null) {
                    view.performClickCalendar(WeekViewPager.this.mDelegate.getSelectMode() == 1 ? ((WeekViewPager)WeekViewPager.this).mDelegate.mIndexCalendar : ((WeekViewPager)WeekViewPager.this).mDelegate.mSelectedCalendar, !WeekViewPager.this.isUsingScrollToCalendar);
                    if (((WeekViewPager)WeekViewPager.this).mDelegate.mWeekChangeListener != null) {
                        ((WeekViewPager)WeekViewPager.this).mDelegate.mWeekChangeListener.onWeekChange(WeekViewPager.this.getCurrentWeekCalendars());
                    }
                }
                WeekViewPager.this.isUsingScrollToCalendar = false;
            }

            public void onPageScrollStateChanged(int state) {
            }
        });
    }

    List<Calendar> getCurrentWeekCalendars() {
        List<Calendar> calendars = CalendarUtil.getWeekCalendars(this.mDelegate.mIndexCalendar, this.mDelegate);
        if (this.mDelegate.getSchemeType() == 1) {
            this.mDelegate.addSchemesFromList(calendars);
        } else {
            this.mDelegate.addSchemesFromMap(calendars);
        }
        return calendars;
    }

    void notifyDataSetChanged() {
        this.mWeekCount = CalendarUtil.getWeekCountBetweenBothCalendar(this.mDelegate.getMinYear(), this.mDelegate.getMinYearMonth(), this.mDelegate.getMinYearDay(), this.mDelegate.getMaxYear(), this.mDelegate.getMaxYearMonth(), this.mDelegate.getMaxYearDay(), this.mDelegate.getWeekStart());
        this.getAdapter().notifyDataSetChanged();
    }

    void updateWeekViewClass() {
        this.isUpdateWeekView = true;
        this.getAdapter().notifyDataSetChanged();
        this.isUpdateWeekView = false;
    }

    void updateRange() {
        this.isUpdateWeekView = true;
        this.notifyDataSetChanged();
        this.isUpdateWeekView = false;
        if (this.getVisibility() != 0) {
            return;
        }
        this.isUsingScrollToCalendar = true;
        Calendar calendar = this.mDelegate.mSelectedCalendar;
        this.updateSelected(calendar, false);
        if (this.mDelegate.mInnerListener != null) {
            this.mDelegate.mInnerListener.onWeekDateSelected(calendar, false);
        }
        if (this.mDelegate.mDateSelectedListener != null) {
            this.mDelegate.mDateSelectedListener.onDateSelected(calendar, false);
        }
        if (this.mDelegate.mCalendarSelectListener != null) {
            this.mDelegate.mCalendarSelectListener.onCalendarSelect(calendar, false);
        }
        int i = CalendarUtil.getWeekFromDayInMonth(calendar, this.mDelegate.getWeekStart());
        this.mParentLayout.updateSelectWeek(i);
    }

    void scrollToCalendar(int year, int month, int day, boolean smoothScroll) {
        this.isUsingScrollToCalendar = true;
        Calendar calendar = new Calendar();
        calendar.setYear(year);
        calendar.setMonth(month);
        calendar.setDay(day);
        calendar.setCurrentDay(calendar.equals(this.mDelegate.getCurrentDay()));
        LunarCalendar.setupLunarCalendar(calendar);
        this.mDelegate.mIndexCalendar = calendar;
        this.mDelegate.mSelectedCalendar = calendar;
        this.mDelegate.updateSelectCalendarScheme();
        this.updateSelected(calendar, smoothScroll);
        if (this.mDelegate.mInnerListener != null) {
            this.mDelegate.mInnerListener.onWeekDateSelected(calendar, false);
        }
        if (this.mDelegate.mDateSelectedListener != null) {
            this.mDelegate.mDateSelectedListener.onDateSelected(calendar, false);
        }
        if (this.mDelegate.mCalendarSelectListener != null) {
            this.mDelegate.mCalendarSelectListener.onCalendarSelect(calendar, false);
        }
        int i = CalendarUtil.getWeekFromDayInMonth(calendar, this.mDelegate.getWeekStart());
        this.mParentLayout.updateSelectWeek(i);
    }

    void scrollToCurrent(boolean smoothScroll) {
        this.isUsingScrollToCalendar = true;
        int position = CalendarUtil.getWeekFromCalendarStartWithMinCalendar(this.mDelegate.getCurrentDay(), this.mDelegate.getMinYear(), this.mDelegate.getMinYearMonth(), this.mDelegate.getMaxYearDay(), this.mDelegate.getWeekStart()) - 1;
        int curItem = this.getCurrentItem();
        if (curItem == position) {
            this.isUsingScrollToCalendar = false;
        }
        this.setCurrentItem(position, smoothScroll);
        WeekView view = (WeekView)this.findViewWithTag(position);
        if (view != null) {
            view.performClickCalendar(this.mDelegate.getCurrentDay(), false);
            view.setSelectedCalendar(this.mDelegate.getCurrentDay());
            view.invalidate();
        }
        if (this.mDelegate.mDateSelectedListener != null && this.getVisibility() == 0) {
            this.mDelegate.mDateSelectedListener.onDateSelected(this.mDelegate.mSelectedCalendar, false);
        }
        if (this.mDelegate.mCalendarSelectListener != null && this.getVisibility() == 0) {
            this.mDelegate.mCalendarSelectListener.onCalendarSelect(this.mDelegate.mSelectedCalendar, false);
        }
        if (this.getVisibility() == 0) {
            this.mDelegate.mInnerListener.onWeekDateSelected(this.mDelegate.getCurrentDay(), false);
        }
        int i = CalendarUtil.getWeekFromDayInMonth(this.mDelegate.getCurrentDay(), this.mDelegate.getWeekStart());
        this.mParentLayout.updateSelectWeek(i);
    }

    void updateSelected(Calendar calendar, boolean smoothScroll) {
        int position = CalendarUtil.getWeekFromCalendarStartWithMinCalendar(calendar, this.mDelegate.getMinYear(), this.mDelegate.getMinYearMonth(), this.mDelegate.getMinYearDay(), this.mDelegate.getWeekStart()) - 1;
        int curItem = this.getCurrentItem();
        this.isUsingScrollToCalendar = curItem != position;
        this.setCurrentItem(position, smoothScroll);
        WeekView view = (WeekView)this.findViewWithTag(position);
        if (view != null) {
            view.setSelectedCalendar(calendar);
            view.invalidate();
        }
    }

    void updateSingleSelect() {
        if (this.mDelegate.getSelectMode() == 0) {
            return;
        }
        for (int i = 0; i < this.getChildCount(); ++i) {
            WeekView view = (WeekView)this.getChildAt(i);
            view.updateSingleSelect();
        }
    }

    void updateDefaultSelect() {
        WeekView view = (WeekView)this.findViewWithTag(this.getCurrentItem());
        if (view != null) {
            view.setSelectedCalendar(this.mDelegate.mSelectedCalendar);
            view.invalidate();
        }
    }

    void updateSelected() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            WeekView view = (WeekView)this.getChildAt(i);
            view.setSelectedCalendar(this.mDelegate.mSelectedCalendar);
            view.invalidate();
        }
    }

    void updateScheme() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            WeekView view = (WeekView)this.getChildAt(i);
            view.update();
        }
    }

    void updateCurrentDate() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            WeekView view = (WeekView)this.getChildAt(i);
            view.updateCurrentDate();
        }
    }

    void updateShowMode() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            WeekView view = (WeekView)this.getChildAt(i);
            view.updateShowMode();
        }
    }

    void updateWeekStart() {
        int count = this.getAdapter().getCount();
        this.mWeekCount = CalendarUtil.getWeekCountBetweenBothCalendar(this.mDelegate.getMinYear(), this.mDelegate.getMinYearMonth(), this.mDelegate.getMinYearDay(), this.mDelegate.getMaxYear(), this.mDelegate.getMaxYearMonth(), this.mDelegate.getMaxYearDay(), this.mDelegate.getWeekStart());
        if (count != this.mWeekCount) {
            this.isUpdateWeekView = true;
            this.getAdapter().notifyDataSetChanged();
        }
        for (int i = 0; i < this.getChildCount(); ++i) {
            WeekView view = (WeekView)this.getChildAt(i);
            view.updateWeekStart();
        }
        this.isUpdateWeekView = false;
        this.updateSelected(this.mDelegate.mSelectedCalendar, false);
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(MotionEvent ev) {
        return this.mDelegate.isWeekViewScrollable() && super.onTouchEvent(ev);
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        return this.mDelegate.isWeekViewScrollable() && super.onInterceptTouchEvent(ev);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)this.mDelegate.getCalendarItemHeight(), (int)0x40000000);
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    private class WeekViewPagerAdapter
    extends PagerAdapter {
        private WeekViewPagerAdapter() {
        }

        public int getCount() {
            return WeekViewPager.this.mWeekCount;
        }

        public int getItemPosition(Object object) {
            return WeekViewPager.this.isUpdateWeekView ? -2 : super.getItemPosition(object);
        }

        public boolean isViewFromObject(View view, Object object) {
            return view.equals(object);
        }

        public Object instantiateItem(ViewGroup container, int position) {
            WeekView view;
            Calendar calendar = CalendarUtil.getFirstCalendarStartWithMinCalendar(WeekViewPager.this.mDelegate.getMinYear(), WeekViewPager.this.mDelegate.getMinYearMonth(), WeekViewPager.this.mDelegate.getMinYearDay(), position + 1, WeekViewPager.this.mDelegate.getWeekStart());
            if (TextUtils.isEmpty((CharSequence)WeekViewPager.this.mDelegate.getWeekViewClass())) {
                view = new DefaultWeekView(WeekViewPager.this.getContext());
            } else {
                try {
                    Class<?> cls = Class.forName(WeekViewPager.this.mDelegate.getWeekViewClass());
                    Constructor<?> constructor = cls.getConstructor(Context.class);
                    view = (WeekView)((Object)constructor.newInstance(WeekViewPager.this.getContext()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
            view.mParentLayout = WeekViewPager.this.mParentLayout;
            view.setup(WeekViewPager.this.mDelegate);
            view.setup(calendar);
            view.setTag(position);
            view.setSelectedCalendar(((WeekViewPager)WeekViewPager.this).mDelegate.mSelectedCalendar);
            container.addView((View)view);
            return view;
        }

        public void destroyItem(ViewGroup container, int position, Object object) {
            BaseView view = (BaseView)((Object)object);
            view.onDestroy();
            container.removeView((View)view);
        }
    }
}

