/*
 * Decompiled with CFR 0.152.
 */
package com.haibin.calendarview;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.haibin.calendarview.BaseRecyclerAdapter;
import com.haibin.calendarview.CalendarUtil;
import com.haibin.calendarview.CalendarViewDelegate;
import com.haibin.calendarview.Month;
import com.haibin.calendarview.R;
import com.haibin.calendarview.YearView;

final class YearAdapter
extends BaseRecyclerAdapter<Month> {
    private CalendarViewDelegate mDelegate;
    private int mItemHeight;
    private int mTextHeight;

    YearAdapter(Context context) {
        super(context);
        this.mTextHeight = CalendarUtil.dipToPx(context, 52.0f);
    }

    void setup(CalendarViewDelegate delegate) {
        this.mDelegate = delegate;
    }

    void setItemHeight(int itemHeight) {
        this.mItemHeight = itemHeight;
    }

    @Override
    RecyclerView.ViewHolder onCreateDefaultViewHolder(ViewGroup parent, int type) {
        return new YearViewHolder(this.mInflater.inflate(R.layout.cv_item_list_year, parent, false), this.mDelegate);
    }

    @Override
    void onBindViewHolder(RecyclerView.ViewHolder holder, Month item, int position) {
        YearViewHolder h = (YearViewHolder)holder;
        YearView view = h.mYearView;
        view.setSchemeColor(this.mDelegate.getYearViewSchemeTextColor());
        view.setTextStyle(this.mDelegate.getYearViewDayTextSize(), this.mDelegate.getYearViewDayTextColor());
        view.init(item.getDiff(), item.getCount(), item.getYear(), item.getMonth());
        view.measureHeight(this.mItemHeight - this.mTextHeight);
        h.mTextMonth.setText((CharSequence)this.mContext.getResources().getStringArray(R.array.month_string_array)[item.getMonth() - 1]);
        h.mTextMonth.setTextSize(0, (float)this.mDelegate.getYearViewMonthTextSize());
        h.mTextMonth.setTextColor(this.mDelegate.getYearViewMonthTextColor());
    }

    private static class YearViewHolder
    extends RecyclerView.ViewHolder {
        YearView mYearView;
        TextView mTextMonth;

        YearViewHolder(View itemView, CalendarViewDelegate delegate) {
            super(itemView);
            this.mYearView = (YearView)itemView.findViewById(R.id.selectView);
            this.mYearView.setup(delegate);
            this.mTextMonth = (TextView)itemView.findViewById(R.id.tv_month);
        }
    }
}

