/*
 * Decompiled with CFR 0.152.
 */
package com.haibin.calendarview;

import android.content.Context;
import android.support.annotation.Nullable;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.View;
import com.haibin.calendarview.BaseRecyclerAdapter;
import com.haibin.calendarview.CalendarUtil;
import com.haibin.calendarview.CalendarViewDelegate;
import com.haibin.calendarview.Month;
import com.haibin.calendarview.YearAdapter;
import java.util.Calendar;

public final class YearRecyclerView
extends RecyclerView {
    private CalendarViewDelegate mDelegate;
    private YearAdapter mAdapter;
    private OnMonthSelectedListener mListener;

    public YearRecyclerView(Context context) {
        this(context, null);
    }

    public YearRecyclerView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.mAdapter = new YearAdapter(context);
        this.setLayoutManager((RecyclerView.LayoutManager)new GridLayoutManager(context, 3));
        this.setAdapter(this.mAdapter);
        this.mAdapter.setOnItemClickListener(new BaseRecyclerAdapter.OnItemClickListener(){

            @Override
            public void onItemClick(int position, long itemId) {
                if (YearRecyclerView.this.mListener != null && YearRecyclerView.this.mDelegate != null) {
                    Month month = (Month)YearRecyclerView.this.mAdapter.getItem(position);
                    if (month == null) {
                        return;
                    }
                    if (!CalendarUtil.isMonthInRange(month.getYear(), month.getMonth(), YearRecyclerView.this.mDelegate.getMinYear(), YearRecyclerView.this.mDelegate.getMinYearMonth(), YearRecyclerView.this.mDelegate.getMaxYear(), YearRecyclerView.this.mDelegate.getMaxYearMonth())) {
                        return;
                    }
                    YearRecyclerView.this.mListener.onMonthSelected(month.getYear(), month.getMonth());
                }
            }
        });
    }

    void setup(CalendarViewDelegate delegate) {
        this.mDelegate = delegate;
        this.mAdapter.setup(delegate);
    }

    final void init(int year) {
        Calendar date = Calendar.getInstance();
        for (int i = 1; i <= 12; ++i) {
            date.set(year, i - 1, 1);
            int mDaysCount = CalendarUtil.getMonthDaysCount(year, i);
            Month month = new Month();
            month.setDiff(CalendarUtil.getMonthViewStartDiff(year, i, this.mDelegate.getWeekStart()));
            month.setCount(mDaysCount);
            month.setMonth(i);
            month.setYear(year);
            this.mAdapter.addItem(month);
        }
    }

    final void updateWeekStart() {
        for (Month month : this.mAdapter.getItems()) {
            month.setDiff(CalendarUtil.getMonthViewStartDiff(month.getYear(), month.getMonth(), this.mDelegate.getWeekStart()));
        }
    }

    final void setOnMonthSelectedListener(OnMonthSelectedListener listener) {
        this.mListener = listener;
    }

    protected void onMeasure(int widthSpec, int heightSpec) {
        super.onMeasure(widthSpec, heightSpec);
        int h = View.MeasureSpec.getSize((int)heightSpec);
        this.mAdapter.setItemHeight(h / 4);
    }

    static interface OnMonthSelectedListener {
        public void onMonthSelected(int var1, int var2);
    }
}

