/*
 * Decompiled with CFR 0.152.
 */
package com.haibin.calendarview;

import android.annotation.SuppressLint;
import android.content.Context;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.Display;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import com.haibin.calendarview.CalendarViewDelegate;
import com.haibin.calendarview.YearRecyclerView;

public final class YearSelectLayout
extends ViewPager {
    private int mYearCount;
    private boolean isUpdateYearView;
    private CalendarViewDelegate mDelegate;
    private YearRecyclerView.OnMonthSelectedListener mListener;

    public YearSelectLayout(Context context) {
        this(context, null);
    }

    public YearSelectLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    void setup(CalendarViewDelegate delegate) {
        this.mDelegate = delegate;
        this.mYearCount = this.mDelegate.getMaxYear() - this.mDelegate.getMinYear() + 1;
        this.setAdapter(new PagerAdapter(){

            public int getCount() {
                return YearSelectLayout.this.mYearCount;
            }

            public int getItemPosition(Object object) {
                return YearSelectLayout.this.isUpdateYearView ? -2 : super.getItemPosition(object);
            }

            public boolean isViewFromObject(View view, Object object) {
                return view == object;
            }

            public Object instantiateItem(ViewGroup container, int position) {
                YearRecyclerView view = new YearRecyclerView(YearSelectLayout.this.getContext());
                container.addView((View)view);
                view.setup(YearSelectLayout.this.mDelegate);
                view.setOnMonthSelectedListener(YearSelectLayout.this.mListener);
                view.init(position + YearSelectLayout.this.mDelegate.getMinYear());
                return view;
            }

            public void destroyItem(ViewGroup container, int position, Object object) {
                if (object instanceof YearRecyclerView) {
                    container.removeView((View)((YearRecyclerView)((Object)object)));
                }
            }
        });
        this.setCurrentItem(this.mDelegate.getCurrentDay().getYear() - this.mDelegate.getMinYear());
    }

    void notifyDataSetChanged() {
        this.mYearCount = this.mDelegate.getMaxYear() - this.mDelegate.getMinYear() + 1;
        this.getAdapter().notifyDataSetChanged();
    }

    void scrollToYear(int year, boolean smoothScroll) {
        this.setCurrentItem(year - this.mDelegate.getMinYear(), smoothScroll);
    }

    void updateRange() {
        this.isUpdateYearView = true;
        this.notifyDataSetChanged();
        this.isUpdateYearView = false;
    }

    void update() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            YearRecyclerView view = (YearRecyclerView)this.getChildAt(i);
            view.getAdapter().notifyDataSetChanged();
        }
    }

    void updateWeekStart() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            YearRecyclerView view = (YearRecyclerView)this.getChildAt(i);
            view.updateWeekStart();
            view.getAdapter().notifyDataSetChanged();
        }
    }

    public void setOnMonthSelectedListener(YearRecyclerView.OnMonthSelectedListener listener) {
        this.mListener = listener;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)YearSelectLayout.getHeight(this.getContext(), (View)this), (int)0x40000000);
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    private static int getHeight(Context context, View view) {
        WindowManager manager = (WindowManager)context.getSystemService("window");
        assert (manager != null);
        Display display = manager.getDefaultDisplay();
        int h = display.getHeight();
        int[] location = new int[2];
        view.getLocationInWindow(location);
        view.getLocationOnScreen(location);
        return h - location[1];
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(MotionEvent ev) {
        return this.mDelegate.isYearViewScrollable() && super.onTouchEvent(ev);
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        return this.mDelegate.isYearViewScrollable() && super.onInterceptTouchEvent(ev);
    }
}

