/*
 * Decompiled with CFR 0.152.
 */
package com.haibin.calendarview;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import com.haibin.calendarview.Calendar;
import com.haibin.calendarview.CalendarViewDelegate;

public class YearView
extends View {
    private int mDiff;
    private int mCount;
    private int mLastCount;
    private int mLine;
    private Paint mPaint = new Paint();
    private Paint mSchemePaint = new Paint();
    private Calendar mCalendar;
    private int mMinHeight;
    private CalendarViewDelegate mDelegate;

    public YearView(Context context) {
        this(context, null);
    }

    public YearView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.mPaint.setAntiAlias(true);
        this.mPaint.setTextAlign(Paint.Align.CENTER);
        this.mSchemePaint.setAntiAlias(true);
        this.mSchemePaint.setTextAlign(Paint.Align.CENTER);
        this.measureLine();
    }

    protected void onDraw(Canvas canvas) {
        int width = this.getWidth();
        int height = this.getHeight();
        int pLeft = this.getPaddingLeft();
        int w = (width - this.getPaddingLeft() - this.getPaddingRight()) / 7;
        int h = (height - this.getPaddingTop() - this.getPaddingBottom()) / 6;
        int d = 0;
        for (int i = 0; i < this.mLine; ++i) {
            int j;
            int first;
            if (i == 0) {
                for (int j2 = 0; j2 < 7 - this.mDiff; ++j2) {
                    canvas.drawText(String.valueOf(j2 + 1), (float)(this.mDiff * w + j2 * w + pLeft + w / 2), (float)h, this.isScheme(++d) ? this.mSchemePaint : this.mPaint);
                }
                continue;
            }
            if (i == this.mLine - 1 && this.mLastCount != 0) {
                first = this.mCount - this.mLastCount + 1;
                for (j = 0; j < this.mLastCount; ++j) {
                    canvas.drawText(String.valueOf(first), (float)(j * w + pLeft + w / 2), (float)((i + 1) * h), this.isScheme(++d) ? this.mSchemePaint : this.mPaint);
                    ++first;
                }
                continue;
            }
            first = i * 7 - this.mDiff + 1;
            for (j = 0; j < 7; ++j) {
                canvas.drawText(String.valueOf(first), (float)(j * w + pLeft + w / 2), (float)((i + 1) * h), this.isScheme(++d) ? this.mSchemePaint : this.mPaint);
                ++first;
            }
        }
    }

    private void measureLine() {
        int offset = this.mCount - (7 - this.mDiff);
        this.mLine = 1 + (offset % 7 == 0 ? 0 : 1) + offset / 7;
        this.mLastCount = offset % 7;
    }

    void init(int mDiff, int mCount, int mYear, int mMonth) {
        this.mDiff = mDiff;
        this.mCount = mCount;
        this.mCalendar = new Calendar();
        this.mCalendar.setYear(mYear);
        this.mCalendar.setMonth(mMonth);
        this.measureLine();
        this.invalidate();
    }

    void setup(CalendarViewDelegate delegate) {
        this.mDelegate = delegate;
        this.mSchemePaint.setColor(delegate.getYearViewSchemeTextColor());
        this.mSchemePaint.setTextSize((float)delegate.getYearViewDayTextSize());
        this.mPaint.setTextSize((float)delegate.getYearViewDayTextSize());
        this.mPaint.setColor(delegate.getYearViewDayTextColor());
        Rect rect = new Rect();
        this.mPaint.getTextBounds("1", 0, 1, rect);
        int textHeight = rect.height();
        this.mMinHeight = 12 * textHeight;
    }

    void setSchemeColor(int schemeColor) {
        if (schemeColor != 0) {
            this.mSchemePaint.setColor(schemeColor);
        }
        if (schemeColor == -13616834) {
            this.mSchemePaint.setColor(-65536);
        }
    }

    void setTextStyle(int textSize, int textColor) {
        this.mSchemePaint.setTextSize((float)textSize);
        this.mPaint.setTextSize((float)textSize);
        this.mPaint.setColor(textColor);
    }

    void measureHeight(int height) {
        this.getLayoutParams().height = height <= this.mMinHeight ? this.mMinHeight : height;
    }

    private boolean isScheme(int day) {
        if (this.mDelegate.getSchemeType() == 1) {
            if (this.mDelegate.mSchemeDate == null || this.mDelegate.mSchemeDate.size() == 0) {
                return false;
            }
            this.mCalendar.setDay(day);
            return this.mDelegate.mSchemeDate.contains(this.mCalendar);
        }
        if (this.mDelegate.mSchemeDatesMap == null || this.mDelegate.mSchemeDatesMap.size() == 0) {
            return false;
        }
        this.mCalendar.setDay(day);
        return this.mDelegate.mSchemeDatesMap.containsKey(this.mCalendar.toString());
    }
}

