/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.dependency.perceptron.transition.configuration;

import com.hankcs.hanlp.dependency.perceptron.accessories.Edge;
import java.util.ArrayDeque;

public class State
implements Cloneable {
    public int rootIndex;
    public int maxSentenceSize;
    protected boolean emptyFlag = false;
    protected Edge[] arcs;
    protected int[] leftMostArcs;
    protected int[] rightMostArcs;
    protected int[] leftValency;
    protected int[] rightValency;
    protected long[] rightDepLabels;
    protected long[] leftDepLabels;
    protected ArrayDeque<Integer> stack = new ArrayDeque();
    int bufferHead;

    public State(int size) {
        this.arcs = new Edge[size + 1];
        this.leftMostArcs = new int[size + 1];
        this.rightMostArcs = new int[size + 1];
        this.leftValency = new int[size + 1];
        this.rightValency = new int[size + 1];
        this.rightDepLabels = new long[size + 1];
        this.leftDepLabels = new long[size + 1];
        this.rootIndex = 0;
        this.bufferHead = 1;
        this.maxSentenceSize = 0;
    }

    public State(int sentenceSize, boolean rootFirst) {
        this(sentenceSize);
        if (rootFirst) {
            this.stack.push(0);
            this.rootIndex = 0;
            this.maxSentenceSize = sentenceSize;
        } else {
            this.rootIndex = sentenceSize;
            this.maxSentenceSize = sentenceSize;
        }
    }

    public ArrayDeque<Integer> getStack() {
        return this.stack;
    }

    public int pop() {
        return this.stack.pop();
    }

    public void push(int index) {
        this.stack.push(index);
    }

    public void addArc(int dependent, int head, int dependency) {
        this.arcs[dependent] = new Edge(head, dependency);
        long value = 1L << dependency;
        assert (dependency < 64);
        if (dependent > head) {
            if (this.rightMostArcs[head] == 0 || dependent > this.rightMostArcs[head]) {
                this.rightMostArcs[head] = dependent;
            }
            int n = head;
            this.rightValency[n] = this.rightValency[n] + 1;
            this.rightDepLabels[head] = this.rightDepLabels[head] | value;
        } else {
            if (this.leftMostArcs[head] == 0 || dependent < this.leftMostArcs[head]) {
                this.leftMostArcs[head] = dependent;
            }
            this.leftDepLabels[head] = this.leftDepLabels[head] | value;
            int n = head;
            this.leftValency[n] = this.leftValency[n] + 1;
        }
    }

    public long rightDependentLabels(int position) {
        return this.rightDepLabels[position];
    }

    public long leftDependentLabels(int position) {
        return this.leftDepLabels[position];
    }

    public boolean isEmptyFlag() {
        return this.emptyFlag;
    }

    public void setEmptyFlag(boolean emptyFlag) {
        this.emptyFlag = emptyFlag;
    }

    public int bufferHead() {
        return this.bufferHead;
    }

    public int stackTop() {
        if (this.stack.size() > 0) {
            return this.stack.peek();
        }
        return -1;
    }

    public int getBufferItem(int position) {
        return this.bufferHead + position;
    }

    public boolean isTerminalState() {
        return this.stackEmpty() && (this.bufferEmpty() || this.bufferHead == this.rootIndex);
    }

    public boolean hasHead(int dependent) {
        return this.arcs[dependent] != null;
    }

    public boolean bufferEmpty() {
        return this.bufferHead == -1;
    }

    public boolean stackEmpty() {
        return this.stack.size() == 0;
    }

    public int bufferSize() {
        if (this.bufferHead < 0) {
            return 0;
        }
        return this.maxSentenceSize - this.bufferHead + 1;
    }

    public int stackSize() {
        return this.stack.size();
    }

    public int rightMostModifier(int index) {
        return this.rightMostArcs[index] == 0 ? -1 : this.rightMostArcs[index];
    }

    public int leftMostModifier(int index) {
        return this.leftMostArcs[index] == 0 ? -1 : this.leftMostArcs[index];
    }

    public int valence(int head) {
        return this.rightValency(head) + this.leftValency(head);
    }

    public int rightValency(int head) {
        return this.rightValency[head];
    }

    public int leftValency(int head) {
        return this.leftValency[head];
    }

    public int getHead(int index) {
        if (this.arcs[index] != null) {
            return this.arcs[index].headIndex;
        }
        return -1;
    }

    public int getDependent(int index) {
        if (this.arcs[index] != null) {
            return this.arcs[index].relationId;
        }
        return -1;
    }

    public void setMaxSentenceSize(int maxSentenceSize) {
        this.maxSentenceSize = maxSentenceSize;
    }

    public void incrementBufferHead() {
        this.bufferHead = this.bufferHead == this.maxSentenceSize ? -1 : ++this.bufferHead;
    }

    public void setBufferHead(int bufferHead) {
        this.bufferHead = bufferHead;
    }

    public State clone() {
        State state = new State(this.arcs.length - 1);
        state.stack = new ArrayDeque<Integer>(this.stack);
        for (int dependent = 0; dependent < this.arcs.length; ++dependent) {
            Edge head;
            if (this.arcs[dependent] == null) continue;
            state.arcs[dependent] = head = this.arcs[dependent];
            int h = head.headIndex;
            if (this.rightMostArcs[h] != 0) {
                state.rightMostArcs[h] = this.rightMostArcs[h];
                state.rightValency[h] = this.rightValency[h];
                state.rightDepLabels[h] = this.rightDepLabels[h];
            }
            if (this.leftMostArcs[h] == 0) continue;
            state.leftMostArcs[h] = this.leftMostArcs[h];
            state.leftValency[h] = this.leftValency[h];
            state.leftDepLabels[h] = this.leftDepLabels[h];
        }
        state.rootIndex = this.rootIndex;
        state.bufferHead = this.bufferHead;
        state.maxSentenceSize = this.maxSentenceSize;
        state.emptyFlag = this.emptyFlag;
        return state;
    }
}

