/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.model.hmm;

import com.hankcs.hanlp.model.hmm.HiddenMarkovModel;

public class FirstOrderHiddenMarkovModel
extends HiddenMarkovModel {
    public FirstOrderHiddenMarkovModel() {
        this(null, null, null);
    }

    public FirstOrderHiddenMarkovModel(float[] start_probability, float[][] transition_probability, float[][] emission_probability) {
        super(start_probability, transition_probability, emission_probability);
        this.toLog();
    }

    @Override
    public int[][] generate(int length) {
        double[] pi = FirstOrderHiddenMarkovModel.logToCdf(this.start_probability);
        double[][] A = FirstOrderHiddenMarkovModel.logToCdf(this.transition_probability);
        double[][] B = FirstOrderHiddenMarkovModel.logToCdf(this.emission_probability);
        int[][] xy = new int[2][length];
        xy[1][0] = FirstOrderHiddenMarkovModel.drawFrom(pi);
        xy[0][0] = FirstOrderHiddenMarkovModel.drawFrom(B[xy[1][0]]);
        for (int t = 1; t < length; ++t) {
            xy[1][t] = FirstOrderHiddenMarkovModel.drawFrom(A[xy[1][t - 1]]);
            xy[0][t] = FirstOrderHiddenMarkovModel.drawFrom(B[xy[1][t]]);
        }
        return xy;
    }

    @Override
    public float predict(int[] observation, int[] state) {
        int s;
        int time = observation.length;
        int max_s = this.start_probability.length;
        float[] score = new float[max_s];
        int[][] link = new int[time][max_s];
        for (int cur_s = 0; cur_s < max_s; ++cur_s) {
            score[cur_s] = this.start_probability[cur_s] + this.emission_probability[cur_s][observation[0]];
        }
        float[] pre = new float[max_s];
        for (int t = 1; t < observation.length; ++t) {
            float[] buffer = pre;
            pre = score;
            score = buffer;
            for (s = 0; s < max_s; ++s) {
                score[s] = -2.1474836E9f;
                for (int f = 0; f < max_s; ++f) {
                    float p = pre[f] + this.transition_probability[f][s] + this.emission_probability[s][observation[t]];
                    if (!(p > score[s])) continue;
                    score[s] = p;
                    link[t][s] = f;
                }
            }
        }
        float max_score = -2.1474836E9f;
        int best_s = 0;
        for (s = 0; s < max_s; ++s) {
            if (!(score[s] > max_score)) continue;
            max_score = score[s];
            best_s = s;
        }
        for (int t = link.length - 1; t >= 0; --t) {
            state[t] = best_s;
            best_s = link[t][best_s];
        }
        return max_score;
    }
}

