/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.tokenizer.pipe;

import com.hankcs.hanlp.corpus.document.sentence.word.IWord;
import com.hankcs.hanlp.tokenizer.lexical.LexicalAnalyzer;
import com.hankcs.hanlp.tokenizer.pipe.Pipe;
import java.util.List;
import java.util.ListIterator;

public class LexicalAnalyzerPipe
implements Pipe<List<IWord>, List<IWord>> {
    protected LexicalAnalyzer analyzer;

    public LexicalAnalyzerPipe(LexicalAnalyzer analyzer) {
        this.analyzer = analyzer;
    }

    @Override
    public List<IWord> flow(List<IWord> input) {
        ListIterator<IWord> listIterator = input.listIterator();
        while (listIterator.hasNext()) {
            IWord wordOrSentence = listIterator.next();
            if (wordOrSentence.getLabel() != null) continue;
            listIterator.remove();
            String sentence = wordOrSentence.getValue();
            for (IWord word : this.analyzer.analyze(sentence)) {
                listIterator.add(word);
            }
        }
        return input;
    }
}

