/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.text.util;

import com.helger.commons.codec.DecodeException;
import com.helger.commons.codec.EncodeException;
import com.helger.commons.text.codepoint.CodepointHelper;
import com.helger.commons.text.codepoint.CodepointIteratorCharArray;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class Punycode {
    private static final int BASE = 36;
    private static final int TMIN = 1;
    private static final int TMAX = 26;
    private static final int SKEW = 38;
    private static final int DAMP = 700;
    private static final int INITIAL_BIAS = 72;
    private static final int INITIAL_N = 128;
    private static final int DELIMITER = 45;
    private static final Punycode s_aInstance = new Punycode();

    private Punycode() {
    }

    private static boolean _basic(int n) {
        return n < 128;
    }

    private static boolean _delim(int n) {
        return n == 45;
    }

    private static boolean _flagged(int n) {
        return n - 65 < 26;
    }

    private static int _decode_digit(int n) {
        if (n - 48 < 10) {
            return n - 22;
        }
        if (n - 65 < 26) {
            return n - 65;
        }
        if (n - 97 < 26) {
            return n - 97;
        }
        return 36;
    }

    private static int _t(boolean bl) {
        return bl ? 1 : 0;
    }

    private static int _encode_digit(int n, boolean bl) {
        return n + 22 + 75 * Punycode._t(n < 26) - (Punycode._t(bl) << 5);
    }

    private static int _adapt(int n, int n2, boolean bl) {
        int n3 = n;
        n3 = bl ? n3 / 700 : n3 >> 1;
        n3 += n3 / n2;
        int n4 = 0;
        while (n3 > 455) {
            n3 /= 35;
            n4 += 36;
        }
        return n4 + 36 * n3 / (n3 + 38);
    }

    @Nullable
    public static String getEncoded(@Nullable String string) {
        if (string == null) {
            return null;
        }
        return Punycode.getEncoded(string.toCharArray(), null);
    }

    public static String getEncoded(@Nonnull char[] cArray, @Nullable boolean[] blArray) {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        CodepointIteratorCharArray codepointIteratorCharArray = new CodepointIteratorCharArray(cArray);
        int n2 = 128;
        int n3 = 0;
        int n4 = 72;
        int n5 = -1;
        while (codepointIteratorCharArray.hasNext()) {
            n5 = codepointIteratorCharArray.next().getValue();
            if (!Punycode._basic(n5) || blArray != null) continue;
            stringBuilder.append((char)n5);
        }
        int n6 = n = stringBuilder.length();
        if (n > 0) {
            stringBuilder.append('-');
        }
        while (n6 < cArray.length) {
            codepointIteratorCharArray.position(0);
            n5 = -1;
            int n7 = Integer.MAX_VALUE;
            while (codepointIteratorCharArray.hasNext()) {
                n5 = codepointIteratorCharArray.next().getValue();
                if (n5 < n2 || n5 >= n7) continue;
                n7 = n5;
            }
            if (n7 - n2 > (Integer.MAX_VALUE - n3) / (n6 + 1)) {
                throw new EncodeException("Overflow");
            }
            n3 += (n7 - n2) * (n6 + 1);
            n2 = n7;
            codepointIteratorCharArray.position(0);
            n5 = -1;
            while (codepointIteratorCharArray.hasNext()) {
                n5 = codepointIteratorCharArray.next().getValue();
                if (n5 < n2 && ++n3 == 0) {
                    throw new EncodeException("Overflow");
                }
                if (n5 != n2) continue;
                int n8 = n3;
                int n9 = 36;
                while (true) {
                    int n10;
                    int n11 = n9 <= n4 ? 1 : (n10 = n9 >= n4 + 26 ? 26 : n9 - n4);
                    if (n8 < n10) break;
                    stringBuilder.append((char)Punycode._encode_digit(n10 + (n8 - n10) % (36 - n10), false));
                    n8 = (n8 - n10) / (36 - n10);
                    n9 += 36;
                }
                stringBuilder.append((char)Punycode._encode_digit(n8, blArray != null ? blArray[codepointIteratorCharArray.position() - 1] : false));
                n4 = Punycode._adapt(n3, n6 + 1, n6 == n);
                n3 = 0;
                ++n6;
            }
            ++n3;
            ++n2;
        }
        return stringBuilder.toString();
    }

    @Nullable
    public static String getDecoded(@Nullable String string) {
        if (string == null) {
            return null;
        }
        return Punycode.getDecoded(string.toCharArray(), null);
    }

    @Nonnull
    @SuppressFBWarnings(value={"QF_QUESTIONABLE_FOR_LOOP"})
    public static String getDecoded(@Nonnull char[] cArray, @Nullable boolean[] blArray) {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 128;
        int n3 = 0;
        int n4 = 0;
        int n5 = 72;
        int n6 = 0;
        for (n = 0; n < cArray.length; ++n) {
            if (!Punycode._delim(cArray[n])) continue;
            n6 = n;
        }
        for (n = 0; n < n6; ++n) {
            if (blArray != null) {
                blArray[n3] = Punycode._flagged(cArray[n]);
            }
            if (!Punycode._basic(cArray[n])) {
                throw new DecodeException("Bad Input");
            }
            stringBuilder.append(cArray[n]);
        }
        n3 = stringBuilder.length();
        int n7 = n = n6 > 0 ? n6 + 1 : 0;
        while (n < cArray.length) {
            int n8 = n4;
            int n9 = 1;
            int n10 = 36;
            while (true) {
                int n11;
                int n12;
                if (n > cArray.length) {
                    throw new DecodeException("Bad input");
                }
                if ((n12 = Punycode._decode_digit(cArray[n++])) >= 36) {
                    throw new DecodeException("Bad input");
                }
                if (n12 > (Integer.MAX_VALUE - n4) / n9) {
                    throw new DecodeException("Overflow");
                }
                n4 += n12 * n9;
                int n13 = n10 <= n5 ? 1 : (n11 = n10 >= n5 + 26 ? 26 : n10 - n5);
                if (n12 < n11) break;
                if (n9 > Integer.MAX_VALUE / (36 - n11)) {
                    throw new DecodeException("Overflow");
                }
                n9 *= 36 - n11;
                n10 += 36;
            }
            n5 = Punycode._adapt(n4 - n8, n3 + 1, n8 == 0);
            if (n4 / (n3 + 1) > Integer.MAX_VALUE - n2) {
                throw new DecodeException("Overflow");
            }
            n2 += n4 / (n3 + 1);
            n4 %= n3 + 1;
            if (blArray != null) {
                System.arraycopy(blArray, n4, blArray, n4 + Character.charCount(n2), blArray.length - n4);
            }
            CodepointHelper.insert((CharSequence)stringBuilder, n4++, n2);
            ++n3;
        }
        return stringBuilder.toString();
    }
}

