/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.url;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.url.IURLProtocol;
import com.helger.commons.url.URLProtocolRegistry;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum EURLProtocol implements IURLProtocol
{
    HTTP("http://"),
    HTTPS("https://"),
    FILE("file://"),
    FTP("ftp://"),
    BUNDLE("bundle://"),
    CALLTO("callto:"),
    DATA("data:"),
    FTPS("ftps://"),
    GEO("geo:"),
    GOPHER("gopher://"),
    JAR("jar:"),
    JAVASCRIPT("javascript:"),
    LDAP("ldap:"),
    MAILTO("mailto:"),
    MMS("mms:"),
    NEWS("news:"),
    NNTP("nntp:"),
    POP("pop://"),
    RSYNC("rsync:"),
    RTMP("rtmp://"),
    RTSP("rtsp://"),
    RTSPU("rtspu://"),
    SCP("scp://"),
    SFTP("sftp://"),
    SHTTP("shttp://"),
    SIP("sip:"),
    SIPS("sips:"),
    TEL("tel:"),
    TELNET("telnet://"),
    URN("urn:"),
    WS("ws://"),
    WSJAR("wsjar:"),
    WSS("wss://"),
    ZIP("zip:");

    private final String m_sProtocol;

    private EURLProtocol(String string2) {
        this.m_sProtocol = string2;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getProtocol() {
        return this.m_sProtocol;
    }

    @Override
    public boolean isUsedInURL(@Nullable String string) {
        return string != null && string.startsWith(this.m_sProtocol, 0);
    }

    @Override
    @Nullable
    public String getWithProtocol(@Nullable String string) {
        if (string == null) {
            return null;
        }
        return this.m_sProtocol + string;
    }

    @Override
    @Nullable
    public String getWithProtocolIfNone(@Nullable String string) {
        if (string == null || URLProtocolRegistry.getInstance().hasKnownProtocol(string)) {
            return string;
        }
        return this.m_sProtocol + string;
    }

    @Override
    public boolean allowsForQueryParameters() {
        return this == HTTP || this == HTTPS || this == MAILTO || this == SHTTP;
    }
}

