/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt;

import com.hivemq.client.internal.mqtt.MqttClientConfig;
import com.hivemq.client.internal.mqtt.MqttClientExecutorConfigImpl;
import com.hivemq.client.internal.mqtt.MqttClientExecutorConfigImplBuilder;
import com.hivemq.client.internal.mqtt.MqttClientTransportConfigImpl;
import com.hivemq.client.internal.mqtt.MqttClientTransportConfigImplBuilder;
import com.hivemq.client.internal.mqtt.MqttRxClientBuilder;
import com.hivemq.client.internal.mqtt.advanced.MqttClientAdvancedConfig;
import com.hivemq.client.internal.mqtt.datatypes.MqttClientIdentifierImpl;
import com.hivemq.client.internal.mqtt.lifecycle.MqttClientAutoReconnectImpl;
import com.hivemq.client.internal.mqtt.lifecycle.MqttClientAutoReconnectImplBuilder;
import com.hivemq.client.internal.mqtt.mqtt3.Mqtt3RxClientViewBuilder;
import com.hivemq.client.internal.mqtt.util.MqttChecks;
import com.hivemq.client.internal.util.Checks;
import com.hivemq.client.internal.util.collections.ImmutableList;
import com.hivemq.client.mqtt.MqttClientBuilder;
import com.hivemq.client.mqtt.MqttClientExecutorConfig;
import com.hivemq.client.mqtt.MqttClientSslConfig;
import com.hivemq.client.mqtt.MqttClientTransportConfig;
import com.hivemq.client.mqtt.MqttVersion;
import com.hivemq.client.mqtt.MqttWebSocketConfig;
import com.hivemq.client.mqtt.datatypes.MqttClientIdentifier;
import com.hivemq.client.mqtt.lifecycle.MqttClientAutoReconnect;
import com.hivemq.client.mqtt.lifecycle.MqttClientConnectedListener;
import com.hivemq.client.mqtt.lifecycle.MqttClientDisconnectedListener;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MqttRxClientBuilderBase<B extends MqttRxClientBuilderBase<B>>
extends MqttClientTransportConfigImplBuilder<B> {
    @NotNull
    private MqttClientIdentifierImpl identifier = MqttClientIdentifierImpl.REQUEST_CLIENT_IDENTIFIER_FROM_SERVER;
    @Nullable
    private MqttClientTransportConfigImpl transportConfig = MqttClientTransportConfigImpl.DEFAULT;
    @NotNull
    private MqttClientExecutorConfigImpl executorConfig = MqttClientExecutorConfigImpl.DEFAULT;
    @Nullable
    private MqttClientAutoReconnectImpl autoReconnect;
    @Nullable
    private ImmutableList.Builder<MqttClientConnectedListener> connectedListenersBuilder;
    @Nullable
    private ImmutableList.Builder<MqttClientDisconnectedListener> disconnectedListenersBuilder;

    protected MqttRxClientBuilderBase() {
    }

    protected MqttRxClientBuilderBase(@NotNull MqttRxClientBuilderBase<?> clientBuilder) {
        super(clientBuilder);
        this.identifier = clientBuilder.identifier;
        this.transportConfig = clientBuilder.transportConfig;
        this.executorConfig = clientBuilder.executorConfig;
        this.autoReconnect = clientBuilder.autoReconnect;
        this.connectedListenersBuilder = clientBuilder.connectedListenersBuilder;
        this.disconnectedListenersBuilder = clientBuilder.disconnectedListenersBuilder;
    }

    @Override
    @NotNull
    protected abstract B self();

    @NotNull
    public B identifier(@Nullable String identifier) {
        this.identifier = MqttClientIdentifierImpl.of(identifier);
        return (B)this.self();
    }

    @NotNull
    public B identifier(@Nullable MqttClientIdentifier identifier) {
        this.identifier = MqttChecks.clientIdentifier(identifier);
        return (B)this.self();
    }

    @Override
    @NotNull
    public B serverAddress(@Nullable InetSocketAddress address) {
        this.transportConfig = null;
        return (B)((MqttRxClientBuilderBase)super.serverAddress(address));
    }

    @Override
    @NotNull
    public B serverHost(@Nullable String host) {
        this.transportConfig = null;
        return (B)((MqttRxClientBuilderBase)super.serverHost(host));
    }

    @Override
    @NotNull
    public B serverHost(@Nullable InetAddress host) {
        this.transportConfig = null;
        return (B)((MqttRxClientBuilderBase)super.serverHost(host));
    }

    @Override
    @NotNull
    public B serverPort(int port) {
        this.transportConfig = null;
        return (B)((MqttRxClientBuilderBase)super.serverPort(port));
    }

    @Override
    @NotNull
    public B sslWithDefaultConfig() {
        this.transportConfig = null;
        return (B)((MqttRxClientBuilderBase)super.sslWithDefaultConfig());
    }

    @Override
    @NotNull
    public B sslConfig(@Nullable MqttClientSslConfig sslConfig) {
        return (B)((MqttRxClientBuilderBase)super.sslConfig(sslConfig));
    }

    @Override
    @NotNull
    public B webSocketWithDefaultConfig() {
        this.transportConfig = null;
        return (B)((MqttRxClientBuilderBase)super.webSocketWithDefaultConfig());
    }

    @Override
    @NotNull
    public B webSocketConfig(@Nullable MqttWebSocketConfig webSocketConfig) {
        this.transportConfig = null;
        return (B)((MqttRxClientBuilderBase)super.webSocketConfig(webSocketConfig));
    }

    @NotNull
    public B transportConfig(@Nullable MqttClientTransportConfig transportConfig) {
        this.transportConfig = Checks.notImplemented(transportConfig, MqttClientTransportConfigImpl.class, "Transport config");
        this.set(this.transportConfig);
        return (B)this.self();
    }

    @NotNull
    public MqttClientTransportConfigImplBuilder.Nested<B> transportConfig() {
        return new MqttClientTransportConfigImplBuilder.Nested<MqttRxClientBuilderBase>(this, this::transportConfig);
    }

    @NotNull
    public B executorConfig(@Nullable MqttClientExecutorConfig executorConfig) {
        this.executorConfig = Checks.notImplemented(executorConfig, MqttClientExecutorConfigImpl.class, "Executor config");
        return (B)this.self();
    }

    @NotNull
    public MqttClientExecutorConfigImplBuilder.Nested<B> executorConfig() {
        return new MqttClientExecutorConfigImplBuilder.Nested<MqttRxClientBuilderBase>(this.executorConfig, this::executorConfig);
    }

    @NotNull
    public B automaticReconnectWithDefaultConfig() {
        this.autoReconnect = MqttClientAutoReconnectImpl.DEFAULT;
        return (B)this.self();
    }

    @NotNull
    public B automaticReconnect(@Nullable MqttClientAutoReconnect autoReconnect) {
        this.autoReconnect = Checks.notImplementedOrNull(autoReconnect, MqttClientAutoReconnectImpl.class, "Automatic reconnect");
        return (B)this.self();
    }

    @NotNull
    public MqttClientAutoReconnectImplBuilder.Nested<B> automaticReconnect() {
        return new MqttClientAutoReconnectImplBuilder.Nested<MqttRxClientBuilderBase>(this.autoReconnect, this::automaticReconnect);
    }

    @NotNull
    public B addConnectedListener(@Nullable MqttClientConnectedListener connectedListener) {
        Checks.notNull(connectedListener, "Connected listener");
        if (this.connectedListenersBuilder == null) {
            this.connectedListenersBuilder = ImmutableList.builder();
        }
        this.connectedListenersBuilder.add(connectedListener);
        return (B)this.self();
    }

    @NotNull
    public B addDisconnectedListener(@Nullable MqttClientDisconnectedListener disconnectedListener) {
        Checks.notNull(disconnectedListener, "Disconnected listener");
        if (this.disconnectedListenersBuilder == null) {
            this.disconnectedListenersBuilder = ImmutableList.builder();
        }
        this.disconnectedListenersBuilder.add(disconnectedListener);
        return (B)this.self();
    }

    @Override
    @NotNull
    MqttClientTransportConfigImpl buildTransportConfig() {
        if (this.transportConfig == null) {
            return super.buildTransportConfig();
        }
        return this.transportConfig;
    }

    @NotNull
    private ImmutableList<MqttClientConnectedListener> buildConnectedListeners() {
        if (this.connectedListenersBuilder == null) {
            return ImmutableList.of();
        }
        return this.connectedListenersBuilder.build();
    }

    @NotNull
    private ImmutableList<MqttClientDisconnectedListener> buildDisconnectedListeners() {
        if (this.disconnectedListenersBuilder == null) {
            if (this.autoReconnect == null) {
                return ImmutableList.of();
            }
            return ImmutableList.of(this.autoReconnect);
        }
        if (this.autoReconnect == null) {
            return this.disconnectedListenersBuilder.build();
        }
        return ImmutableList.builder().add(this.autoReconnect).addAll(this.disconnectedListenersBuilder.build()).build();
    }

    @NotNull
    protected MqttClientConfig buildClientConfig(@NotNull MqttVersion mqttVersion, @NotNull MqttClientAdvancedConfig advancedConfig, @NotNull MqttClientConfig.ConnectDefaults connectDefaults) {
        return new MqttClientConfig(mqttVersion, this.identifier, this.buildTransportConfig(), this.executorConfig, advancedConfig, connectDefaults, this.buildConnectedListeners(), this.buildDisconnectedListeners());
    }

    public static class Choose
    extends MqttRxClientBuilderBase<Choose>
    implements MqttClientBuilder {
        @Override
        @NotNull
        protected Choose self() {
            return this;
        }

        @Override
        @NotNull
        public Mqtt3RxClientViewBuilder useMqttVersion3() {
            return new Mqtt3RxClientViewBuilder((MqttRxClientBuilderBase)this);
        }

        @Override
        @NotNull
        public MqttRxClientBuilder useMqttVersion5() {
            return new MqttRxClientBuilder((MqttRxClientBuilderBase)this);
        }
    }
}

