/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.datatypes;

import com.hivemq.client.internal.util.ByteArray;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class MqttTopicLevel
extends ByteArray {
    @NotNull
    private static final MqttTopicLevel SINGLE_LEVEL_WILDCARD = new MqttTopicLevel(new byte[]{43});

    @NotNull
    static MqttTopicLevel of(@NotNull byte[] array, int start, int end) {
        if (MqttTopicLevel.isSingleLevelWildcard(array, start, end)) {
            return SINGLE_LEVEL_WILDCARD;
        }
        return new MqttTopicLevel(Arrays.copyOfRange(array, start, end));
    }

    private static boolean isSingleLevelWildcard(@NotNull byte[] array, int start, int end) {
        return end - start == 1 && array[start] == 43;
    }

    MqttTopicLevel(@NotNull byte[] array) {
        super(array);
    }

    @NotNull
    byte[] getArray() {
        return this.array;
    }

    public boolean isSingleLevelWildcard() {
        return MqttTopicLevel.isSingleLevelWildcard(this.array, this.getStart(), this.getEnd());
    }

    @NotNull
    public MqttTopicLevel trim() {
        return this;
    }
}

