/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.datatypes;

import com.hivemq.client.internal.mqtt.datatypes.MqttUserPropertiesImpl;
import com.hivemq.client.internal.mqtt.datatypes.MqttUserPropertyImpl;
import com.hivemq.client.internal.mqtt.util.MqttChecks;
import com.hivemq.client.internal.util.collections.ImmutableList;
import com.hivemq.client.mqtt.datatypes.MqttUtf8String;
import com.hivemq.client.mqtt.mqtt5.datatypes.Mqtt5UserPropertiesBuilder;
import com.hivemq.client.mqtt.mqtt5.datatypes.Mqtt5UserProperty;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MqttUserPropertiesImplBuilder<B extends MqttUserPropertiesImplBuilder<B>> {
    @NotNull
    private final ImmutableList.Builder<MqttUserPropertyImpl> listBuilder;

    MqttUserPropertiesImplBuilder() {
        this.listBuilder = ImmutableList.builder();
    }

    MqttUserPropertiesImplBuilder(@NotNull MqttUserPropertiesImpl userProperties) {
        List list = userProperties.asList();
        this.listBuilder = ImmutableList.builder(list.size() + 1);
        this.listBuilder.addAll(list);
    }

    @NotNull
    abstract B self();

    @NotNull
    public B add(@Nullable String name, @Nullable String value) {
        this.listBuilder.add(MqttUserPropertyImpl.of(name, value));
        return this.self();
    }

    @NotNull
    public B add(@Nullable MqttUtf8String name, @Nullable MqttUtf8String value) {
        this.listBuilder.add(MqttChecks.userProperty(name, value));
        return this.self();
    }

    @NotNull
    public B add(@Nullable Mqtt5UserProperty userProperty) {
        this.listBuilder.add(MqttChecks.userProperty(userProperty));
        return this.self();
    }

    @NotNull
    public MqttUserPropertiesImpl build() {
        return MqttUserPropertiesImpl.build(this.listBuilder);
    }

    public static class Nested<P>
    extends MqttUserPropertiesImplBuilder<Nested<P>>
    implements Mqtt5UserPropertiesBuilder.Nested<P> {
        @NotNull
        private final Function<? super MqttUserPropertiesImpl, P> parentConsumer;

        public Nested(@NotNull MqttUserPropertiesImpl userProperties, @NotNull Function<? super MqttUserPropertiesImpl, P> parentConsumer) {
            super(userProperties);
            this.parentConsumer = parentConsumer;
        }

        @Override
        @NotNull
        Nested<P> self() {
            return this;
        }

        @Override
        @NotNull
        public P applyUserProperties() {
            return this.parentConsumer.apply(this.build());
        }
    }

    public static class Default
    extends MqttUserPropertiesImplBuilder<Default>
    implements Mqtt5UserPropertiesBuilder {
        public Default() {
        }

        Default(@NotNull MqttUserPropertiesImpl userProperties) {
            super(userProperties);
        }

        @Override
        @NotNull
        Default self() {
            return this;
        }
    }
}

