/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.handler.auth;

import com.hivemq.client.internal.logging.InternalLogger;
import com.hivemq.client.internal.logging.InternalLoggerFactory;
import com.hivemq.client.internal.mqtt.MqttClientConfig;
import com.hivemq.client.internal.mqtt.datatypes.MqttUtf8StringImpl;
import com.hivemq.client.internal.mqtt.handler.auth.MqttAuthHandler;
import com.hivemq.client.internal.mqtt.handler.disconnect.MqttDisconnectUtil;
import com.hivemq.client.internal.mqtt.handler.util.MqttTimeoutInboundHandler;
import com.hivemq.client.internal.mqtt.message.auth.MqttAuth;
import com.hivemq.client.internal.mqtt.message.auth.MqttAuthBuilder;
import com.hivemq.client.internal.util.Checks;
import com.hivemq.client.mqtt.mqtt5.auth.Mqtt5EnhancedAuthMechanism;
import com.hivemq.client.mqtt.mqtt5.exceptions.Mqtt5AuthException;
import com.hivemq.client.mqtt.mqtt5.message.auth.Mqtt5AuthReasonCode;
import com.hivemq.client.mqtt.mqtt5.message.disconnect.Mqtt5DisconnectReasonCode;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class AbstractMqttAuthHandler
extends MqttTimeoutInboundHandler
implements MqttAuthHandler {
    @NotNull
    static final InternalLogger LOGGER = InternalLoggerFactory.getLogger(AbstractMqttAuthHandler.class);
    @NotNull
    final MqttClientConfig clientConfig;
    @NotNull
    final Mqtt5EnhancedAuthMechanism authMechanism;
    @NotNull
    MqttAuthState state = MqttAuthState.NONE;

    AbstractMqttAuthHandler(@NotNull MqttClientConfig clientConfig, @NotNull Mqtt5EnhancedAuthMechanism authMechanism) {
        this.clientConfig = clientConfig;
        this.authMechanism = authMechanism;
    }

    final void readAuth(@NotNull ChannelHandlerContext ctx, @NotNull MqttAuth auth) {
        this.cancelTimeout();
        if (this.validateAuth(ctx, auth)) {
            switch ((Mqtt5AuthReasonCode)auth.getReasonCode()) {
                case CONTINUE_AUTHENTICATION: {
                    this.readAuthContinue(ctx, auth);
                    break;
                }
                case SUCCESS: {
                    this.readAuthSuccess(ctx, auth);
                    break;
                }
                case REAUTHENTICATE: {
                    this.readReAuth(ctx, auth);
                }
            }
        }
    }

    private boolean validateAuth(@NotNull ChannelHandlerContext ctx, @NotNull MqttAuth auth) {
        if (!auth.getMethod().equals(this.getMethod())) {
            MqttDisconnectUtil.disconnect(ctx.channel(), Mqtt5DisconnectReasonCode.PROTOCOL_ERROR, new Mqtt5AuthException(auth, "Auth method in AUTH must be the same as in the CONNECT."));
            return false;
        }
        return true;
    }

    private void readAuthContinue(@NotNull ChannelHandlerContext ctx, @NotNull MqttAuth auth) {
        if (this.state != MqttAuthState.WAIT_FOR_SERVER) {
            MqttDisconnectUtil.disconnect(ctx.channel(), Mqtt5DisconnectReasonCode.PROTOCOL_ERROR, new Mqtt5AuthException(auth, "Must not receive AUTH with reason code CONTINUE_AUTHENTICATION if client side AUTH is pending."));
            return;
        }
        MqttAuthBuilder authBuilder = new MqttAuthBuilder(Mqtt5AuthReasonCode.CONTINUE_AUTHENTICATION, this.getMethod());
        this.state = MqttAuthState.IN_PROGRESS_RESPONSE;
        this.callMechanismFutureResult(() -> this.authMechanism.onContinue(this.clientConfig, auth, authBuilder), ctx2 -> {
            this.state = MqttAuthState.WAIT_FOR_SERVER;
            ctx2.writeAndFlush((Object)authBuilder.build()).addListener((GenericFutureListener)this);
        }, (ctx2, throwable) -> MqttDisconnectUtil.disconnect(ctx2.channel(), Mqtt5DisconnectReasonCode.NOT_AUTHORIZED, new Mqtt5AuthException(auth, "Server auth not accepted.")));
    }

    abstract void readAuthSuccess(@NotNull ChannelHandlerContext var1, @NotNull MqttAuth var2);

    abstract void readReAuth(@NotNull ChannelHandlerContext var1, @NotNull MqttAuth var2);

    void callMechanism(@NotNull Runnable call) {
        try {
            call.run();
        }
        catch (Throwable throwable) {
            LOGGER.error("Auth cancelled. Unexpected exception thrown by auth mechanism.", throwable);
        }
    }

    void callMechanismFuture(@NotNull @NotNull Supplier<@NotNull CompletableFuture<Void>> supplier, @NotNull @NotNull Consumer<@NotNull ChannelHandlerContext> onSuccess, @NotNull @NotNull BiConsumer<@NotNull ChannelHandlerContext, @NotNull Throwable> onError) {
        if (this.ctx == null) {
            return;
        }
        try {
            supplier.get().whenComplete((aVoid, throwable) -> this.clientConfig.executeInEventLoop(() -> {
                if (this.ctx == null) {
                    return;
                }
                if (throwable != null) {
                    LOGGER.error("Auth cancelled. Unexpected exception thrown by auth mechanism.", (Throwable)throwable);
                    onError.accept(this.ctx, (Throwable)throwable);
                } else {
                    onSuccess.accept(this.ctx);
                }
            }));
        }
        catch (Throwable throwable2) {
            LOGGER.error("Auth cancelled. Unexpected exception thrown by auth mechanism.", throwable2);
            onError.accept(this.ctx, throwable2);
        }
    }

    void callMechanismFutureResult(@NotNull @NotNull Supplier<@NotNull CompletableFuture<Boolean>> supplier, @NotNull @NotNull Consumer<@NotNull ChannelHandlerContext> onSuccess, @NotNull @NotNull BiConsumer<@NotNull ChannelHandlerContext, @Nullable Throwable> onError) {
        if (this.ctx == null) {
            return;
        }
        try {
            supplier.get().whenComplete((accepted, throwable) -> this.clientConfig.executeInEventLoop(() -> {
                if (this.ctx == null) {
                    return;
                }
                if (throwable != null) {
                    LOGGER.error("Auth cancelled. Unexpected exception thrown by auth mechanism.", (Throwable)throwable);
                    onError.accept(this.ctx, (Throwable)throwable);
                } else if (accepted == null) {
                    LOGGER.error("Auth cancelled. Unexpected null result returned by auth mechanism.");
                    onError.accept(this.ctx, new NullPointerException("Result returned by auth mechanism must not be null."));
                } else if (!accepted.booleanValue()) {
                    onError.accept(this.ctx, null);
                } else {
                    onSuccess.accept(this.ctx);
                }
            }));
        }
        catch (Throwable throwable2) {
            LOGGER.error("Auth cancelled. Unexpected exception thrown by auth mechanism.", throwable2);
            onError.accept(this.ctx, throwable2);
        }
    }

    @NotNull
    MqttUtf8StringImpl getMethod() {
        return Checks.notImplemented(this.authMechanism.getMethod(), MqttUtf8StringImpl.class, "Auth method");
    }

    @Override
    protected final long getTimeout() {
        return this.authMechanism.getTimeout();
    }

    @Override
    @NotNull
    protected final Mqtt5DisconnectReasonCode getTimeoutReasonCode() {
        return Mqtt5DisconnectReasonCode.NOT_AUTHORIZED;
    }

    static enum MqttAuthState {
        NONE,
        WAIT_FOR_SERVER,
        IN_PROGRESS_INIT,
        IN_PROGRESS_RESPONSE,
        IN_PROGRESS_DONE;

    }
}

