/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.handler.ssl;

import com.hivemq.client.internal.mqtt.MqttClientSslConfigImpl;
import com.hivemq.client.internal.util.collections.ImmutableList;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.DelegatingSslContext;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SupportedCipherSuiteFilter;
import java.net.InetSocketAddress;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import org.jetbrains.annotations.NotNull;

public final class SslUtil {
    @NotNull
    private static final String SSL_HANDLER_NAME = "ssl";

    public static void initChannel(@NotNull Channel channel, @NotNull MqttClientSslConfigImpl sslConfig, @NotNull InetSocketAddress address) throws SSLException {
        channel.pipeline().addFirst(SSL_HANDLER_NAME, (ChannelHandler)SslUtil.createSslHandler(channel, sslConfig, address));
    }

    @NotNull
    private static SslHandler createSslHandler(@NotNull Channel channel, @NotNull MqttClientSslConfigImpl sslConfig, @NotNull InetSocketAddress address) throws SSLException {
        return SslUtil.createSslContext(sslConfig).newHandler(channel.alloc(), address.getHostString(), address.getPort());
    }

    @NotNull
    static SslContext createSslContext(final @NotNull MqttClientSslConfigImpl sslConfig) throws SSLException {
        ImmutableList<String> protocols = sslConfig.getRawProtocols();
        SslContext sslContext = SslContextBuilder.forClient().trustManager(sslConfig.getRawTrustManagerFactory()).keyManager(sslConfig.getRawKeyManagerFactory()).protocols(protocols == null ? null : protocols.toArray(new String[0])).ciphers(sslConfig.getRawCipherSuites(), (CipherSuiteFilter)SupportedCipherSuiteFilter.INSTANCE).build();
        return new DelegatingSslContext(sslContext){

            protected void initEngine(@NotNull SSLEngine engine) {
            }

            protected void initHandler(@NotNull SslHandler handler) {
                handler.setHandshakeTimeoutMillis(sslConfig.getHandshakeTimeoutMs());
            }
        };
    }

    private SslUtil() {
    }
}

