/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.handler.util;

import com.hivemq.client.internal.annotations.CallByThread;
import com.hivemq.client.internal.mqtt.handler.MqttConnectionAwareHandler;
import com.hivemq.client.internal.mqtt.handler.disconnect.MqttDisconnectEvent;
import com.hivemq.client.internal.mqtt.handler.disconnect.MqttDisconnectUtil;
import com.hivemq.client.mqtt.mqtt5.message.disconnect.Mqtt5DisconnectReasonCode;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.ScheduledFuture;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MqttTimeoutInboundHandler
extends MqttConnectionAwareHandler
implements Runnable,
ChannelFutureListener {
    @Nullable
    private ScheduledFuture<?> timeoutFuture;

    public void operationComplete(@NotNull ChannelFuture future) throws Exception {
        if (this.ctx == null) {
            return;
        }
        Throwable cause = future.cause();
        if (cause == null) {
            this.operationSuccessful(this.ctx);
        } else if (!(cause instanceof IOException)) {
            this.exceptionCaught(this.ctx, cause);
        }
    }

    protected void operationSuccessful(@NotNull ChannelHandlerContext ctx) {
        this.scheduleTimeout(ctx.channel());
    }

    @Override
    @CallByThread(value="Netty EventLoop")
    public void run() {
        if (this.ctx == null) {
            return;
        }
        Channel channel = this.ctx.channel();
        if (channel.isActive()) {
            MqttDisconnectUtil.disconnect(channel, this.getTimeoutReasonCode(), this.getTimeoutReasonString());
        } else {
            MqttDisconnectUtil.close(channel, this.getTimeoutReasonString());
        }
    }

    @CallByThread(value="Netty EventLoop")
    protected void scheduleTimeout(@NotNull Channel channel) {
        if (this.timeoutFuture != null) {
            this.timeoutFuture.cancel(false);
            this.timeoutFuture = null;
            this.run();
        } else {
            this.timeoutFuture = channel.eventLoop().schedule((Runnable)this, this.getTimeout(), TimeUnit.SECONDS);
        }
    }

    @CallByThread(value="Netty EventLoop")
    protected void cancelTimeout() {
        if (this.timeoutFuture != null) {
            this.timeoutFuture.cancel(false);
            this.timeoutFuture = null;
        }
    }

    @Override
    protected void onDisconnectEvent(@NotNull ChannelHandlerContext ctx, @NotNull MqttDisconnectEvent disconnectEvent) {
        this.cancelTimeout();
    }

    protected abstract long getTimeout();

    @NotNull
    protected abstract Mqtt5DisconnectReasonCode getTimeoutReasonCode();

    @NotNull
    protected abstract String getTimeoutReasonString();
}

