/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.lifecycle;

import com.hivemq.client.internal.mqtt.lifecycle.MqttClientAutoReconnectImpl;
import com.hivemq.client.internal.util.Checks;
import com.hivemq.client.mqtt.lifecycle.MqttClientAutoReconnectBuilder;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MqttClientAutoReconnectImplBuilder<B extends MqttClientAutoReconnectImplBuilder<B>> {
    private long initialDelayNanos = MqttClientAutoReconnectImpl.DEFAULT_START_DELAY_NANOS;
    private long maxDelayNanos = MqttClientAutoReconnectImpl.DEFAULT_MAX_DELAY_NANOS;

    MqttClientAutoReconnectImplBuilder() {
    }

    MqttClientAutoReconnectImplBuilder(@Nullable MqttClientAutoReconnectImpl autoReconnect) {
        if (autoReconnect != null) {
            this.initialDelayNanos = autoReconnect.getInitialDelay(TimeUnit.NANOSECONDS);
            this.maxDelayNanos = autoReconnect.getMaxDelay(TimeUnit.NANOSECONDS);
        }
    }

    @NotNull
    abstract B self();

    @NotNull
    public B initialDelay(long initialDelay, @Nullable TimeUnit timeUnit) {
        if (initialDelay <= 0L) {
            throw new IllegalArgumentException("Initial delay must be positive.");
        }
        Checks.notNull(timeUnit, "Time unit");
        this.initialDelayNanos = TimeUnit.NANOSECONDS.convert(initialDelay, timeUnit);
        return this.self();
    }

    @NotNull
    public B maxDelay(long maxDelay, @Nullable TimeUnit timeUnit) {
        if (maxDelay < 0L) {
            throw new IllegalArgumentException("Maximum delay must be positive or zero.");
        }
        Checks.notNull(timeUnit, "Time unit");
        this.maxDelayNanos = TimeUnit.NANOSECONDS.convert(maxDelay, timeUnit);
        return this.self();
    }

    @NotNull
    public MqttClientAutoReconnectImpl build() {
        return new MqttClientAutoReconnectImpl(this.initialDelayNanos, this.maxDelayNanos);
    }

    public static class Nested<P>
    extends MqttClientAutoReconnectImplBuilder<Nested<P>>
    implements MqttClientAutoReconnectBuilder.Nested<P> {
        @NotNull
        private final Function<? super MqttClientAutoReconnectImpl, P> parentConsumer;

        public Nested(@Nullable MqttClientAutoReconnectImpl autoReconnect, @NotNull Function<? super MqttClientAutoReconnectImpl, P> parentConsumer) {
            super(autoReconnect);
            this.parentConsumer = parentConsumer;
        }

        @Override
        @NotNull
        Nested<P> self() {
            return this;
        }

        @Override
        @NotNull
        public P applyAutomaticReconnect() {
            return this.parentConsumer.apply(this.build());
        }
    }

    public static class Default
    extends MqttClientAutoReconnectImplBuilder<Default>
    implements MqttClientAutoReconnectBuilder {
        public Default() {
        }

        Default(@Nullable MqttClientAutoReconnectImpl autoReconnect) {
            super(autoReconnect);
        }

        @Override
        @NotNull
        Default self() {
            return this;
        }
    }
}

