/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.lifecycle.mqtt3;

import com.hivemq.client.internal.mqtt.MqttClientTransportConfigImpl;
import com.hivemq.client.internal.mqtt.MqttClientTransportConfigImplBuilder;
import com.hivemq.client.internal.mqtt.lifecycle.MqttClientReconnector;
import com.hivemq.client.internal.mqtt.message.connect.mqtt3.Mqtt3ConnectView;
import com.hivemq.client.internal.mqtt.message.connect.mqtt3.Mqtt3ConnectViewBuilder;
import com.hivemq.client.internal.mqtt.util.MqttChecks;
import com.hivemq.client.mqtt.MqttClientTransportConfig;
import com.hivemq.client.mqtt.mqtt3.lifecycle.Mqtt3ClientReconnector;
import com.hivemq.client.mqtt.mqtt3.message.connect.Mqtt3Connect;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Mqtt3ClientReconnectorView
implements Mqtt3ClientReconnector {
    @NotNull
    private final MqttClientReconnector delegate;

    Mqtt3ClientReconnectorView(@NotNull MqttClientReconnector delegate) {
        this.delegate = delegate;
    }

    @Override
    @NotNull
    public Mqtt3ClientReconnectorView reconnect(boolean reconnect) {
        this.delegate.reconnect(reconnect);
        return this;
    }

    @Override
    @NotNull
    public <T> Mqtt3ClientReconnector reconnectWhen(@Nullable CompletableFuture<T> future, @Nullable BiConsumer<? super T, ? super Throwable> callback) {
        this.delegate.reconnectWhen((CompletableFuture)future, (BiConsumer)callback);
        return this;
    }

    @Override
    public boolean isReconnect() {
        return this.delegate.isReconnect();
    }

    @Override
    public int getAttempts() {
        return this.delegate.getAttempts();
    }

    @Override
    @NotNull
    public Mqtt3ClientReconnectorView delay(long delay, @Nullable TimeUnit timeUnit) {
        this.delegate.delay(delay, timeUnit);
        return this;
    }

    @Override
    public long getDelay(@NotNull TimeUnit timeUnit) {
        return this.delegate.getDelay(timeUnit);
    }

    @Override
    @NotNull
    public Mqtt3ClientReconnectorView transportConfig(@Nullable MqttClientTransportConfig transportConfig) {
        this.delegate.transportConfig(transportConfig);
        return this;
    }

    @NotNull
    public MqttClientTransportConfigImplBuilder.Nested<Mqtt3ClientReconnectorView> transportConfig() {
        return new MqttClientTransportConfigImplBuilder.Nested<Mqtt3ClientReconnectorView>(this.getTransportConfig(), this::transportConfig);
    }

    @Override
    @NotNull
    public MqttClientTransportConfigImpl getTransportConfig() {
        return this.delegate.getTransportConfig();
    }

    @Override
    @NotNull
    public Mqtt3ClientReconnectorView connect(@Nullable Mqtt3Connect connect) {
        this.delegate.connect(MqttChecks.connect(connect));
        return this;
    }

    @NotNull
    public Mqtt3ConnectViewBuilder.Nested<Mqtt3ClientReconnectorView> connectWith() {
        return new Mqtt3ConnectViewBuilder.Nested<Mqtt3ClientReconnectorView>(this.getConnect(), this::connect);
    }

    @Override
    @NotNull
    public Mqtt3ConnectView getConnect() {
        return Mqtt3ConnectView.of(this.delegate.getConnect());
    }
}

