/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.message.publish.mqtt3;

import com.hivemq.client.annotations.Immutable;
import com.hivemq.client.internal.mqtt.datatypes.MqttTopicImpl;
import com.hivemq.client.internal.mqtt.datatypes.MqttUserPropertiesImpl;
import com.hivemq.client.internal.mqtt.message.publish.MqttPublish;
import com.hivemq.client.internal.mqtt.message.publish.MqttStatefulPublish;
import com.hivemq.client.internal.mqtt.message.publish.MqttWillPublish;
import com.hivemq.client.internal.mqtt.message.publish.mqtt3.Mqtt3PublishViewBuilder;
import com.hivemq.client.mqtt.datatypes.MqttQos;
import com.hivemq.client.mqtt.datatypes.MqttTopic;
import com.hivemq.client.mqtt.mqtt3.message.publish.Mqtt3Publish;
import com.hivemq.client.mqtt.mqtt5.message.publish.Mqtt5Publish;
import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Immutable
public class Mqtt3PublishView
implements Mqtt3Publish {
    @NotNull
    public static final io.reactivex.functions.Function<Mqtt5Publish, Mqtt3Publish> MAPPER = Mqtt3PublishView::of;
    @NotNull
    public static final Function<Mqtt5Publish, Mqtt3Publish> JAVA_MAPPER = Mqtt3PublishView::of;
    @NotNull
    private final MqttPublish delegate;

    @NotNull
    public static MqttPublish delegate(@NotNull MqttTopicImpl topic, @Nullable ByteBuffer payload, @NotNull MqttQos qos, boolean retain) {
        return new MqttPublish(topic, payload, qos, retain, Long.MAX_VALUE, null, null, null, null, MqttUserPropertiesImpl.NO_USER_PROPERTIES);
    }

    @NotNull
    public static MqttStatefulPublish statefulDelegate(@NotNull MqttPublish publish, int packetIdentifier, boolean dup) {
        return publish.createStateful(packetIdentifier, dup, 0, MqttStatefulPublish.DEFAULT_NO_SUBSCRIPTION_IDENTIFIERS);
    }

    @NotNull
    static Mqtt3PublishView of(@NotNull MqttTopicImpl topic, @Nullable ByteBuffer payload, @NotNull MqttQos qos, boolean retain) {
        return new Mqtt3PublishView(Mqtt3PublishView.delegate(topic, payload, qos, retain));
    }

    @NotNull
    static Mqtt3PublishView willOf(@NotNull MqttTopicImpl topic, @Nullable ByteBuffer payload, @NotNull MqttQos qos, boolean retain) {
        return new Mqtt3PublishView(new MqttWillPublish(topic, payload, qos, retain, Long.MAX_VALUE, null, null, null, null, MqttUserPropertiesImpl.NO_USER_PROPERTIES, 0L));
    }

    @NotNull
    public static Mqtt3PublishView of(@NotNull Mqtt5Publish publish) {
        return new Mqtt3PublishView((MqttPublish)publish);
    }

    @NotNull
    public static Mqtt3PublishView of(@NotNull MqttPublish publish) {
        return new Mqtt3PublishView(publish);
    }

    private Mqtt3PublishView(@NotNull MqttPublish delegate) {
        this.delegate = delegate;
    }

    @Override
    @NotNull
    public MqttTopic getTopic() {
        return this.delegate.getTopic();
    }

    @Override
    @NotNull
    public Optional<ByteBuffer> getPayload() {
        return this.delegate.getPayload();
    }

    @Override
    @NotNull
    public byte[] getPayloadAsBytes() {
        return this.delegate.getPayloadAsBytes();
    }

    @Override
    @NotNull
    public MqttQos getQos() {
        return this.delegate.getQos();
    }

    @Override
    public boolean isRetain() {
        return this.delegate.isRetain();
    }

    @NotNull
    public MqttPublish getDelegate() {
        return this.delegate;
    }

    @Override
    @NotNull
    public Mqtt3PublishViewBuilder.Default extend() {
        return new Mqtt3PublishViewBuilder.Default(this);
    }

    @NotNull
    private String toAttributeString() {
        return "topic=" + this.getTopic() + (this.delegate.getRawPayload() == null ? "" : ", payload=" + this.delegate.getRawPayload().remaining() + "byte") + ", qos=" + (Object)((Object)this.getQos()) + ", retain=" + this.isRetain();
    }

    @NotNull
    public String toString() {
        return "MqttPublish{" + this.toAttributeString() + '}';
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Mqtt3PublishView)) {
            return false;
        }
        Mqtt3PublishView that = (Mqtt3PublishView)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }
}

