/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.rx.operators;

import com.hivemq.client.internal.rx.WithSingleConditionalSubscriber;
import com.hivemq.client.rx.FlowableWithSingle;
import com.hivemq.client.rx.FlowableWithSingleSubscriber;
import com.hivemq.client.rx.reactivestreams.WithSingleSubscriber;
import io.reactivex.Flowable;
import io.reactivex.internal.fuseable.ConditionalSubscriber;
import io.reactivex.internal.util.BackpressureHelper;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

class FlowableWithSingleCombine<F, S>
extends Flowable<Object> {
    @NotNull
    private final FlowableWithSingle<F, S> source;

    FlowableWithSingleCombine(@NotNull FlowableWithSingle<F, S> source) {
        this.source = source;
    }

    protected void subscribeActual(@NotNull Subscriber<? super Object> subscriber) {
        this.source.subscribeBoth(new CombineSubscriber(subscriber));
    }

    static <F, S> void split(@NotNull Flowable<Object> source, @NotNull WithSingleSubscriber<? super F, ? super S> subscriber) {
        if (subscriber instanceof WithSingleConditionalSubscriber) {
            source.subscribe(new SplitSubscriber.Conditional((WithSingleConditionalSubscriber)subscriber));
        } else {
            source.subscribe(new SplitSubscriber.Default<F, S>(subscriber));
        }
    }

    private static class SingleElement {
        @NotNull
        final Object element;

        SingleElement(@NotNull Object element) {
            this.element = element;
        }
    }

    private static abstract class SplitSubscriber<F, S, T extends WithSingleSubscriber<? super F, ? super S>>
    implements ConditionalSubscriber<Object>,
    Subscription {
        @NotNull
        final T subscriber;
        @Nullable
        private Subscription subscription;

        SplitSubscriber(@NotNull T subscriber) {
            this.subscriber = subscriber;
        }

        public void onSubscribe(@NotNull Subscription subscription) {
            this.subscription = subscription;
            this.subscriber.onSubscribe((Subscription)this);
        }

        public void onNext(@NotNull Object o) {
            if (!this.tryOnNext(o)) {
                assert (this.subscription != null);
                this.subscription.request(1L);
            }
        }

        public boolean tryOnNext(@NotNull Object o) {
            if (o instanceof SingleElement) {
                this.subscriber.onSingle((Object)((SingleElement)o).element);
                return false;
            }
            return this.tryOnNextActual(o);
        }

        abstract boolean tryOnNextActual(@NotNull F var1);

        public void onError(@NotNull Throwable throwable) {
            this.subscriber.onError(throwable);
        }

        public void onComplete() {
            this.subscriber.onComplete();
        }

        public void request(long n) {
            assert (this.subscription != null);
            this.subscription.request(n);
        }

        public void cancel() {
            assert (this.subscription != null);
            this.subscription.cancel();
        }

        private static class Conditional<F, S>
        extends SplitSubscriber<F, S, WithSingleConditionalSubscriber<? super F, ? super S>> {
            Conditional(@NotNull WithSingleConditionalSubscriber<? super F, ? super S> subscriber) {
                super(subscriber);
            }

            @Override
            boolean tryOnNextActual(@NotNull F f) {
                return ((WithSingleConditionalSubscriber)this.subscriber).tryOnNext(f);
            }
        }

        private static class Default<F, S>
        extends SplitSubscriber<F, S, WithSingleSubscriber<? super F, ? super S>> {
            Default(@NotNull WithSingleSubscriber<? super F, ? super S> subscriber) {
                super(subscriber);
            }

            @Override
            boolean tryOnNextActual(@NotNull F f) {
                this.subscriber.onNext(f);
                return true;
            }
        }
    }

    private static class CombineSubscriber<F, S>
    implements FlowableWithSingleSubscriber<F, S>,
    Subscription {
        @NotNull
        private final Subscriber<? super Object> subscriber;
        @Nullable
        private Subscription subscription;
        @NotNull
        private final AtomicLong requested = new AtomicLong();
        private final @NotNull AtomicReference<@Nullable Object> queued = new AtomicReference();

        CombineSubscriber(@NotNull Subscriber<? super Object> subscriber) {
            this.subscriber = subscriber;
        }

        public void onSubscribe(@NotNull Subscription subscription) {
            this.subscription = subscription;
            this.subscriber.onSubscribe((Subscription)this);
        }

        @Override
        public void onSingle(@NotNull S s) {
            this.next(new SingleElement(s));
        }

        public void onNext(@NotNull F f) {
            this.next(f);
        }

        private void next(@NotNull Object next) {
            if (this.requested.get() == 0L) {
                this.queued.set(next);
                if (this.requested.get() != 0L && this.queued.getAndSet(null) != null) {
                    BackpressureHelper.produced((AtomicLong)this.requested, (long)1L);
                    this.subscriber.onNext(next);
                }
            } else {
                BackpressureHelper.produced((AtomicLong)this.requested, (long)1L);
                this.subscriber.onNext(next);
            }
        }

        public void onError(@NotNull Throwable throwable) {
            this.subscriber.onError(throwable);
        }

        public void onComplete() {
            this.subscriber.onComplete();
        }

        public void request(long n) {
            assert (this.subscription != null);
            if (n > 0L) {
                Object next;
                if (this.requested.get() == 0L && (next = this.queued.getAndSet(null)) != null) {
                    this.subscriber.onNext(next);
                    --n;
                }
                if (n > 0L) {
                    BackpressureHelper.add((AtomicLong)this.requested, (long)n);
                    this.subscription.request(n);
                }
            }
        }

        public void cancel() {
            assert (this.subscription != null);
            this.subscription.cancel();
        }
    }
}

