/*
 * Decompiled with CFR 0.152.
 */
package xcrash;

import android.app.Application;
import android.content.Context;
import android.os.Build;
import android.os.Process;
import android.text.TextUtils;
import xcrash.ActivityMonitor;
import xcrash.AnrHandler;
import xcrash.DefaultLogger;
import xcrash.FileManager;
import xcrash.ICrashCallback;
import xcrash.ILibLoader;
import xcrash.ILogger;
import xcrash.JavaCrashHandler;
import xcrash.NativeHandler;
import xcrash.Util;

public final class XCrash {
    private static boolean initialized = false;
    private static String appId = null;
    private static String appVersion = null;
    private static String logDir = null;
    private static ILogger logger = new DefaultLogger();

    private XCrash() {
    }

    public static int init(Context ctx) {
        return XCrash.init(ctx, null);
    }

    public static synchronized int init(Context ctx, InitParameters params) {
        String packageName;
        if (initialized) {
            return 0;
        }
        initialized = true;
        if (ctx == null) {
            return -1;
        }
        Context appContext = ctx.getApplicationContext();
        if (appContext != null) {
            ctx = appContext;
        }
        if (params == null) {
            params = new InitParameters();
        }
        if (params.logger != null) {
            logger = params.logger;
        }
        if (TextUtils.isEmpty((CharSequence)(appId = (packageName = ctx.getPackageName())))) {
            appId = "unknown";
        }
        if (TextUtils.isEmpty((CharSequence)params.appVersion)) {
            params.appVersion = Util.getAppVersion(ctx);
        }
        appVersion = params.appVersion;
        if (TextUtils.isEmpty((CharSequence)params.logDir)) {
            params.logDir = ctx.getFilesDir() + "/tombstones";
        }
        logDir = params.logDir;
        int pid = Process.myPid();
        String processName = null;
        if (params.enableJavaCrashHandler || params.enableAnrHandler) {
            processName = Util.getProcessName(ctx, pid);
            if (params.enableAnrHandler && (TextUtils.isEmpty((CharSequence)processName) || !processName.equals(packageName))) {
                params.enableAnrHandler = false;
            }
        }
        FileManager.getInstance().initialize(params.logDir, params.javaLogCountMax, params.nativeLogCountMax, params.anrLogCountMax, params.placeholderCountMax, params.placeholderSizeKb, params.logFileMaintainDelayMs);
        if ((params.enableJavaCrashHandler && !params.javaRethrow || params.enableNativeCrashHandler && !params.nativeRethrow) && ctx instanceof Application) {
            ActivityMonitor.getInstance().initialize((Application)ctx);
        }
        if (params.enableJavaCrashHandler) {
            JavaCrashHandler.getInstance().initialize(pid, processName, appId, params.appVersion, params.logDir, params.javaRethrow, params.javaLogcatSystemLines, params.javaLogcatEventsLines, params.javaLogcatMainLines, params.javaDumpFds, params.javaDumpAllThreads, params.javaDumpAllThreadsCountMax, params.javaDumpAllThreadsWhiteList, params.javaCallback);
        }
        if (params.enableAnrHandler && Build.VERSION.SDK_INT < 21) {
            AnrHandler.getInstance().initialize(ctx, pid, processName, appId, params.appVersion, params.logDir, params.anrCheckProcessState, params.anrLogcatSystemLines, params.anrLogcatEventsLines, params.anrLogcatMainLines, params.anrDumpFds, params.anrCallback);
        }
        int r = 0;
        if (params.enableNativeCrashHandler || params.enableAnrHandler && Build.VERSION.SDK_INT >= 21) {
            r = NativeHandler.getInstance().initialize(ctx, params.libLoader, appId, params.appVersion, params.logDir, params.enableNativeCrashHandler, params.nativeRethrow, params.nativeLogcatSystemLines, params.nativeLogcatEventsLines, params.nativeLogcatMainLines, params.nativeDumpElfHash, params.nativeDumpMap, params.nativeDumpFds, params.nativeDumpAllThreads, params.nativeDumpAllThreadsCountMax, params.nativeDumpAllThreadsWhiteList, params.nativeCallback, params.enableAnrHandler && Build.VERSION.SDK_INT >= 21, params.anrRethrow, params.anrCheckProcessState, params.anrLogcatSystemLines, params.anrLogcatEventsLines, params.anrLogcatMainLines, params.anrDumpFds, params.anrCallback);
        }
        FileManager.getInstance().maintain();
        return r;
    }

    static String getAppId() {
        return appId;
    }

    static String getAppVersion() {
        return appVersion;
    }

    static String getLogDir() {
        return logDir;
    }

    static ILogger getLogger() {
        return logger;
    }

    public static void testJavaCrash(boolean runInNewThread) throws RuntimeException {
        if (!runInNewThread) {
            throw new RuntimeException("test java exception");
        }
        Thread thread = new Thread(){

            @Override
            public void run() {
                throw new RuntimeException("test java exception");
            }
        };
        thread.setName("xcrash_test_java_thread");
        thread.start();
    }

    public static void testNativeCrash(boolean runInNewThread) {
        NativeHandler.getInstance().testNativeCrash(runInNewThread);
    }

    public static class InitParameters {
        String appVersion = null;
        String logDir = null;
        int logFileMaintainDelayMs = 5000;
        ILogger logger = null;
        ILibLoader libLoader = null;
        int placeholderCountMax = 0;
        int placeholderSizeKb = 128;
        boolean enableJavaCrashHandler = true;
        boolean javaRethrow = true;
        int javaLogCountMax = 10;
        int javaLogcatSystemLines = 50;
        int javaLogcatEventsLines = 50;
        int javaLogcatMainLines = 200;
        boolean javaDumpFds = true;
        boolean javaDumpAllThreads = true;
        int javaDumpAllThreadsCountMax = 0;
        String[] javaDumpAllThreadsWhiteList = null;
        ICrashCallback javaCallback = null;
        boolean enableNativeCrashHandler = true;
        boolean nativeRethrow = true;
        int nativeLogCountMax = 10;
        int nativeLogcatSystemLines = 50;
        int nativeLogcatEventsLines = 50;
        int nativeLogcatMainLines = 200;
        boolean nativeDumpElfHash = true;
        boolean nativeDumpMap = true;
        boolean nativeDumpFds = true;
        boolean nativeDumpAllThreads = true;
        int nativeDumpAllThreadsCountMax = 0;
        String[] nativeDumpAllThreadsWhiteList = null;
        ICrashCallback nativeCallback = null;
        boolean enableAnrHandler = true;
        boolean anrRethrow = true;
        boolean anrCheckProcessState = true;
        int anrLogCountMax = 10;
        int anrLogcatSystemLines = 50;
        int anrLogcatEventsLines = 50;
        int anrLogcatMainLines = 200;
        boolean anrDumpFds = true;
        ICrashCallback anrCallback = null;

        public InitParameters setAppVersion(String appVersion) {
            this.appVersion = appVersion;
            return this;
        }

        public InitParameters setLogDir(String dir) {
            this.logDir = dir;
            return this;
        }

        public InitParameters setLogFileMaintainDelayMs(int logFileMaintainDelayMs) {
            this.logFileMaintainDelayMs = logFileMaintainDelayMs < 0 ? 0 : logFileMaintainDelayMs;
            return this;
        }

        public InitParameters setLogger(ILogger logger) {
            this.logger = logger;
            return this;
        }

        public InitParameters setLibLoader(ILibLoader libLoader) {
            this.libLoader = libLoader;
            return this;
        }

        public InitParameters setPlaceholderCountMax(int countMax) {
            this.placeholderCountMax = countMax < 0 ? 0 : countMax;
            return this;
        }

        public InitParameters setPlaceholderSizeKb(int sizeKb) {
            this.placeholderSizeKb = sizeKb < 0 ? 0 : sizeKb;
            return this;
        }

        public InitParameters enableJavaCrashHandler() {
            this.enableJavaCrashHandler = true;
            return this;
        }

        public InitParameters disableJavaCrashHandler() {
            this.enableJavaCrashHandler = false;
            return this;
        }

        public InitParameters setJavaRethrow(boolean rethrow) {
            this.javaRethrow = rethrow;
            return this;
        }

        public InitParameters setJavaLogCountMax(int countMax) {
            this.javaLogCountMax = countMax < 1 ? 1 : countMax;
            return this;
        }

        public InitParameters setJavaLogcatSystemLines(int logcatSystemLines) {
            this.javaLogcatSystemLines = logcatSystemLines;
            return this;
        }

        public InitParameters setJavaLogcatEventsLines(int logcatEventsLines) {
            this.javaLogcatEventsLines = logcatEventsLines;
            return this;
        }

        public InitParameters setJavaLogcatMainLines(int logcatMainLines) {
            this.javaLogcatMainLines = logcatMainLines;
            return this;
        }

        public InitParameters setJavaDumpFds(boolean flag) {
            this.javaDumpFds = flag;
            return this;
        }

        public InitParameters setJavaDumpAllThreads(boolean flag) {
            this.javaDumpAllThreads = flag;
            return this;
        }

        public InitParameters setJavaDumpAllThreadsCountMax(int countMax) {
            this.javaDumpAllThreadsCountMax = countMax < 0 ? 0 : countMax;
            return this;
        }

        public InitParameters setJavaDumpAllThreadsWhiteList(String[] whiteList) {
            this.javaDumpAllThreadsWhiteList = whiteList;
            return this;
        }

        public InitParameters setJavaCallback(ICrashCallback callback) {
            this.javaCallback = callback;
            return this;
        }

        public InitParameters enableNativeCrashHandler() {
            this.enableNativeCrashHandler = true;
            return this;
        }

        public InitParameters disableNativeCrashHandler() {
            this.enableNativeCrashHandler = false;
            return this;
        }

        public InitParameters setNativeRethrow(boolean rethrow) {
            this.nativeRethrow = rethrow;
            return this;
        }

        public InitParameters setNativeLogCountMax(int countMax) {
            this.nativeLogCountMax = countMax < 1 ? 1 : countMax;
            return this;
        }

        public InitParameters setNativeLogcatSystemLines(int logcatSystemLines) {
            this.nativeLogcatSystemLines = logcatSystemLines;
            return this;
        }

        public InitParameters setNativeLogcatEventsLines(int logcatEventsLines) {
            this.nativeLogcatEventsLines = logcatEventsLines;
            return this;
        }

        public InitParameters setNativeLogcatMainLines(int logcatMainLines) {
            this.nativeLogcatMainLines = logcatMainLines;
            return this;
        }

        public InitParameters setNativeDumpElfHash(boolean flag) {
            this.nativeDumpElfHash = flag;
            return this;
        }

        public InitParameters setNativeDumpMap(boolean flag) {
            this.nativeDumpMap = flag;
            return this;
        }

        public InitParameters setNativeDumpFds(boolean flag) {
            this.nativeDumpFds = flag;
            return this;
        }

        public InitParameters setNativeDumpAllThreads(boolean flag) {
            this.nativeDumpAllThreads = flag;
            return this;
        }

        public InitParameters setNativeDumpAllThreadsCountMax(int countMax) {
            this.nativeDumpAllThreadsCountMax = countMax < 0 ? 0 : countMax;
            return this;
        }

        public InitParameters setNativeDumpAllThreadsWhiteList(String[] whiteList) {
            this.nativeDumpAllThreadsWhiteList = whiteList;
            return this;
        }

        public InitParameters setNativeCallback(ICrashCallback callback) {
            this.nativeCallback = callback;
            return this;
        }

        public InitParameters enableAnrCrashHandler() {
            this.enableAnrHandler = true;
            return this;
        }

        public InitParameters disableAnrCrashHandler() {
            this.enableAnrHandler = false;
            return this;
        }

        public InitParameters setAnrRethrow(boolean rethrow) {
            this.anrRethrow = rethrow;
            return this;
        }

        public InitParameters setAnrCheckProcessState(boolean checkProcessState) {
            this.anrCheckProcessState = checkProcessState;
            return this;
        }

        public InitParameters setAnrLogCountMax(int countMax) {
            this.anrLogCountMax = countMax < 1 ? 1 : countMax;
            return this;
        }

        public InitParameters setAnrLogcatSystemLines(int logcatSystemLines) {
            this.anrLogcatSystemLines = logcatSystemLines;
            return this;
        }

        public InitParameters setAnrLogcatEventsLines(int logcatEventsLines) {
            this.anrLogcatEventsLines = logcatEventsLines;
            return this;
        }

        public InitParameters setAnrLogcatMainLines(int logcatMainLines) {
            this.anrLogcatMainLines = logcatMainLines;
            return this;
        }

        public InitParameters setAnrDumpFds(boolean flag) {
            this.anrDumpFds = flag;
            return this;
        }

        public InitParameters setAnrCallback(ICrashCallback callback) {
            this.anrCallback = callback;
            return this;
        }
    }
}

