/*
 * Decompiled with CFR 0.152.
 */
package butterknife.lint;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.Set;
import lombok.ast.Annotation;
import lombok.ast.AstVisitor;
import lombok.ast.ClassDeclaration;
import lombok.ast.ForwardingAstVisitor;
import lombok.ast.Identifier;
import lombok.ast.Node;
import lombok.ast.Select;
import lombok.ast.VariableReference;

public class InvalidR2UsageDetector
extends Detector
implements Detector.JavaScanner {
    private static final String LINT_ERROR_BODY = "R2 should only be used inside annotations";
    private static final String LINT_ERROR_TITLE = "Invalid usage of R2";
    private static final String ISSUE_ID = "InvalidR2Usage";
    private static final Set<String> SUPPORTED_TYPES = ImmutableSet.of((Object)"array", (Object)"attr", (Object)"bool", (Object)"color", (Object)"dimen", (Object)"drawable", (Object[])new String[]{"id", "integer", "string"});
    static final Issue ISSUE = Issue.create((String)"InvalidR2Usage", (String)"Invalid usage of R2", (String)"R2 should only be used inside annotations", (Category)Category.CORRECTNESS, (int)6, (Severity)Severity.ERROR, (Implementation)new Implementation(InvalidR2UsageDetector.class, Scope.JAVA_FILE_SCOPE));
    private static final String R2 = "R2";

    public boolean appliesTo(Context context, File file) {
        String name = file.getName();
        return !name.contains("_ViewBinder") && !name.contains("_ViewBinding");
    }

    public AstVisitor createJavaVisitor(JavaContext javaContext) {
        final JavaContext context = javaContext;
        return new ForwardingAstVisitor(){

            public boolean visitClassDeclaration(ClassDeclaration node) {
                return InvalidR2UsageDetector.R2.equals(node.astName().astValue());
            }

            public boolean visitAnnotation(Annotation node) {
                return true;
            }

            public boolean visitSelect(Select node) {
                return InvalidR2UsageDetector.detectR2(context, (Node)node, node.astIdentifier());
            }

            public boolean visitVariableReference(VariableReference node) {
                return InvalidR2UsageDetector.detectR2(context, (Node)node, node.astIdentifier());
            }
        };
    }

    private static boolean detectR2(JavaContext context, Node node, Identifier identifier) {
        boolean isR2;
        boolean bl = isR2 = node.getParent() != null && (identifier.toString().equals(R2) || identifier.toString().contains(".R2.")) && node.getParent() instanceof Select && SUPPORTED_TYPES.contains(((Select)node.getParent()).astIdentifier().toString());
        if (isR2 && !context.isSuppressedWithComment(node, ISSUE)) {
            context.report(ISSUE, node, context.getLocation((Node)identifier), LINT_ERROR_BODY);
        }
        return isR2;
    }
}

