/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rxbinding.support.v7.widget;

import android.support.v7.widget.PopupMenu;
import com.jakewharton.rxbinding.internal.Preconditions;
import rx.Observable;
import rx.Subscriber;
import rx.Subscription;
import rx.android.MainThreadSubscription;

final class PopupMenuDismissOnSubscribe
implements Observable.OnSubscribe<Void> {
    final PopupMenu view;

    public PopupMenuDismissOnSubscribe(PopupMenu view) {
        this.view = view;
    }

    public void call(final Subscriber<? super Void> subscriber) {
        Preconditions.checkUiThread();
        PopupMenu.OnDismissListener listener = new PopupMenu.OnDismissListener(){

            public void onDismiss(PopupMenu menu) {
                if (!subscriber.isUnsubscribed()) {
                    subscriber.onNext(null);
                }
            }
        };
        this.view.setOnDismissListener(listener);
        subscriber.add((Subscription)new MainThreadSubscription(){

            protected void onUnsubscribe() {
                PopupMenuDismissOnSubscribe.this.view.setOnDismissListener(null);
            }
        });
    }
}

