/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rxbinding.support.v7.widget;

import android.support.v7.widget.SearchView;
import com.jakewharton.rxbinding.internal.Preconditions;
import com.jakewharton.rxbinding.support.v7.widget.SearchViewQueryTextEvent;
import rx.Observable;
import rx.Subscriber;
import rx.Subscription;
import rx.android.MainThreadSubscription;

final class SearchViewQueryTextChangeEventsOnSubscribe
implements Observable.OnSubscribe<SearchViewQueryTextEvent> {
    final SearchView view;

    SearchViewQueryTextChangeEventsOnSubscribe(SearchView view) {
        this.view = view;
    }

    public void call(final Subscriber<? super SearchViewQueryTextEvent> subscriber) {
        Preconditions.checkUiThread();
        SearchView.OnQueryTextListener watcher = new SearchView.OnQueryTextListener(){

            public boolean onQueryTextChange(String s) {
                if (!subscriber.isUnsubscribed()) {
                    subscriber.onNext((Object)SearchViewQueryTextEvent.create(SearchViewQueryTextChangeEventsOnSubscribe.this.view, s, false));
                    return true;
                }
                return false;
            }

            public boolean onQueryTextSubmit(String query) {
                if (!subscriber.isUnsubscribed()) {
                    subscriber.onNext((Object)SearchViewQueryTextEvent.create(SearchViewQueryTextChangeEventsOnSubscribe.this.view, SearchViewQueryTextChangeEventsOnSubscribe.this.view.getQuery(), true));
                    return true;
                }
                return false;
            }
        };
        this.view.setOnQueryTextListener(watcher);
        subscriber.add((Subscription)new MainThreadSubscription(){

            protected void onUnsubscribe() {
                SearchViewQueryTextChangeEventsOnSubscribe.this.view.setOnQueryTextListener(null);
            }
        });
        subscriber.onNext((Object)SearchViewQueryTextEvent.create(this.view, this.view.getQuery(), false));
    }
}

