/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.restassured.builder;

import com.jayway.restassured.RestAssured;
import com.jayway.restassured.config.RestAssuredConfig;
import com.jayway.restassured.http.ContentType;
import com.jayway.restassured.internal.ResponseParserRegistrar;
import com.jayway.restassured.internal.ResponseSpecificationImpl;
import com.jayway.restassured.internal.SpecificationMerger;
import com.jayway.restassured.parsing.Parser;
import com.jayway.restassured.specification.Argument;
import com.jayway.restassured.specification.ResponseSpecification;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResponseSpecBuilder {
    private final ResponseSpecification spec = new ResponseSpecificationImpl(RestAssured.rootPath, RestAssured.responseContentType(), null, this.getResponseParserRegistrar(), this.restAssuredConfig());

    public ResponseSpecBuilder expectContent(Matcher<?> matcher) {
        this.spec.content(matcher, new Matcher[0]);
        return this;
    }

    public ResponseSpecBuilder expectContent(String path, Matcher<?> matcher) {
        this.spec.content(path, matcher, new Object[0]);
        return this;
    }

    public ResponseSpecBuilder expectContent(String path, List<Argument> arguments, Matcher<?> matcher) {
        this.spec.content(path, arguments, matcher, new Object[0]);
        return this;
    }

    public ResponseSpecBuilder expectStatusCode(Matcher<Integer> expectedStatusCode) {
        this.spec.statusCode(expectedStatusCode);
        return this;
    }

    public ResponseSpecBuilder expectStatusCode(int expectedStatusCode) {
        this.spec.statusCode(expectedStatusCode);
        return this;
    }

    public ResponseSpecBuilder expectStatusLine(Matcher<String> expectedStatusLine) {
        this.spec.statusLine(expectedStatusLine);
        return this;
    }

    public ResponseSpecBuilder expectStatusLine(String expectedStatusLine) {
        this.spec.statusLine(expectedStatusLine);
        return this;
    }

    public ResponseSpecBuilder expectHeaders(Map<String, Object> expectedHeaders) {
        this.spec.headers(expectedHeaders);
        return this;
    }

    public ResponseSpecBuilder expectHeader(String headerName, Matcher<String> expectedValueMatcher) {
        this.spec.header(headerName, expectedValueMatcher);
        return this;
    }

    public ResponseSpecBuilder expectHeader(String headerName, String expectedValue) {
        this.spec.header(headerName, expectedValue);
        return this;
    }

    public ResponseSpecBuilder expectCookies(Map<String, Object> expectedCookies) {
        this.spec.cookies(expectedCookies);
        return this;
    }

    public ResponseSpecBuilder expectCookie(String cookieName, Matcher<String> expectedValueMatcher) {
        this.spec.cookie(cookieName, expectedValueMatcher);
        return this;
    }

    public ResponseSpecBuilder expectCookie(String cookieName, String expectedValue) {
        this.spec.cookie(cookieName, expectedValue);
        return this;
    }

    public ResponseSpecBuilder expectCookie(String cookieName) {
        this.spec.cookie(cookieName);
        return this;
    }

    public ResponseSpecBuilder rootPath(String rootPath) {
        this.spec.rootPath(rootPath);
        return this;
    }

    public ResponseSpecBuilder rootPath(String rootPath, List<Argument> arguments) {
        this.spec.rootPath(rootPath, arguments);
        return this;
    }

    public ResponseSpecBuilder expectContentType(ContentType contentType) {
        this.spec.contentType(contentType);
        return this;
    }

    public ResponseSpecBuilder expectContentType(String contentType) {
        this.spec.contentType(contentType);
        return this;
    }

    public ResponseSpecBuilder expectBody(Matcher<?> matcher) {
        this.spec.body(matcher, new Matcher[0]);
        return this;
    }

    public ResponseSpecBuilder expectBody(String path, Matcher<?> matcher) {
        this.spec.body(path, matcher, new Object[0]);
        return this;
    }

    public ResponseSpecBuilder expectBody(String path, List<Argument> arguments, Matcher<?> matcher) {
        this.spec.body(path, arguments, matcher, new Object[0]);
        return this;
    }

    public ResponseSpecBuilder addResponseSpecification(ResponseSpecification specification) {
        if (!(specification instanceof ResponseSpecificationImpl)) {
            throw new IllegalArgumentException("specification must be of type " + ResponseSpecificationImpl.class.getClass() + ".");
        }
        ResponseSpecificationImpl rs = (ResponseSpecificationImpl)specification;
        SpecificationMerger.merge((ResponseSpecificationImpl)this.spec, rs);
        return this;
    }

    public ResponseSpecBuilder registerParser(String contentType, Parser parser) {
        this.spec.parser(contentType, parser);
        return this;
    }

    public ResponseSpecBuilder setDefaultParser(Parser parser) {
        this.spec.defaultParser(parser);
        return this;
    }

    public ResponseSpecification build() {
        return this.spec;
    }

    private ResponseParserRegistrar getResponseParserRegistrar() {
        ResponseParserRegistrar rpr;
        Field registrarField = null;
        try {
            registrarField = RestAssured.class.getDeclaredField("RESPONSE_PARSER_REGISTRAR");
            try {
                registrarField.setAccessible(true);
                rpr = (ResponseParserRegistrar)registrarField.get(RestAssured.class);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        finally {
            registrarField.setAccessible(false);
        }
        return new ResponseParserRegistrar(rpr);
    }

    private RestAssuredConfig restAssuredConfig() {
        return RestAssured.config == null ? new RestAssuredConfig() : RestAssured.config;
    }
}

