/*
 * Decompiled with CFR 0.152.
 */
package omrecorder;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import omrecorder.PullTransport;
import omrecorder.Recorder;

abstract class AbstractRecorder
implements Recorder {
    protected final PullTransport pullTransport;
    protected final File file;
    private final OutputStream outputStream;

    protected AbstractRecorder(PullTransport pullTransport, File file) {
        this.pullTransport = pullTransport;
        this.file = file;
        this.outputStream = this.outputStream(file);
    }

    @Override
    public void startRecording() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    AbstractRecorder.this.pullTransport.start(AbstractRecorder.this.outputStream);
                }
                catch (IOException e) {
                    new RuntimeException(e);
                }
            }
        }).start();
    }

    private OutputStream outputStream(File file) {
        FileOutputStream outputStream;
        if (file == null) {
            throw new RuntimeException("file is null !");
        }
        try {
            outputStream = new FileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("could not build OutputStream from this file" + file.getName(), e);
        }
        return outputStream;
    }

    @Override
    public void stopRecording() {
        this.pullTransport.stop();
    }

    @Override
    public void pauseRecording() {
        this.pullTransport.source().isEnableToBePulled(false);
    }

    @Override
    public void resumeRecording() {
        this.pullTransport.source().isEnableToBePulled(true);
        this.startRecording();
    }
}

